/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderHelper;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.source.SqlHelpers;
import org.apache.iceberg.flink.source.TestSqlBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.jupiter.api.Test;

public class TestIcebergSourceSql
extends TestSqlBase {
    private static final Schema SCHEMA_TS = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"t1", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)2, (String)"t2", (Type)Types.LongType.get())});

    @Override
    public void before() throws IOException {
        TableEnvironment tableEnvironment = this.getTableEnv();
        Configuration tableConf = tableEnvironment.getConfig().getConfiguration();
        tableConf.setBoolean(FlinkConfigOptions.TABLE_EXEC_ICEBERG_USE_FLIP27_SOURCE.key(), true);
        tableEnvironment.getConfig().set("table.exec.resource.default-parallelism", "1");
        SqlHelpers.sql(tableEnvironment, "create catalog iceberg_catalog with ('type'='iceberg', 'catalog-type'='hadoop', 'warehouse'='%s')", CATALOG_EXTENSION.warehouse());
        SqlHelpers.sql(tableEnvironment, "use catalog iceberg_catalog", new Object[0]);
        tableConf.set(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED, (Object)true);
    }

    private Record generateRecord(Instant t1, long t2) {
        GenericRecord record = GenericRecord.create((Schema)SCHEMA_TS);
        record.setField("t1", (Object)t1.atZone(ZoneId.systemDefault()).toLocalDateTime());
        record.setField("t2", (Object)t2);
        return record;
    }

    private List<Record> generateExpectedRecords(boolean ascending) throws Exception {
        Table table = CATALOG_EXTENSION.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, SCHEMA_TS);
        long baseTime = 1702382109000L;
        GenericAppenderHelper helper = new GenericAppenderHelper(table, FileFormat.PARQUET, this.temporaryFolder);
        Record file1Record1 = this.generateRecord(Instant.ofEpochMilli(baseTime), baseTime + 2592000000L);
        Record file1Record2 = this.generateRecord(Instant.ofEpochMilli(baseTime - 10000L), baseTime + 3024000000L);
        ArrayList recordsDataFile1 = Lists.newArrayList();
        recordsDataFile1.add(file1Record1);
        recordsDataFile1.add(file1Record2);
        DataFile dataFile1 = helper.writeFile((List)recordsDataFile1);
        Record file2Record1 = this.generateRecord(Instant.ofEpochMilli(baseTime + 14000L), baseTime - 2592000000L);
        Record file2Record2 = this.generateRecord(Instant.ofEpochMilli(baseTime + 12000L), baseTime - 3074400000L);
        ArrayList recordsDataFile2 = Lists.newArrayList();
        recordsDataFile2.add(file2Record1);
        recordsDataFile2.add(file2Record2);
        DataFile dataFile2 = helper.writeFile((List)recordsDataFile2);
        helper.appendToTable(new DataFile[]{dataFile1, dataFile2});
        ArrayList expected = Lists.newArrayList();
        if (ascending) {
            expected.addAll(recordsDataFile1);
            expected.addAll(recordsDataFile2);
        } else {
            expected.addAll(recordsDataFile2);
            expected.addAll(recordsDataFile1);
        }
        return expected;
    }

    @Test
    public void testWatermarkOptionsAscending() throws Exception {
        List<Record> expected = this.generateExpectedRecords(true);
        TestHelpers.assertRecordsWithOrder(this.run((Map<String, String>)ImmutableMap.of((Object)"watermark-column", (Object)"t1", (Object)"split-file-open-cost", (Object)"128000000"), "", "*"), expected, SCHEMA_TS);
    }

    @Test
    public void testWatermarkOptionsDescending() throws Exception {
        List<Record> expected = this.generateExpectedRecords(false);
        TestHelpers.assertRecordsWithOrder(this.run((Map<String, String>)ImmutableMap.of((Object)"watermark-column", (Object)"t2", (Object)"watermark-column-time-unit", (Object)"MILLISECONDS", (Object)"split-file-open-cost", (Object)"128000000"), "", "*"), expected, SCHEMA_TS);
    }
}

