/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.flink.source.StreamingStartingStrategy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestScanContext {
    TestScanContext() {
    }

    @Test
    void testIncrementalFromSnapshotId() {
        ScanContext context = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_ID).build();
        this.assertException(context, "Invalid starting snapshot id for SPECIFIC_START_SNAPSHOT_ID strategy: null");
        context = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_ID).startSnapshotId(Long.valueOf(1L)).startSnapshotTimestamp(Long.valueOf(1L)).build();
        this.assertException(context, "Invalid starting snapshot timestamp for SPECIFIC_START_SNAPSHOT_ID strategy: not null");
    }

    @Test
    void testIncrementalFromSnapshotTimestamp() {
        ScanContext context = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP).build();
        this.assertException(context, "Invalid starting snapshot timestamp for SPECIFIC_START_SNAPSHOT_TIMESTAMP strategy: null");
        context = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP).startSnapshotId(Long.valueOf(1L)).startSnapshotTimestamp(Long.valueOf(1L)).build();
        this.assertException(context, "Invalid starting snapshot id for SPECIFIC_START_SNAPSHOT_ID strategy: not null");
    }

    @Test
    void testStreaming() {
        ScanContext context = ScanContext.builder().streaming(true).useTag("tag").build();
        this.assertException(context, "Cannot scan table using ref tag configured for streaming reader");
        context = ScanContext.builder().streaming(true).useSnapshotId(Long.valueOf(1L)).build();
        this.assertException(context, "Cannot set snapshot-id option for streaming reader");
        context = ScanContext.builder().streaming(true).asOfTimestamp(Long.valueOf(1L)).build();
        this.assertException(context, "Cannot set as-of-timestamp option for streaming reader");
        context = ScanContext.builder().streaming(true).endSnapshotId(Long.valueOf(1L)).build();
        this.assertException(context, "Cannot set end-snapshot-id option for streaming reader");
        context = ScanContext.builder().streaming(true).endTag("tag").build();
        this.assertException(context, "Cannot set end-tag option for streaming reader");
    }

    @Test
    void testStartConflict() {
        ScanContext context = ScanContext.builder().startTag("tag").startSnapshotId(Long.valueOf(1L)).build();
        this.assertException(context, "START_SNAPSHOT_ID and START_TAG cannot both be set.");
    }

    @Test
    void testEndConflict() {
        ScanContext context = ScanContext.builder().endTag("tag").endSnapshotId(Long.valueOf(1L)).build();
        this.assertException(context, "END_SNAPSHOT_ID and END_TAG cannot both be set.");
    }

    @Test
    void testMaxAllowedPlanningFailures() {
        ScanContext context = ScanContext.builder().maxAllowedPlanningFailures(-2).build();
        this.assertException(context, "Cannot set maxAllowedPlanningFailures to a negative number other than -1.");
    }

    private void assertException(ScanContext context, String message) {
        Assertions.assertThatThrownBy(() -> context.validate()).hasMessage(message).isInstanceOf(IllegalArgumentException.class);
    }
}

