/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.assigner;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.flink.source.SplitHelpers;
import org.apache.iceberg.flink.source.assigner.GetSplitResult;
import org.apache.iceberg.flink.source.assigner.SplitAssigner;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class SplitAssignerTestBase {
    @TempDir
    protected Path temporaryFolder;

    @Test
    public void testEmptyInitialization() {
        SplitAssigner assigner = this.splitAssigner();
        this.assertGetNext(assigner, GetSplitResult.Status.UNAVAILABLE);
    }

    @Test
    public void testStaticEnumeratorSequence() throws Exception {
        SplitAssigner assigner = this.splitAssigner();
        assigner.onDiscoveredSplits(this.createSplits(4, 1, "1"));
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertSnapshot(assigner, 1);
        assigner.onUnassignedSplits(this.createSplits(1, 1, "1"));
        this.assertSnapshot(assigner, 2);
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertGetNext(assigner, GetSplitResult.Status.UNAVAILABLE);
        this.assertSnapshot(assigner, 0);
    }

    @Test
    public void testContinuousEnumeratorSequence() throws Exception {
        SplitAssigner assigner = this.splitAssigner();
        this.assertGetNext(assigner, GetSplitResult.Status.UNAVAILABLE);
        List<IcebergSourceSplit> splits1 = this.createSplits(1, 1, "1");
        this.assertAvailableFuture(assigner, 1, () -> assigner.onDiscoveredSplits((Collection)splits1));
        List<IcebergSourceSplit> splits2 = this.createSplits(1, 1, "1");
        this.assertAvailableFuture(assigner, 1, () -> assigner.onUnassignedSplits((Collection)splits2));
        assigner.onDiscoveredSplits(this.createSplits(2, 1, "1"));
        this.assertSnapshot(assigner, 2);
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertGetNext(assigner, GetSplitResult.Status.UNAVAILABLE);
        this.assertSnapshot(assigner, 0);
    }

    private void assertAvailableFuture(SplitAssigner assigner, int splitCount, Runnable addSplitsRunnable) {
        AtomicBoolean futureCompleted = new AtomicBoolean();
        CompletableFuture future = assigner.isAvailable();
        future.thenAccept(ignored -> futureCompleted.set(true));
        Assertions.assertThat((CompletableFuture)assigner.isAvailable()).isSameAs((Object)future);
        addSplitsRunnable.run();
        Assertions.assertThat((boolean)futureCompleted.get()).isTrue();
        for (int i = 0; i < splitCount; ++i) {
            this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        }
        this.assertGetNext(assigner, GetSplitResult.Status.UNAVAILABLE);
        this.assertSnapshot(assigner, 0);
    }

    protected void assertGetNext(SplitAssigner assigner, GetSplitResult.Status expectedStatus) {
        GetSplitResult result = assigner.getNext(null);
        Assertions.assertThat((Comparable)result.status()).isEqualTo((Object)expectedStatus);
        switch (expectedStatus) {
            case AVAILABLE: {
                Assertions.assertThat((Object)result.split()).isNotNull();
                break;
            }
            case CONSTRAINED: 
            case UNAVAILABLE: {
                Assertions.assertThat((Object)result.split()).isNull();
                break;
            }
            default: {
                Assertions.fail((String)"Unknown status: %s", (Object[])new Object[]{expectedStatus});
            }
        }
    }

    protected void assertSnapshot(SplitAssigner assigner, int splitCount) {
        Collection stateBeforeGet = assigner.state();
        Assertions.assertThat((Collection)stateBeforeGet).hasSize(splitCount);
    }

    protected List<IcebergSourceSplit> createSplits(int fileCount, int filesPerSplit, String version) throws Exception {
        return SplitHelpers.createSplitsFromTransientHadoopTable(this.temporaryFolder, fileCount, filesPerSplit, version);
    }

    protected abstract SplitAssigner splitAssigner();
}

