/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.assigner;

import java.util.List;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.flink.source.assigner.GetSplitResult;
import org.apache.iceberg.flink.source.assigner.OrderedSplitAssignerFactory;
import org.apache.iceberg.flink.source.assigner.SplitAssigner;
import org.apache.iceberg.flink.source.assigner.SplitAssignerTestBase;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.flink.source.split.SerializableComparator;
import org.apache.iceberg.flink.source.split.SplitComparators;
import org.apache.iceberg.util.SerializationUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFileSequenceNumberBasedSplitAssigner
extends SplitAssignerTestBase {
    @Override
    protected SplitAssigner splitAssigner() {
        return new OrderedSplitAssignerFactory(SplitComparators.fileSequenceNumber()).createAssigner();
    }

    @Test
    public void testMultipleFilesInAnIcebergSplit() {
        SplitAssigner assigner = this.splitAssigner();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> assigner.onDiscoveredSplits(this.createSplits(4, 2, "2")), (String)"Multiple files in a split is not allowed", (Object[])new Object[0]).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Please use 'split-open-file-cost'");
    }

    @Test
    public void testSplitSort() throws Exception {
        SplitAssigner assigner = this.splitAssigner();
        List<IcebergSourceSplit> splits = this.createSplits(5, 1, "2");
        assigner.onDiscoveredSplits(splits.subList(3, 5));
        assigner.onDiscoveredSplits(splits.subList(0, 1));
        assigner.onDiscoveredSplits(splits.subList(1, 3));
        this.assertGetNext(assigner, 1L);
        this.assertGetNext(assigner, 2L);
        this.assertGetNext(assigner, 3L);
        this.assertGetNext(assigner, 4L);
        this.assertGetNext(assigner, 5L);
        this.assertGetNext(assigner, GetSplitResult.Status.UNAVAILABLE);
    }

    @Test
    public void testSerializable() {
        byte[] bytes = SerializationUtil.serializeToBytes((Object)SplitComparators.fileSequenceNumber());
        SerializableComparator comparator = (SerializableComparator)SerializationUtil.deserializeFromBytes((byte[])bytes);
        Assertions.assertThat((Object)comparator).isNotNull();
    }

    private void assertGetNext(SplitAssigner assigner, Long expectedSequenceNumber) {
        GetSplitResult result = assigner.getNext(null);
        ContentFile file = ((FileScanTask)result.split().task().files().iterator().next()).file();
        Assertions.assertThat((Long)file.fileSequenceNumber()).isEqualTo((Object)expectedSequenceNumber);
    }
}

