/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.enumerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.flink.source.enumerator.ContinuousEnumerationResult;
import org.apache.iceberg.flink.source.enumerator.ContinuousSplitPlanner;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorPosition;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class ManualContinuousSplitPlanner
implements ContinuousSplitPlanner {
    private final int maxPlanningSnapshotCount;
    private final NavigableMap<Long, List<IcebergSourceSplit>> splits;
    private long latestSnapshotId;
    private int remainingFailures;

    ManualContinuousSplitPlanner(ScanContext scanContext, int expectedFailures) {
        this.maxPlanningSnapshotCount = scanContext.maxPlanningSnapshotCount();
        this.splits = new TreeMap<Long, List<IcebergSourceSplit>>();
        this.latestSnapshotId = 0L;
        this.remainingFailures = expectedFailures;
    }

    public synchronized ContinuousEnumerationResult planSplits(IcebergEnumeratorPosition lastPosition) {
        if (this.remainingFailures > 0) {
            --this.remainingFailures;
            throw new RuntimeException("Expected failure at planning");
        }
        long fromSnapshotIdExclusive = 0L;
        if (lastPosition != null && lastPosition.snapshotId() != null) {
            fromSnapshotIdExclusive = lastPosition.snapshotId();
        }
        Preconditions.checkArgument((fromSnapshotIdExclusive <= this.latestSnapshotId ? 1 : 0) != 0, (Object)"last enumerated snapshotId is greater than the latestSnapshotId");
        if (fromSnapshotIdExclusive == this.latestSnapshotId) {
            return new ContinuousEnumerationResult((Collection)Lists.newArrayList(), lastPosition, lastPosition);
        }
        long toSnapshotIdInclusive = this.latestSnapshotId - fromSnapshotIdExclusive > (long)this.maxPlanningSnapshotCount ? fromSnapshotIdExclusive + (long)this.maxPlanningSnapshotCount : this.latestSnapshotId;
        ArrayList discoveredSplits = Lists.newArrayList();
        NavigableMap<Long, List<IcebergSourceSplit>> discoveredView = this.splits.subMap(fromSnapshotIdExclusive, false, toSnapshotIdInclusive, true);
        discoveredView.forEach((snapshotId, snapshotSplits) -> discoveredSplits.addAll(snapshotSplits));
        ContinuousEnumerationResult result = new ContinuousEnumerationResult((Collection)discoveredSplits, lastPosition, IcebergEnumeratorPosition.of((long)toSnapshotIdInclusive, (Long)toSnapshotIdInclusive));
        return result;
    }

    public synchronized void addSplits(List<IcebergSourceSplit> newSplits) {
        ++this.latestSnapshotId;
        this.splits.put(this.latestSnapshotId, newSplits);
    }

    public void close() throws IOException {
    }
}

