/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.flink.source.reader.ArrayBatchRecords;
import org.apache.iceberg.flink.source.reader.RecordAndPosition;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestArrayBatchRecords {
    @Test
    public void testFullRange() {
        String[] elements = new String[]{"0", "1", "2", "3"};
        this.testArray(elements, elements.length, 2, 119L);
    }

    @Test
    public void testSubRange() {
        String[] elements = new String[]{"0", "1", "2", "3"};
        this.testArray(elements, 2, 0, 0L);
    }

    private void testArray(String[] elements, int numberOfRecords, int fileOffset, long startingRecordOffset) {
        String splitId = "iceberg_split_1";
        AtomicBoolean recycled = new AtomicBoolean();
        ArrayBatchRecords recordsWithSplitIds = ArrayBatchRecords.forRecords((String)splitId, ignored -> recycled.set(true), (Object[])elements, (int)numberOfRecords, (int)fileOffset, (long)startingRecordOffset);
        Assertions.assertThat((String)recordsWithSplitIds.nextSplit()).isEqualTo(splitId);
        for (int i = 0; i < numberOfRecords; ++i) {
            RecordAndPosition recAndPos = recordsWithSplitIds.nextRecordFromSplit();
            Assertions.assertThat((String)((String)recAndPos.record())).isEqualTo(elements[i]);
            Assertions.assertThat((int)recAndPos.fileOffset()).isEqualTo(fileOffset);
            Assertions.assertThat((long)recAndPos.recordOffset()).isEqualTo(startingRecordOffset + (long)i + 1L);
        }
        Assertions.assertThat((Object)recordsWithSplitIds.nextRecordFromSplit()).isNull();
        Assertions.assertThat((String)recordsWithSplitIds.nextSplit()).isNull();
        recordsWithSplitIds.recycle();
        Assertions.assertThat((boolean)recycled.get()).isTrue();
    }
}

