/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.UUIDUtil;

public class RowDataWrapper
implements StructLike {
    private final LogicalType[] types;
    private final PositionalGetter<?>[] getters;
    private RowData rowData = null;

    public RowDataWrapper(RowType rowType, Types.StructType struct) {
        int size = rowType.getFieldCount();
        this.types = (LogicalType[])Array.newInstance(LogicalType.class, size);
        this.getters = (PositionalGetter[])Array.newInstance(PositionalGetter.class, size);
        for (int i = 0; i < size; ++i) {
            this.types[i] = rowType.getTypeAt(i);
            this.getters[i] = RowDataWrapper.buildGetter(this.types[i], ((Types.NestedField)struct.fields().get(i)).type());
        }
    }

    public RowDataWrapper wrap(RowData data) {
        this.rowData = data;
        return this;
    }

    public int size() {
        return this.types.length;
    }

    public <T> T get(int pos, Class<T> javaClass) {
        if (this.rowData.isNullAt(pos)) {
            return null;
        }
        if (this.getters[pos] != null) {
            return javaClass.cast(this.getters[pos].get(this.rowData, pos));
        }
        Object value = RowData.createFieldGetter((LogicalType)this.types[pos], (int)pos).getFieldOrNull(this.rowData);
        return javaClass.cast(value);
    }

    public <T> void set(int pos, T value) {
        throw new UnsupportedOperationException("Could not set a field in the RowDataWrapper because rowData is read-only");
    }

    private static PositionalGetter<?> buildGetter(LogicalType logicalType, Type type) {
        switch (logicalType.getTypeRoot()) {
            case TINYINT: {
                return (row, pos) -> (int)row.getByte(pos);
            }
            case SMALLINT: {
                return (row, pos) -> (int)row.getShort(pos);
            }
            case CHAR: 
            case VARCHAR: {
                return (row, pos) -> row.getString(pos).toString();
            }
            case BINARY: 
            case VARBINARY: {
                if (Type.TypeID.UUID == type.typeId()) {
                    return (row, pos) -> UUIDUtil.convert((byte[])row.getBinary(pos));
                }
                return (row, pos) -> ByteBuffer.wrap(row.getBinary(pos));
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)logicalType;
                return (row, pos) -> row.getDecimal(pos, decimalType.getPrecision(), decimalType.getScale()).toBigDecimal();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (row, pos) -> (long)row.getInt(pos) * 1000L;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)logicalType;
                return (row, pos) -> {
                    LocalDateTime localDateTime = row.getTimestamp(pos, timestampType.getPrecision()).toLocalDateTime();
                    return DateTimeUtil.microsFromTimestamp((LocalDateTime)localDateTime);
                };
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType lzTs = (LocalZonedTimestampType)logicalType;
                return (row, pos) -> {
                    TimestampData timestampData = row.getTimestamp(pos, lzTs.getPrecision());
                    return timestampData.getMillisecond() * 1000L + (long)(timestampData.getNanoOfMillisecond() / 1000);
                };
            }
            case ROW: {
                RowType rowType = (RowType)logicalType;
                Types.StructType structType = (Types.StructType)type;
                RowDataWrapper nestedWrapper = new RowDataWrapper(rowType, structType);
                return (row, pos) -> nestedWrapper.wrap(row.getRow(pos, rowType.getFieldCount()));
            }
        }
        return null;
    }

    private static interface PositionalGetter<T> {
        public T get(RowData var1, int var2);
    }
}

