/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.iceberg.flink.sink.CommitSummary;

class IcebergFilesCommitterMetrics {
    private final AtomicLong lastCheckpointDurationMs = new AtomicLong();
    private final AtomicLong lastCommitDurationMs = new AtomicLong();
    private final ElapsedTimeGauge elapsedSecondsSinceLastSuccessfulCommit;
    private final Counter committedDataFilesCount;
    private final Counter committedDataFilesRecordCount;
    private final Counter committedDataFilesByteCount;
    private final Counter committedDeleteFilesCount;
    private final Counter committedDeleteFilesRecordCount;
    private final Counter committedDeleteFilesByteCount;

    IcebergFilesCommitterMetrics(MetricGroup metrics, String fullTableName) {
        MetricGroup committerMetrics = metrics.addGroup("IcebergFilesCommitter").addGroup("table", fullTableName);
        committerMetrics.gauge("lastCheckpointDurationMs", this.lastCheckpointDurationMs::get);
        committerMetrics.gauge("lastCommitDurationMs", this.lastCommitDurationMs::get);
        this.elapsedSecondsSinceLastSuccessfulCommit = new ElapsedTimeGauge(TimeUnit.SECONDS);
        committerMetrics.gauge("elapsedSecondsSinceLastSuccessfulCommit", (Gauge)this.elapsedSecondsSinceLastSuccessfulCommit);
        this.committedDataFilesCount = committerMetrics.counter("committedDataFilesCount");
        this.committedDataFilesRecordCount = committerMetrics.counter("committedDataFilesRecordCount");
        this.committedDataFilesByteCount = committerMetrics.counter("committedDataFilesByteCount");
        this.committedDeleteFilesCount = committerMetrics.counter("committedDeleteFilesCount");
        this.committedDeleteFilesRecordCount = committerMetrics.counter("committedDeleteFilesRecordCount");
        this.committedDeleteFilesByteCount = committerMetrics.counter("committedDeleteFilesByteCount");
    }

    void checkpointDuration(long checkpointDurationMs) {
        this.lastCheckpointDurationMs.set(checkpointDurationMs);
    }

    void commitDuration(long commitDurationMs) {
        this.lastCommitDurationMs.set(commitDurationMs);
    }

    void updateCommitSummary(CommitSummary stats) {
        this.elapsedSecondsSinceLastSuccessfulCommit.refreshLastRecordedTime();
        this.committedDataFilesCount.inc(stats.dataFilesCount());
        this.committedDataFilesRecordCount.inc(stats.dataFilesRecordCount());
        this.committedDataFilesByteCount.inc(stats.dataFilesByteCount());
        this.committedDeleteFilesCount.inc(stats.deleteFilesCount());
        this.committedDeleteFilesRecordCount.inc(stats.deleteFilesRecordCount());
        this.committedDeleteFilesByteCount.inc(stats.deleteFilesByteCount());
    }

    private static class ElapsedTimeGauge
    implements Gauge<Long> {
        private final TimeUnit reportUnit;
        private volatile long lastRecordedTimeNano;

        ElapsedTimeGauge(TimeUnit timeUnit) {
            this.reportUnit = timeUnit;
            this.lastRecordedTimeNano = System.nanoTime();
        }

        void refreshLastRecordedTime() {
            this.lastRecordedTimeNano = System.nanoTime();
        }

        public Long getValue() {
            return this.reportUnit.convert(System.nanoTime() - this.lastRecordedTimeNano, TimeUnit.NANOSECONDS);
        }
    }
}

