/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

@Internal
class MapDataStatistics
implements DataStatistics<MapDataStatistics, Map<SortKey, Long>> {
    private final Map<SortKey, Long> statistics;

    MapDataStatistics() {
        this.statistics = Maps.newHashMap();
    }

    MapDataStatistics(Map<SortKey, Long> statistics) {
        this.statistics = statistics;
    }

    @Override
    public boolean isEmpty() {
        return this.statistics.isEmpty();
    }

    @Override
    public void add(SortKey sortKey) {
        if (this.statistics.containsKey(sortKey)) {
            this.statistics.merge(sortKey, 1L, Long::sum);
        } else {
            SortKey copiedKey = sortKey.copy();
            this.statistics.put(copiedKey, 1L);
        }
    }

    @Override
    public void merge(MapDataStatistics otherStatistics) {
        otherStatistics.statistics().forEach((key, count) -> this.statistics.merge((SortKey)key, (Long)count, Long::sum));
    }

    @Override
    public Map<SortKey, Long> statistics() {
        return this.statistics;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statistics", this.statistics).toString();
    }
}

