/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.flink.CatalogLoader;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class HadoopCatalogExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    protected final String database;
    protected final String tableName;
    protected Path temporaryFolder;
    protected Catalog catalog;
    protected CatalogLoader catalogLoader;
    protected String warehouse;
    protected TableLoader tableLoader;

    public HadoopCatalogExtension(String database, String tableName) {
        this.database = database;
        this.tableName = tableName;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.temporaryFolder = Files.createTempDirectory("junit5_hadoop_catalog-", new FileAttribute[0]);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        FileUtils.deleteDirectory((File)this.temporaryFolder.toFile());
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Assertions.assertThat((Path)this.temporaryFolder).exists().isDirectory();
        this.warehouse = "file:" + this.temporaryFolder + "/" + UUID.randomUUID();
        this.catalogLoader = CatalogLoader.hadoop((String)"hadoop", (Configuration)new Configuration(), (Map)ImmutableMap.of((Object)"warehouse", (Object)this.warehouse));
        this.catalog = this.catalogLoader.loadCatalog();
        this.tableLoader = TableLoader.fromCatalog((CatalogLoader)this.catalogLoader, (TableIdentifier)TableIdentifier.of((String[])new String[]{this.database, this.tableName}));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        try {
            this.catalog.dropTable(TableIdentifier.of((String[])new String[]{this.database, this.tableName}));
            ((HadoopCatalog)this.catalog).close();
            this.tableLoader.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close catalog resource");
        }
    }

    public TableLoader tableLoader() {
        return this.tableLoader;
    }

    public Catalog catalog() {
        return this.catalog;
    }

    public CatalogLoader catalogLoader() {
        return this.catalogLoader;
    }

    public String warehouse() {
        return this.warehouse;
    }
}

