/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestDataFileSerialization {
    private static final Schema DATE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"double", (Type)Types.DoubleType.get())});
    private static final PartitionSpec PARTITION_SPEC = PartitionSpec.builderFor((Schema)DATE_SCHEMA).identity("date").build();
    private static final Map<Integer, Long> COLUMN_SIZES = Maps.newHashMap();
    private static final Map<Integer, Long> VALUE_COUNTS = Maps.newHashMap();
    private static final Map<Integer, Long> NULL_VALUE_COUNTS = Maps.newHashMap();
    private static final Map<Integer, Long> NAN_VALUE_COUNTS = Maps.newHashMap();
    private static final Map<Integer, ByteBuffer> LOWER_BOUNDS = Maps.newHashMap();
    private static final Map<Integer, ByteBuffer> UPPER_BOUNDS = Maps.newHashMap();
    private static final Metrics METRICS;
    private static final DataFile DATA_FILE;
    private static final DeleteFile POS_DELETE_FILE;
    private static final DeleteFile EQ_DELETE_FILE;

    @Test
    public void testJavaSerialization() throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(DATA_FILE);
            out.writeObject(DATA_FILE.copy());
            out.writeObject(POS_DELETE_FILE);
            out.writeObject(POS_DELETE_FILE.copy());
            out.writeObject(EQ_DELETE_FILE);
            out.writeObject(EQ_DELETE_FILE.copy());
        }
        var3_3 = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            Object obj;
            int i;
            for (i = 0; i < 2; ++i) {
                obj = in.readObject();
                ((ObjectAssert)Assertions.assertThat((Object)obj).as("Should be a DataFile", new Object[0])).isInstanceOf(DataFile.class);
                TestHelpers.assertEquals(DATA_FILE, (DataFile)obj);
            }
            for (i = 0; i < 2; ++i) {
                obj = in.readObject();
                ((ObjectAssert)Assertions.assertThat((Object)obj).as("Should be a position DeleteFile", new Object[0])).isInstanceOf(DeleteFile.class);
                TestHelpers.assertEquals(POS_DELETE_FILE, (DeleteFile)obj);
            }
            for (i = 0; i < 2; ++i) {
                obj = in.readObject();
                ((ObjectAssert)Assertions.assertThat((Object)obj).as("Should be a equality DeleteFile", new Object[0])).isInstanceOf(DeleteFile.class);
                TestHelpers.assertEquals(EQ_DELETE_FILE, (DeleteFile)obj);
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testDataFileKryoSerialization() throws IOException {
        KryoSerializer kryo = new KryoSerializer(DataFile.class, new ExecutionConfig());
        DataOutputSerializer outputView = new DataOutputSerializer(1024);
        kryo.serialize((Object)DATA_FILE, (DataOutputView)outputView);
        kryo.serialize((Object)((DataFile)DATA_FILE.copy()), (DataOutputView)outputView);
        DataInputDeserializer inputView = new DataInputDeserializer(outputView.getCopyOfBuffer());
        DataFile dataFile1 = (DataFile)kryo.deserialize((DataInputView)inputView);
        DataFile dataFile2 = (DataFile)kryo.deserialize((DataInputView)inputView);
        TestHelpers.assertEquals(DATA_FILE, dataFile1);
        TestHelpers.assertEquals(DATA_FILE, dataFile2);
    }

    @Test
    public void testDeleteFileKryoSerialization() throws IOException {
        KryoSerializer kryo = new KryoSerializer(DeleteFile.class, new ExecutionConfig());
        DataOutputSerializer outputView = new DataOutputSerializer(1024);
        kryo.serialize((Object)POS_DELETE_FILE, (DataOutputView)outputView);
        kryo.serialize((Object)((DeleteFile)POS_DELETE_FILE.copy()), (DataOutputView)outputView);
        kryo.serialize((Object)EQ_DELETE_FILE, (DataOutputView)outputView);
        kryo.serialize((Object)((DeleteFile)EQ_DELETE_FILE.copy()), (DataOutputView)outputView);
        DataInputDeserializer inputView = new DataInputDeserializer(outputView.getCopyOfBuffer());
        DeleteFile posDeleteFile1 = (DeleteFile)kryo.deserialize((DataInputView)inputView);
        DeleteFile posDeleteFile2 = (DeleteFile)kryo.deserialize((DataInputView)inputView);
        TestHelpers.assertEquals(POS_DELETE_FILE, posDeleteFile1);
        TestHelpers.assertEquals(POS_DELETE_FILE, posDeleteFile2);
        DeleteFile eqDeleteFile1 = (DeleteFile)kryo.deserialize((DataInputView)inputView);
        DeleteFile eqDeleteFile2 = (DeleteFile)kryo.deserialize((DataInputView)inputView);
        TestHelpers.assertEquals(EQ_DELETE_FILE, eqDeleteFile1);
        TestHelpers.assertEquals(EQ_DELETE_FILE, eqDeleteFile2);
    }

    private static ByteBuffer longToBuffer(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, value);
    }

    static {
        COLUMN_SIZES.put(1, 2L);
        COLUMN_SIZES.put(2, 3L);
        VALUE_COUNTS.put(1, 5L);
        VALUE_COUNTS.put(2, 3L);
        VALUE_COUNTS.put(4, 2L);
        NULL_VALUE_COUNTS.put(1, 0L);
        NULL_VALUE_COUNTS.put(2, 2L);
        NAN_VALUE_COUNTS.put(4, 1L);
        LOWER_BOUNDS.put(1, TestDataFileSerialization.longToBuffer(0L));
        UPPER_BOUNDS.put(1, TestDataFileSerialization.longToBuffer(4L));
        METRICS = new Metrics(Long.valueOf(5L), null, VALUE_COUNTS, NULL_VALUE_COUNTS, NAN_VALUE_COUNTS, LOWER_BOUNDS, UPPER_BOUNDS);
        DATA_FILE = DataFiles.builder((PartitionSpec)PARTITION_SPEC).withPath("/path/to/data-1.parquet").withFileSizeInBytes(1234L).withPartitionPath("date=2018-06-08").withMetrics(METRICS).withSplitOffsets((List)ImmutableList.of((Object)4L)).withEncryptionKeyMetadata(ByteBuffer.allocate(4).putInt(34)).withSortOrder(SortOrder.unsorted()).build();
        POS_DELETE_FILE = FileMetadata.deleteFileBuilder((PartitionSpec)PARTITION_SPEC).ofPositionDeletes().withPath("/path/to/pos-delete.parquet").withFileSizeInBytes(10L).withPartitionPath("date=2018-06-08").withMetrics(METRICS).withEncryptionKeyMetadata(ByteBuffer.allocate(4).putInt(35)).withRecordCount(23L).build();
        EQ_DELETE_FILE = FileMetadata.deleteFileBuilder((PartitionSpec)PARTITION_SPEC).ofEqualityDeletes(new int[]{2, 3}).withPath("/path/to/equality-delete.parquet").withFileSizeInBytes(10L).withPartitionPath("date=2018-06-08").withMetrics(METRICS).withEncryptionKeyMetadata(ByteBuffer.allocate(4).putInt(35)).withRecordCount(23L).withSortOrder(SortOrder.unsorted()).build();
    }
}

