/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.flink.FlinkCatalogFactory;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFlinkCatalogFactory {
    private Map<String, String> props;

    @BeforeEach
    public void before() {
        this.props = Maps.newHashMap();
        this.props.put("type", "iceberg");
        this.props.put("warehouse", "/tmp/location");
    }

    @Test
    public void testCreateCatalogHive() {
        String catalogName = "hiveCatalog";
        this.props.put("catalog-type", "hive");
        Catalog catalog = FlinkCatalogFactory.createCatalogLoader((String)catalogName, this.props, (Configuration)new Configuration()).loadCatalog();
        ((ObjectAssert)Assertions.assertThat((Object)catalog).isNotNull()).isInstanceOf(HiveCatalog.class);
    }

    @Test
    public void testCreateCatalogHadoop() {
        String catalogName = "hadoopCatalog";
        this.props.put("catalog-type", "hadoop");
        Catalog catalog = FlinkCatalogFactory.createCatalogLoader((String)catalogName, this.props, (Configuration)new Configuration()).loadCatalog();
        ((ObjectAssert)Assertions.assertThat((Object)catalog).isNotNull()).isInstanceOf(HadoopCatalog.class);
    }

    @Test
    public void testCreateCatalogCustom() {
        String catalogName = "customCatalog";
        this.props.put("catalog-impl", CustomHadoopCatalog.class.getName());
        Catalog catalog = FlinkCatalogFactory.createCatalogLoader((String)catalogName, this.props, (Configuration)new Configuration()).loadCatalog();
        ((ObjectAssert)Assertions.assertThat((Object)catalog).isNotNull()).isInstanceOf(CustomHadoopCatalog.class);
    }

    @Test
    public void testCreateCatalogCustomWithHiveCatalogTypeSet() {
        String catalogName = "customCatalog";
        this.props.put("catalog-impl", CustomHadoopCatalog.class.getName());
        this.props.put("catalog-type", "hive");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FlinkCatalogFactory.createCatalogLoader((String)catalogName, this.props, (Configuration)new Configuration())).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot create catalog customCatalog, both catalog-type and catalog-impl are set");
    }

    @Test
    public void testLoadCatalogUnknown() {
        String catalogName = "unknownCatalog";
        this.props.put("catalog-type", "fooType");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FlinkCatalogFactory.createCatalogLoader((String)catalogName, this.props, (Configuration)new Configuration())).isInstanceOf(UnsupportedOperationException.class)).hasMessageStartingWith("Unknown catalog-type: fooType");
    }

    public static class CustomHadoopCatalog
    extends HadoopCatalog {
        public CustomHadoopCatalog() {
        }

        public CustomHadoopCatalog(Configuration conf, String warehouseLocation) {
            this.setConf(conf);
            this.initialize("custom", (Map)ImmutableMap.of((Object)"warehouse", (Object)warehouseLocation));
        }
    }
}

