/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.flink.CatalogTestBase;
import org.apache.iceberg.flink.FlinkCatalog;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestFlinkCatalogTablePartitions
extends CatalogTestBase {
    private final String tableName = "test_table";
    @Parameter(index=2)
    private FileFormat format;
    @Parameter(index=3)
    private Boolean cacheEnabled;

    @Parameters(name="catalogName={0}, baseNamespace={1}, format={2}, cacheEnabled={3}")
    protected static List<Object[]> parameters() {
        ArrayList parameters = Lists.newArrayList();
        for (FileFormat format : new FileFormat[]{FileFormat.ORC, FileFormat.AVRO, FileFormat.PARQUET}) {
            for (Boolean cacheEnabled : new Boolean[]{true, false}) {
                for (Object[] catalogParams : CatalogTestBase.parameters()) {
                    String catalogName = (String)catalogParams[0];
                    Namespace baseNamespace = (Namespace)catalogParams[1];
                    parameters.add(new Object[]{catalogName, baseNamespace, format, cacheEnabled});
                }
            }
        }
        return parameters;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.config.put("cache-enabled", String.valueOf(this.cacheEnabled));
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        this.sql("USE CATALOG %s", this.catalogName);
        this.sql("USE %s", "db");
    }

    @AfterEach
    public void cleanNamespaces() {
        this.sql("DROP TABLE IF EXISTS %s.%s", this.flinkDatabase, "test_table");
        this.sql("DROP DATABASE IF EXISTS %s", this.flinkDatabase);
        super.clean();
    }

    @TestTemplate
    public void testListPartitionsWithUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id INT, data VARCHAR) with ('write.format.default'='%s')", "test_table", this.format.name());
        this.sql("INSERT INTO %s SELECT 1,'a'", "test_table");
        ObjectPath objectPath = new ObjectPath("db", "test_table");
        FlinkCatalog flinkCatalog = (FlinkCatalog)this.getTableEnv().getCatalog(this.catalogName).get();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> flinkCatalog.listPartitions(objectPath)).isInstanceOf(TableNotPartitionedException.class)).hasMessageStartingWith("Table db.test_table in catalog").hasMessageEndingWith("is not partitioned.");
    }

    @TestTemplate
    public void testListPartitionsWithPartitionedTable() throws TableNotExistException, TableNotPartitionedException {
        this.sql("CREATE TABLE %s (id INT, data VARCHAR) PARTITIONED BY (data) with ('write.format.default'='%s')", "test_table", this.format.name());
        this.sql("INSERT INTO %s SELECT 1,'a'", "test_table");
        this.sql("INSERT INTO %s SELECT 2,'b'", "test_table");
        ObjectPath objectPath = new ObjectPath("db", "test_table");
        FlinkCatalog flinkCatalog = (FlinkCatalog)this.getTableEnv().getCatalog(this.catalogName).get();
        List list = flinkCatalog.listPartitions(objectPath);
        Assertions.assertThat((List)list).hasSize(2);
        ArrayList expected = Lists.newArrayList();
        CatalogPartitionSpec partitionSpec1 = new CatalogPartitionSpec((Map)ImmutableMap.of((Object)"data", (Object)"a"));
        CatalogPartitionSpec partitionSpec2 = new CatalogPartitionSpec((Map)ImmutableMap.of((Object)"data", (Object)"b"));
        expected.add(partitionSpec1);
        expected.add(partitionSpec2);
        ((ListAssert)Assertions.assertThat((List)list).as("Should produce the expected catalog partition specs.", new Object[0])).isEqualTo((Object)expected);
    }
}

