/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.time.Duration;
import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkConfParser;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestFlinkConfParser {
    @Test
    public void testDurationConf() {
        ImmutableMap writeOptions = ImmutableMap.of((Object)"write-prop", (Object)"111s");
        ConfigOption configOption = ConfigOptions.key((String)"conf-prop").durationType().noDefaultValue();
        Configuration flinkConf = new Configuration();
        flinkConf.setString(configOption.key(), "222s");
        Table table = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)table.properties()).thenReturn((Object)ImmutableMap.of((Object)"table-prop", (Object)"333s"));
        FlinkConfParser confParser = new FlinkConfParser(table, (Map)writeOptions, (ReadableConfig)flinkConf);
        Duration defaultVal = Duration.ofMillis(999L);
        Duration result = ((FlinkConfParser.DurationConfParser)confParser.durationConf().option("write-prop")).defaultValue(defaultVal).parse();
        Assertions.assertThat((Duration)result).isEqualTo((Object)Duration.ofSeconds(111L));
        result = ((FlinkConfParser.DurationConfParser)confParser.durationConf().flinkConfig(configOption)).defaultValue(defaultVal).parse();
        Assertions.assertThat((Duration)result).isEqualTo((Object)Duration.ofSeconds(222L));
        result = ((FlinkConfParser.DurationConfParser)confParser.durationConf().tableProperty("table-prop")).defaultValue(defaultVal).parse();
        Assertions.assertThat((Duration)result).isEqualTo((Object)Duration.ofSeconds(333L));
    }
}

