/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.flink.CatalogTestBase;
import org.apache.iceberg.flink.TestBase;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFlinkHiveCatalog
extends TestBase {
    @Test
    public void testCreateCatalogWithWarehouseLocation() throws IOException {
        HashMap props = Maps.newHashMap();
        props.put("type", "iceberg");
        props.put("catalog-type", "hive");
        props.put("uri", CatalogTestBase.getURI(hiveConf));
        File warehouseDir = Files.createTempDirectory(this.temporaryDirectory, "junit", new FileAttribute[0]).toFile();
        props.put("warehouse", "file://" + warehouseDir.getAbsolutePath());
        this.checkSQLQuery(props, warehouseDir);
    }

    @Test
    public void testCreateCatalogWithHiveConfDir() throws IOException {
        File hiveConfDir = Files.createTempDirectory(this.temporaryDirectory, "junit", new FileAttribute[0]).toFile();
        File hiveSiteXML = new File(hiveConfDir, "hive-site.xml");
        File warehouseDir = Files.createTempDirectory(this.temporaryDirectory, "junit", new FileAttribute[0]).toFile();
        try (FileOutputStream fos = new FileOutputStream(hiveSiteXML);){
            Configuration newConf = new Configuration((Configuration)hiveConf);
            newConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, "file://" + warehouseDir.getAbsolutePath());
            newConf.writeXml((OutputStream)fos);
        }
        Assertions.assertThat((Path)hiveSiteXML.toPath()).exists();
        HashMap props = Maps.newHashMap();
        props.put("type", "iceberg");
        props.put("catalog-type", "hive");
        props.put("uri", CatalogTestBase.getURI(hiveConf));
        props.put("hive-conf-dir", hiveConfDir.getAbsolutePath());
        this.checkSQLQuery(props, warehouseDir);
    }

    private void checkSQLQuery(Map<String, String> catalogProperties, File warehouseDir) throws IOException {
        this.sql("CREATE CATALOG test_catalog WITH %s", CatalogTestBase.toWithClause(catalogProperties));
        this.sql("USE CATALOG test_catalog", new Object[0]);
        this.sql("CREATE DATABASE test_db", new Object[0]);
        this.sql("USE test_db", new Object[0]);
        this.sql("CREATE TABLE test_table(c1 INT, c2 STRING)", new Object[0]);
        this.sql("INSERT INTO test_table SELECT 1, 'a'", new Object[0]);
        Path databasePath = warehouseDir.toPath().resolve("test_db.db");
        Assertions.assertThat((Path)databasePath).exists();
        Path tablePath = databasePath.resolve("test_table");
        Assertions.assertThat((Path)tablePath).exists();
        Path dataPath = tablePath.resolve("data");
        Assertions.assertThat((Path)dataPath).exists();
        ((AbstractLongAssert)Assertions.assertThat((long)Files.list(dataPath).count()).as("Should have a .crc file and a .parquet file", new Object[0])).isEqualTo(2L);
        this.sql("DROP TABLE test_table", new Object[0]);
        this.sql("DROP DATABASE test_db", new Object[0]);
        this.dropCatalog("test_catalog", false);
    }
}

