/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericData;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataConverter;
import org.apache.iceberg.flink.data.RowDataUtil;
import org.apache.iceberg.flink.source.FlinkInputFormat;
import org.apache.iceberg.flink.source.FlinkInputSplit;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLocalDateAssert;
import org.assertj.core.api.AbstractLocalDateTimeAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;

public class TestHelpers {
    private TestHelpers() {
    }

    public static <T> T roundTripKryoSerialize(Class<T> clazz, T table) throws IOException {
        KryoSerializer kryo = new KryoSerializer(clazz, new ExecutionConfig());
        DataOutputSerializer outputView = new DataOutputSerializer(1024);
        kryo.serialize(table, (DataOutputView)outputView);
        DataInputDeserializer inputView = new DataInputDeserializer(outputView.getCopyOfBuffer());
        return (T)kryo.deserialize((DataInputView)inputView);
    }

    public static RowData copyRowData(RowData from, RowType rowType) {
        TypeSerializer[] fieldSerializers = (TypeSerializer[])rowType.getChildren().stream().map(type -> InternalSerializers.create((LogicalType)type)).toArray(TypeSerializer[]::new);
        RowData.FieldGetter[] fieldGetters = new RowData.FieldGetter[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            fieldGetters[i] = RowData.createFieldGetter((LogicalType)rowType.getTypeAt(i), (int)i);
        }
        return RowDataUtil.clone((RowData)from, null, (RowType)rowType, (TypeSerializer[])fieldSerializers, (RowData.FieldGetter[])fieldGetters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readRowData(FlinkInputFormat input, Consumer<RowData> visitor) throws IOException {
        for (FlinkInputSplit s : input.createInputSplits(0)) {
            input.open(s);
            try {
                while (!input.reachedEnd()) {
                    RowData row = input.nextRecord(null);
                    visitor.accept(row);
                }
            }
            finally {
                input.close();
            }
        }
    }

    public static List<RowData> readRowData(FlinkInputFormat inputFormat, RowType rowType) throws IOException {
        ArrayList results = Lists.newArrayList();
        TestHelpers.readRowData(inputFormat, (RowData row) -> results.add(TestHelpers.copyRowData(row, rowType)));
        return results;
    }

    public static List<Row> readRows(FlinkInputFormat inputFormat, RowType rowType) throws IOException {
        return TestHelpers.convertRowDataToRow(TestHelpers.readRowData(inputFormat, rowType), rowType);
    }

    public static List<Row> convertRowDataToRow(List<RowData> rowDataList, RowType rowType) {
        DataStructureConverter converter = DataStructureConverters.getConverter((DataType)TypeConversions.fromLogicalToDataType((LogicalType)rowType));
        return rowDataList.stream().map(arg_0 -> ((DataStructureConverter)converter).toExternal(arg_0)).map(Row.class::cast).collect(Collectors.toList());
    }

    private static List<Row> convertRecordToRow(List<Record> expectedRecords, Schema schema) {
        ArrayList expected = Lists.newArrayList();
        DataStructureConverter converter = DataStructureConverters.getConverter((DataType)TypeConversions.fromLogicalToDataType((LogicalType)FlinkSchemaUtil.convert((Schema)schema)));
        expectedRecords.forEach(r -> expected.add((Row)converter.toExternal((Object)RowDataConverter.convert(schema, r))));
        return expected;
    }

    public static void assertRecordsWithOrder(List<Row> results, List<Record> expectedRecords, Schema schema) {
        List<Row> expected = TestHelpers.convertRecordToRow(expectedRecords, schema);
        TestHelpers.assertRowsWithOrder(results, expected);
    }

    public static void assertRecords(List<Row> results, List<Record> expectedRecords, Schema schema) {
        List<Row> expected = TestHelpers.convertRecordToRow(expectedRecords, schema);
        TestHelpers.assertRows(results, expected);
    }

    public static void assertRows(List<RowData> results, List<RowData> expected, RowType rowType) {
        TestHelpers.assertRows(TestHelpers.convertRowDataToRow(results, rowType), TestHelpers.convertRowDataToRow(expected, rowType));
    }

    public static void assertRows(List<Row> results, List<Row> expected) {
        Assertions.assertThat(results).containsExactlyInAnyOrderElementsOf(expected);
    }

    public static void assertRowsWithOrder(List<Row> results, List<Row> expected) {
        Assertions.assertThat(results).containsExactlyElementsOf(expected);
    }

    public static void assertRowData(Schema schema, StructLike expected, RowData actual) {
        TestHelpers.assertRowData(schema.asStruct(), (LogicalType)FlinkSchemaUtil.convert((Schema)schema), expected, actual);
    }

    public static void assertRowData(Types.StructType structType, LogicalType rowType, StructLike expectedRecord, RowData actualRowData) {
        if (expectedRecord == null && actualRowData == null) {
            return;
        }
        Assertions.assertThat((Object)expectedRecord).isNotNull();
        Assertions.assertThat((Object)actualRowData).isNotNull();
        ArrayList types = Lists.newArrayList();
        for (Types.NestedField field : structType.fields()) {
            types.add(field.type());
        }
        for (int i = 0; i < types.size(); ++i) {
            LogicalType logicalType = ((RowType)rowType).getTypeAt(i);
            Object expected = expectedRecord.get(i, Object.class);
            Object actual = actualRowData.isNullAt(i) ? null : RowData.createFieldGetter((LogicalType)logicalType, (int)i).getFieldOrNull(actualRowData);
            TestHelpers.assertEquals((Type)types.get(i), logicalType, expected, actual);
        }
    }

    private static void assertEquals(Type type, LogicalType logicalType, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        Assertions.assertThat((Object)expected).isNotNull();
        Assertions.assertThat((Object)actual).isNotNull();
        switch (type.typeId()) {
            case BOOLEAN: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("boolean value should be equal", new Object[0])).isEqualTo(expected);
                break;
            }
            case INTEGER: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("int value should be equal", new Object[0])).isEqualTo(expected);
                break;
            }
            case LONG: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("long value should be equal", new Object[0])).isEqualTo(expected);
                break;
            }
            case FLOAT: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("float value should be equal", new Object[0])).isEqualTo(expected);
                break;
            }
            case DOUBLE: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("double value should be equal", new Object[0])).isEqualTo(expected);
                break;
            }
            case STRING: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a CharSequence", new Object[0])).isInstanceOf(CharSequence.class);
                ((AbstractStringAssert)Assertions.assertThat((String)actual.toString()).as("string should be equal", new Object[0])).isEqualTo(String.valueOf(expected));
                break;
            }
            case DATE: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Date", new Object[0])).isInstanceOf(LocalDate.class);
                LocalDate date = DateTimeUtil.dateFromDays((int)((Integer)actual));
                ((AbstractLocalDateAssert)Assertions.assertThat((LocalDate)date).as("date should be equal", new Object[0])).isEqualTo(expected);
                break;
            }
            case TIME: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a LocalTime", new Object[0])).isInstanceOf(LocalTime.class);
                int milliseconds = (int)(((LocalTime)expected).toNanoOfDay() / 1000000L);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("time millis should be equal", new Object[0])).isEqualTo((Object)milliseconds);
                break;
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a OffsetDataTime", new Object[0])).isInstanceOf(OffsetDateTime.class);
                    OffsetDateTime ts = (OffsetDateTime)expected;
                    ((AbstractLocalDateTimeAssert)Assertions.assertThat((LocalDateTime)((TimestampData)actual).toLocalDateTime()).as("OffsetDataTime should be equal", new Object[0])).isEqualTo((Object)ts.toLocalDateTime());
                    break;
                }
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a LocalDataTime", new Object[0])).isInstanceOf(LocalDateTime.class);
                LocalDateTime ts = (LocalDateTime)expected;
                ((AbstractLocalDateTimeAssert)Assertions.assertThat((LocalDateTime)((TimestampData)actual).toLocalDateTime()).as("LocalDataTime should be equal", new Object[0])).isEqualTo((Object)ts);
                break;
            }
            case BINARY: {
                ((AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)ByteBuffer.wrap((byte[])actual)).as("Should expect a ByteBuffer", new Object[0])).isInstanceOf(ByteBuffer.class)).isEqualTo(expected);
                break;
            }
            case DECIMAL: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a BigDecimal", new Object[0])).isInstanceOf(BigDecimal.class);
                BigDecimal bd = (BigDecimal)expected;
                ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)((DecimalData)actual).toBigDecimal()).as("decimal value should be equal", new Object[0])).isEqualTo((Object)bd);
                break;
            }
            case LIST: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Collection", new Object[0])).isInstanceOf(Collection.class);
                Collection expectedArrayData = (Collection)expected;
                ArrayData actualArrayData = (ArrayData)actual;
                LogicalType elementType = ((ArrayType)logicalType).getElementType();
                ((AbstractIntegerAssert)Assertions.assertThat((int)actualArrayData.size()).as("array length should be equal", new Object[0])).isEqualTo(expectedArrayData.size());
                TestHelpers.assertArrayValues(type.asListType().elementType(), elementType, expectedArrayData, actualArrayData);
                break;
            }
            case MAP: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Map", new Object[0])).isInstanceOf(Map.class);
                TestHelpers.assertMapValues(type.asMapType(), logicalType, (Map)expected, (MapData)actual);
                break;
            }
            case STRUCT: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Record", new Object[0])).isInstanceOf(StructLike.class);
                TestHelpers.assertRowData(type.asStructType(), logicalType, (StructLike)expected, (RowData)actual);
                break;
            }
            case UUID: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a UUID", new Object[0])).isInstanceOf(UUID.class);
                ByteBuffer bb = ByteBuffer.wrap((byte[])actual);
                long firstLong = bb.getLong();
                long secondLong = bb.getLong();
                ((AbstractStringAssert)Assertions.assertThat((String)new UUID(firstLong, secondLong).toString()).as("UUID should be equal", new Object[0])).isEqualTo(expected.toString());
                break;
            }
            case FIXED: {
                ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)actual).as("Should expect byte[]", new Object[0])).isInstanceOf(byte[].class)).isEqualTo(expected);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a supported type: " + type);
            }
        }
    }

    public static void assertEquals(Schema schema, List<GenericData.Record> records, List<Row> rows) {
        Streams.forEachPair(records.stream(), rows.stream(), (record, row) -> TestHelpers.assertEquals(schema, record, row));
    }

    public static void assertEquals(Schema schema, GenericData.Record record, Row row) {
        List fields = schema.asStruct().fields();
        Assertions.assertThat((List)fields).hasSameSizeAs((Iterable)record.getSchema().getFields());
        Assertions.assertThat((List)fields).hasSize(row.getArity());
        RowType rowType = FlinkSchemaUtil.convert((Schema)schema);
        for (int i = 0; i < fields.size(); ++i) {
            Type fieldType = ((Types.NestedField)fields.get(i)).type();
            Object expectedValue = record.get(i);
            Object actualValue = row.getField(i);
            LogicalType logicalType = rowType.getTypeAt(i);
            TestHelpers.assertAvroEquals(fieldType, logicalType, expectedValue, actualValue);
        }
    }

    private static void assertEquals(Types.StructType struct, GenericData.Record record, Row row) {
        List fields = struct.fields();
        for (int i = 0; i < fields.size(); ++i) {
            Type fieldType = ((Types.NestedField)fields.get(i)).type();
            Object expectedValue = record.get(i);
            Object actualValue = row.getField(i);
            TestHelpers.assertAvroEquals(fieldType, null, expectedValue, actualValue);
        }
    }

    private static void assertAvroEquals(Type type, LogicalType logicalType, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        Assertions.assertThat((Object)expected).isNotNull();
        Assertions.assertThat((Object)actual).isNotNull();
        switch (type.typeId()) {
            case BOOLEAN: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a " + type.typeId().javaClass(), new Object[0])).isInstanceOf(type.typeId().javaClass());
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should expect a " + type.typeId().javaClass(), new Object[0])).isInstanceOf(type.typeId().javaClass());
                ((ObjectAssert)Assertions.assertThat((Object)actual).as(type.typeId() + " value should be equal", new Object[0])).isEqualTo(expected);
                break;
            }
            case STRING: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a CharSequence", new Object[0])).isInstanceOf(CharSequence.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should expect a CharSequence", new Object[0])).isInstanceOf(CharSequence.class);
                ((AbstractStringAssert)Assertions.assertThat((String)actual.toString()).as("string should be equal", new Object[0])).isEqualTo(expected.toString());
                break;
            }
            case DATE: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Date", new Object[0])).isInstanceOf(LocalDate.class);
                LocalDate date = DateTimeUtil.dateFromDays((int)((Integer)actual));
                ((AbstractLocalDateAssert)Assertions.assertThat((LocalDate)date).as("date should be equal", new Object[0])).isEqualTo(expected);
                break;
            }
            case TIME: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a LocalTime", new Object[0])).isInstanceOf(LocalTime.class);
                int milliseconds = (int)(((LocalTime)expected).toNanoOfDay() / 1000000L);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("time millis should be equal", new Object[0])).isEqualTo((Object)milliseconds);
                break;
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a OffsetDataTime", new Object[0])).isInstanceOf(OffsetDateTime.class);
                    OffsetDateTime ts = (OffsetDateTime)expected;
                    ((AbstractLocalDateTimeAssert)Assertions.assertThat((LocalDateTime)((TimestampData)actual).toLocalDateTime()).as("OffsetDataTime should be equal", new Object[0])).isEqualTo((Object)ts.toLocalDateTime());
                    break;
                }
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a LocalDataTime", new Object[0])).isInstanceOf(LocalDateTime.class);
                LocalDateTime ts = (LocalDateTime)expected;
                ((AbstractLocalDateTimeAssert)Assertions.assertThat((LocalDateTime)((TimestampData)actual).toLocalDateTime()).as("LocalDataTime should be equal", new Object[0])).isEqualTo((Object)ts);
                break;
            }
            case BINARY: {
                ((AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)ByteBuffer.wrap((byte[])actual)).as("Should expect a ByteBuffer", new Object[0])).isInstanceOf(ByteBuffer.class)).isEqualTo(expected);
                break;
            }
            case DECIMAL: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a BigDecimal", new Object[0])).isInstanceOf(BigDecimal.class);
                BigDecimal bd = (BigDecimal)expected;
                ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)((DecimalData)actual).toBigDecimal()).as("decimal value should be equal", new Object[0])).isEqualTo((Object)bd);
                break;
            }
            case LIST: {
                ArrayData actualArrayData;
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Collection", new Object[0])).isInstanceOf(Collection.class);
                Collection expectedArrayData = (Collection)expected;
                try {
                    actualArrayData = (ArrayData)actual;
                }
                catch (ClassCastException e) {
                    actualArrayData = new GenericArrayData((Object[])actual);
                }
                LogicalType elementType = ((ArrayType)logicalType).getElementType();
                ((AbstractIntegerAssert)Assertions.assertThat((int)actualArrayData.size()).as("array length should be equal", new Object[0])).isEqualTo(expectedArrayData.size());
                TestHelpers.assertArrayValues(type.asListType().elementType(), elementType, expectedArrayData, actualArrayData);
                break;
            }
            case MAP: {
                MapData actualMap;
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Map", new Object[0])).isInstanceOf(Map.class);
                try {
                    actualMap = (MapData)actual;
                }
                catch (ClassCastException e) {
                    actualMap = new GenericMapData((Map)actual);
                }
                TestHelpers.assertMapValues(type.asMapType(), logicalType, (Map)expected, actualMap);
                break;
            }
            case STRUCT: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Record", new Object[0])).isInstanceOf(GenericData.Record.class);
                TestHelpers.assertEquals(type.asNestedType().asStructType(), (GenericData.Record)expected, (Row)actual);
                break;
            }
            case UUID: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a UUID", new Object[0])).isInstanceOf(UUID.class);
                ByteBuffer bb = ByteBuffer.wrap((byte[])actual);
                long firstLong = bb.getLong();
                long secondLong = bb.getLong();
                ((AbstractStringAssert)Assertions.assertThat((String)new UUID(firstLong, secondLong).toString()).as("UUID should be equal", new Object[0])).isEqualTo(expected.toString());
                break;
            }
            case FIXED: {
                ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)actual).as("Should expect byte[]", new Object[0])).isInstanceOf(byte[].class)).isEqualTo(expected);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a supported type: " + type);
            }
        }
    }

    private static void assertArrayValues(Type type, LogicalType logicalType, Collection<?> expectedArray, ArrayData actualArray) {
        ArrayList expectedElements = Lists.newArrayList(expectedArray);
        for (int i = 0; i < expectedArray.size(); ++i) {
            if (expectedElements.get(i) == null) {
                Assertions.assertThat((boolean)actualArray.isNullAt(i)).isTrue();
                continue;
            }
            Object expected = expectedElements.get(i);
            TestHelpers.assertEquals(type, logicalType, expected, ArrayData.createElementGetter((LogicalType)logicalType).getElementOrNull(actualArray, i));
        }
    }

    private static void assertMapValues(Types.MapType mapType, LogicalType type, Map<?, ?> expected, MapData actual) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)actual.size()).as("map size should be equal", new Object[0])).isEqualTo(expected.size());
        ArrayData actualKeyArrayData = actual.keyArray();
        ArrayData actualValueArrayData = actual.valueArray();
        LogicalType actualKeyType = ((MapType)type).getKeyType();
        LogicalType actualValueType = ((MapType)type).getValueType();
        Type keyType = mapType.keyType();
        Type valueType = mapType.valueType();
        ArrayData.ElementGetter keyGetter = ArrayData.createElementGetter((LogicalType)actualKeyType);
        ArrayData.ElementGetter valueGetter = ArrayData.createElementGetter((LogicalType)actualValueType);
        for (Map.Entry<?, ?> entry : expected.entrySet()) {
            Object matchedActualKey = null;
            int matchedKeyIndex = 0;
            for (int i = 0; i < actual.size(); ++i) {
                try {
                    Object key = keyGetter.getElementOrNull(actualKeyArrayData, i);
                    TestHelpers.assertEquals(keyType, actualKeyType, entry.getKey(), key);
                    matchedActualKey = key;
                    matchedKeyIndex = i;
                    break;
                }
                catch (AssertionError assertionError) {
                    continue;
                }
            }
            ((ObjectAssert)Assertions.assertThat(matchedActualKey).as("Should have a matching key", new Object[0])).isNotNull();
            int valueIndex = matchedKeyIndex;
            TestHelpers.assertEquals(valueType, actualValueType, entry.getValue(), valueGetter.getElementOrNull(actualValueArrayData, valueIndex));
        }
    }

    public static void assertEquals(ManifestFile expected, ManifestFile actual) {
        if (expected == actual) {
            return;
        }
        Assertions.assertThat((Object)expected).isNotNull();
        Assertions.assertThat((Object)actual).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)actual.path()).as("Path must match", new Object[0])).isEqualTo(expected.path());
        ((AbstractLongAssert)Assertions.assertThat((long)actual.length()).as("Length must match", new Object[0])).isEqualTo(expected.length());
        ((AbstractIntegerAssert)Assertions.assertThat((int)actual.partitionSpecId()).as("Spec id must match", new Object[0])).isEqualTo(expected.partitionSpecId());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actual.content()).as("ManifestContent must match", new Object[0])).isEqualTo((Object)expected.content());
        ((AbstractLongAssert)Assertions.assertThat((long)actual.sequenceNumber()).as("SequenceNumber must match", new Object[0])).isEqualTo(expected.sequenceNumber());
        ((AbstractLongAssert)Assertions.assertThat((long)actual.minSequenceNumber()).as("MinSequenceNumber must match", new Object[0])).isEqualTo(expected.minSequenceNumber());
        ((AbstractLongAssert)Assertions.assertThat((Long)actual.snapshotId()).as("Snapshot id must match", new Object[0])).isEqualTo((Object)expected.snapshotId());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual.hasAddedFiles()).as("Added files flag must match", new Object[0])).isEqualTo(expected.hasAddedFiles());
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)actual.addedFilesCount()).as("Added files count must match", new Object[0])).isEqualTo((Object)expected.addedFilesCount());
        ((AbstractLongAssert)Assertions.assertThat((Long)actual.addedRowsCount()).as("Added rows count must match", new Object[0])).isEqualTo((Object)expected.addedRowsCount());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual.hasExistingFiles()).as("Existing files flag must match", new Object[0])).isEqualTo(expected.hasExistingFiles());
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)actual.existingFilesCount()).as("Existing files count must match", new Object[0])).isEqualTo((Object)expected.existingFilesCount());
        ((AbstractLongAssert)Assertions.assertThat((Long)actual.existingRowsCount()).as("Existing rows count must match", new Object[0])).isEqualTo((Object)expected.existingRowsCount());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual.hasDeletedFiles()).as("Deleted files flag must match", new Object[0])).isEqualTo(expected.hasDeletedFiles());
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)actual.deletedFilesCount()).as("Deleted files count must match", new Object[0])).isEqualTo((Object)expected.deletedFilesCount());
        ((AbstractLongAssert)Assertions.assertThat((Long)actual.deletedRowsCount()).as("Deleted rows count must match", new Object[0])).isEqualTo((Object)expected.deletedRowsCount());
        List expectedSummaries = expected.partitions();
        List actualSummaries = actual.partitions();
        ((ListAssert)Assertions.assertThat((List)actualSummaries).as("PartitionFieldSummary size does not match", new Object[0])).hasSameSizeAs((Iterable)expectedSummaries);
        for (int i = 0; i < expectedSummaries.size(); ++i) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ManifestFile.PartitionFieldSummary)actualSummaries.get(i)).containsNull()).as("Null flag in partition must match", new Object[0])).isEqualTo(((ManifestFile.PartitionFieldSummary)expectedSummaries.get(i)).containsNull());
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)((ManifestFile.PartitionFieldSummary)actualSummaries.get(i)).containsNaN()).as("NaN flag in partition must match", new Object[0])).isEqualTo((Object)((ManifestFile.PartitionFieldSummary)expectedSummaries.get(i)).containsNaN());
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((ManifestFile.PartitionFieldSummary)actualSummaries.get(i)).lowerBound()).as("Lower bounds in partition must match", new Object[0])).isEqualTo((Object)((ManifestFile.PartitionFieldSummary)expectedSummaries.get(i)).lowerBound());
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((ManifestFile.PartitionFieldSummary)actualSummaries.get(i)).upperBound()).as("Upper bounds in partition must match", new Object[0])).isEqualTo((Object)((ManifestFile.PartitionFieldSummary)expectedSummaries.get(i)).upperBound());
        }
    }

    public static void assertEquals(ContentFile<?> expected, ContentFile<?> actual) {
        if (expected == actual) {
            return;
        }
        Assertions.assertThat(expected).isNotNull();
        Assertions.assertThat(actual).isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actual.specId()).as("SpecId", new Object[0])).isEqualTo(expected.specId());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actual.content()).as("Content", new Object[0])).isEqualTo((Object)expected.content());
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actual.path()).as("Path", new Object[0])).isEqualTo((Object)expected.path());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actual.format()).as("Format", new Object[0])).isEqualTo((Object)expected.format());
        ((AbstractIntegerAssert)Assertions.assertThat((int)actual.partition().size()).as("Partition size", new Object[0])).isEqualTo(expected.partition().size());
        for (int i = 0; i < expected.partition().size(); ++i) {
            ((ObjectAssert)Assertions.assertThat((Object)actual.partition().get(i, Object.class)).as("Partition data at index " + i, new Object[0])).isEqualTo(expected.partition().get(i, Object.class));
        }
        ((AbstractLongAssert)Assertions.assertThat((long)actual.recordCount()).as("Record count", new Object[0])).isEqualTo(expected.recordCount());
        ((AbstractLongAssert)Assertions.assertThat((long)actual.fileSizeInBytes()).as("File size in bytes", new Object[0])).isEqualTo(expected.fileSizeInBytes());
        ((MapAssert)Assertions.assertThat((Map)actual.columnSizes()).as("Column sizes", new Object[0])).isEqualTo((Object)expected.columnSizes());
        ((MapAssert)Assertions.assertThat((Map)actual.valueCounts()).as("Value counts", new Object[0])).isEqualTo((Object)expected.valueCounts());
        ((MapAssert)Assertions.assertThat((Map)actual.nullValueCounts()).as("Null value counts", new Object[0])).isEqualTo((Object)expected.nullValueCounts());
        ((MapAssert)Assertions.assertThat((Map)actual.lowerBounds()).as("Lower bounds", new Object[0])).isEqualTo((Object)expected.lowerBounds());
        ((MapAssert)Assertions.assertThat((Map)actual.upperBounds()).as("Upper bounds", new Object[0])).isEqualTo((Object)expected.upperBounds());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actual.keyMetadata()).as("Key metadata", new Object[0])).isEqualTo((Object)expected.keyMetadata());
        ((ListAssert)Assertions.assertThat((List)actual.splitOffsets()).as("Split offsets", new Object[0])).isEqualTo((Object)expected.splitOffsets());
        ((ListAssert)Assertions.assertThat((List)actual.equalityFieldIds()).as("Equality field id list", new Object[0])).isEqualTo((Object)expected.equalityFieldIds());
    }
}

