/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestTableSerialization {
    private static final HadoopTables TABLES = new HadoopTables();
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"double", (Type)Types.DoubleType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("date").build();
    private static final SortOrder SORT_ORDER = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("id")).build();
    @TempDir
    private Path temp;
    private Table table;

    @BeforeEach
    public void initTable() throws IOException {
        ImmutableMap props = ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2");
        File tableLocation = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)tableLocation.delete()).isTrue();
        this.table = TABLES.create(SCHEMA, SPEC, SORT_ORDER, (Map)props, tableLocation.toString());
    }

    @Test
    public void testSerializableTableKryoSerialization() throws IOException {
        SerializableTable serializableTable = (SerializableTable)SerializableTable.copyOf((Table)this.table);
        TestHelpers.assertSerializedAndLoadedMetadata((Table)this.table, (Table)((Table)org.apache.iceberg.flink.TestHelpers.roundTripKryoSerialize(SerializableTable.class, serializableTable)));
    }

    @Test
    public void testSerializableMetadataTableKryoSerialization() throws IOException {
        for (MetadataTableType type : MetadataTableType.values()) {
            TableOperations ops = ((HasTableOperations)this.table).operations();
            Table metadataTable = MetadataTableUtils.createMetadataTableInstance((TableOperations)ops, (String)this.table.name(), (String)"meta", (MetadataTableType)type);
            SerializableTable serializableMetadataTable = (SerializableTable)SerializableTable.copyOf((Table)metadataTable);
            TestHelpers.assertSerializedAndLoadedMetadata((Table)metadataTable, (Table)((Table)org.apache.iceberg.flink.TestHelpers.roundTripKryoSerialize(SerializableTable.class, serializableMetadataTable)));
        }
    }

    @Test
    public void testSerializableTransactionTableKryoSerialization() throws IOException {
        Transaction txn = this.table.newTransaction();
        txn.updateProperties().set("k1", "v1").commit();
        Table txnTable = txn.table();
        SerializableTable serializableTxnTable = (SerializableTable)SerializableTable.copyOf((Table)txnTable);
        TestHelpers.assertSerializedMetadata((Table)txnTable, (Table)((Table)org.apache.iceberg.flink.TestHelpers.roundTripKryoSerialize(SerializableTable.class, serializableTxnTable)));
    }
}

