/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.flink.DataGenerators;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.data.RandomRowData;
import org.apache.iceberg.flink.data.RowDataProjection;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRowDataProjection {
    @Test
    public void testNullRootRowData() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        RowDataProjection projection = RowDataProjection.create((Schema)schema, (Schema)schema.select(new String[]{"id"}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> projection.wrap(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid row data: null");
    }

    @Test
    public void testFullProjection() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        this.generateAndValidate(schema, schema);
        GenericRowData rowData = GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"a")});
        GenericRowData copyRowData = GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"a")});
        GenericRowData otherRowData = GenericRowData.of((Object[])new Object[]{2L, StringData.fromString((String)"b")});
        this.testEqualsAndHashCode(schema, schema, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
    }

    @Test
    public void testReorderedFullProjection() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        Schema reordered = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        this.generateAndValidate(schema, reordered);
        GenericRowData rowData = GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"a")});
        GenericRowData copyRowData = GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"a")});
        GenericRowData otherRowData = GenericRowData.of((Object[])new Object[]{2L, StringData.fromString((String)"b")});
        this.testEqualsAndHashCode(schema, reordered, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
    }

    @Test
    public void testBasicProjection() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Schema dataOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        this.generateAndValidate(schema, idOnly);
        this.generateAndValidate(schema, dataOnly);
        GenericRowData rowData = GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"a")});
        GenericRowData copyRowData = GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"a")});
        GenericRowData otherRowData = GenericRowData.of((Object[])new Object[]{2L, StringData.fromString((String)"b")});
        this.testEqualsAndHashCode(schema, idOnly, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        this.testEqualsAndHashCode(schema, dataOnly, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
    }

    @Test
    public void testEmptyProjection() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        this.generateAndValidate(schema, schema.select(new String[0]));
        GenericRowData rowData = GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"a")});
        GenericRowData copyRowData = GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"a")});
        GenericRowData otherRowData = GenericRowData.of((Object[])new Object[]{2L, StringData.fromString((String)"b")});
        this.testEqualsAndHashCode(schema, schema.select(new String[0]), (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData, true);
    }

    @Test
    public void testRename() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        Schema renamed = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"renamed", (Type)Types.StringType.get())});
        this.generateAndValidate(schema, renamed);
        GenericRowData rowData = GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"a")});
        GenericRowData copyRowData = GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"a")});
        GenericRowData otherRowData = GenericRowData.of((Object[])new Object[]{2L, StringData.fromString((String)"b")});
        this.testEqualsAndHashCode(schema, renamed, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
    }

    @Test
    public void testNestedProjection() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        GenericRowData rowData = GenericRowData.of((Object[])new Object[]{1L, GenericRowData.of((Object[])new Object[]{Float.valueOf(1.0f), Float.valueOf(1.0f)})});
        GenericRowData copyRowData = GenericRowData.of((Object[])new Object[]{1L, GenericRowData.of((Object[])new Object[]{Float.valueOf(1.0f), Float.valueOf(1.0f)})});
        GenericRowData otherRowData = GenericRowData.of((Object[])new Object[]{2L, GenericRowData.of((Object[])new Object[]{Float.valueOf(2.0f), Float.valueOf(2.0f)})});
        GenericRowData rowDataNullStruct = GenericRowData.of((Object[])new Object[]{1L, null});
        GenericRowData copyRowDataNullStruct = GenericRowData.of((Object[])new Object[]{1L, null});
        GenericRowData otherRowDataNullStruct = GenericRowData.of((Object[])new Object[]{2L, null});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Assertions.assertThat((int)idOnly.columns().size()).isGreaterThan(0);
        this.generateAndValidate(schema, idOnly);
        this.testEqualsAndHashCode(schema, idOnly, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        this.testEqualsAndHashCode(schema, idOnly, (RowData)rowDataNullStruct, (RowData)copyRowDataNullStruct, (RowData)otherRowDataNullStruct);
        Schema latOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get())}))});
        Assertions.assertThat((int)latOnly.columns().size()).isGreaterThan(0);
        this.generateAndValidate(schema, latOnly);
        this.testEqualsAndHashCode(schema, latOnly, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        this.testEqualsAndHashCode(schema, latOnly, (RowData)rowDataNullStruct, (RowData)copyRowDataNullStruct, (RowData)otherRowDataNullStruct, true);
        Schema longOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        Assertions.assertThat((int)longOnly.columns().size()).isGreaterThan(0);
        this.generateAndValidate(schema, longOnly);
        this.testEqualsAndHashCode(schema, longOnly, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        this.testEqualsAndHashCode(schema, longOnly, (RowData)rowDataNullStruct, (RowData)copyRowDataNullStruct, (RowData)otherRowDataNullStruct, true);
        Schema locationOnly = schema.select(new String[]{"location"});
        Assertions.assertThat((int)locationOnly.columns().size()).isGreaterThan(0);
        this.generateAndValidate(schema, locationOnly);
        this.testEqualsAndHashCode(schema, locationOnly, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        this.testEqualsAndHashCode(schema, locationOnly, (RowData)rowDataNullStruct, (RowData)copyRowDataNullStruct, (RowData)otherRowDataNullStruct, true);
    }

    @Test
    public void testPrimitivesFullProjection() {
        DataGenerators.Primitives dataGenerator = new DataGenerators.Primitives();
        Schema schema = dataGenerator.icebergSchema();
        this.generateAndValidate(schema, schema);
        GenericRowData rowData = dataGenerator.generateFlinkRowData();
        GenericRowData copyRowData = dataGenerator.generateFlinkRowData();
        GenericRowData otherRowData = dataGenerator.generateFlinkRowData();
        otherRowData.setField(6, (Object)StringData.fromString((String)"foo_bar"));
        this.testEqualsAndHashCode(schema, schema, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        GenericRowData rowDataNullOptionalFields = dataGenerator.generateFlinkRowData();
        this.setOptionalFieldsNullForPrimitives(rowDataNullOptionalFields);
        GenericRowData copyRowDataNullOptionalFields = dataGenerator.generateFlinkRowData();
        this.setOptionalFieldsNullForPrimitives(copyRowDataNullOptionalFields);
        GenericRowData otherRowDataNullOptionalFields = dataGenerator.generateFlinkRowData();
        otherRowDataNullOptionalFields.setField(6, (Object)StringData.fromString((String)"foo_bar"));
        this.setOptionalFieldsNullForPrimitives(otherRowData);
        this.testEqualsAndHashCode(schema, schema, (RowData)rowDataNullOptionalFields, (RowData)copyRowDataNullOptionalFields, (RowData)otherRowDataNullOptionalFields);
    }

    private void setOptionalFieldsNullForPrimitives(GenericRowData rowData) {
        for (int pos = 1; pos <= 5; ++pos) {
            rowData.setField(pos, null);
        }
    }

    @Test
    public void testMapOfPrimitivesProjection() {
        DataGenerators.MapOfPrimitives dataGenerator = new DataGenerators.MapOfPrimitives();
        Schema schema = dataGenerator.icebergSchema();
        Schema idOnly = schema.select(new String[]{"row_id"});
        Assertions.assertThat((int)idOnly.columns().size()).isGreaterThan(0);
        this.generateAndValidate(schema, idOnly);
        Schema mapOnly = schema.select(new String[]{"map_of_primitives"});
        Assertions.assertThat((int)mapOnly.columns().size()).isGreaterThan(0);
        this.generateAndValidate(schema, mapOnly);
        this.generateAndValidate(schema, schema);
        GenericRowData rowData = dataGenerator.generateFlinkRowData();
        GenericRowData copyRowData = dataGenerator.generateFlinkRowData();
        GenericRowData otherRowData = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"foo"), (Object)1, (Object)StringData.fromString((String)"bar"), (Object)2))});
        this.testEqualsAndHashCode(schema, idOnly, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData, true);
        this.testEqualsAndHashCode(schema, mapOnly, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        this.testEqualsAndHashCode(schema, schema, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        GenericRowData rowDataNullOptionalFields = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), null});
        GenericRowData copyRowDataNullOptionalFields = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), null});
        GenericRowData otherRowDataNullOptionalFields = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"other_row_id_value"), null});
        this.testEqualsAndHashCode(schema, idOnly, (RowData)rowDataNullOptionalFields, (RowData)copyRowDataNullOptionalFields, (RowData)otherRowDataNullOptionalFields);
        this.testEqualsAndHashCode(schema, mapOnly, (RowData)rowDataNullOptionalFields, (RowData)copyRowDataNullOptionalFields, (RowData)otherRowDataNullOptionalFields, true);
        this.testEqualsAndHashCode(schema, schema, (RowData)rowDataNullOptionalFields, (RowData)copyRowDataNullOptionalFields, (RowData)otherRowDataNullOptionalFields);
    }

    @Test
    public void testMapOfStructStructProjection() {
        DataGenerators.MapOfStructStruct dataGenerator = new DataGenerators.MapOfStructStruct();
        Schema schema = dataGenerator.icebergSchema();
        Schema idOnly = schema.select(new String[]{"row_id"});
        Assertions.assertThat((int)idOnly.columns().size()).isGreaterThan(0);
        this.generateAndValidate(schema, idOnly);
        Schema mapOnly = schema.select(new String[]{"map"});
        Assertions.assertThat((int)mapOnly.columns().size()).isGreaterThan(0);
        this.generateAndValidate(schema, mapOnly);
        this.generateAndValidate(schema, schema);
        Schema partialMapKey = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"map", (Type)Types.MapType.ofOptional((int)101, (int)102, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)201, (String)"key", (Type)Types.LongType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)203, (String)"value", (Type)Types.LongType.get()), Types.NestedField.required((int)204, (String)"valueData", (Type)Types.StringType.get())})))});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.generateAndValidate(schema, partialMapKey)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot project a partial map key or value struct.");
        Schema partialMapValue = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"map", (Type)Types.MapType.ofOptional((int)101, (int)102, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)201, (String)"key", (Type)Types.LongType.get()), Types.NestedField.required((int)202, (String)"keyData", (Type)Types.StringType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)203, (String)"value", (Type)Types.LongType.get())})))});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.generateAndValidate(schema, partialMapValue)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot project a partial map key or value struct.");
        GenericRowData rowData = dataGenerator.generateFlinkRowData();
        GenericRowData copyRowData = dataGenerator.generateFlinkRowData();
        GenericRowData otherRowData = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"other_row_id_value"), new GenericMapData((Map)ImmutableMap.of((Object)GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"other_key_data")}), (Object)GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"other_value_data")})))});
        this.testEqualsAndHashCode(schema, idOnly, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        this.testEqualsAndHashCode(schema, mapOnly, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        this.testEqualsAndHashCode(schema, schema, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        GenericRowData rowDataNullOptionalFields = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericMapData((Map)ImmutableMap.of((Object)GenericRowData.of((Object[])new Object[]{1L, null}), (Object)GenericRowData.of((Object[])new Object[]{1L, null})))});
        GenericRowData copyRowDataNullOptionalFields = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericMapData((Map)ImmutableMap.of((Object)GenericRowData.of((Object[])new Object[]{1L, null}), (Object)GenericRowData.of((Object[])new Object[]{1L, null})))});
        GenericRowData otherRowDataNullOptionalFields = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"other_row_id_value"), new GenericMapData((Map)ImmutableMap.of((Object)GenericRowData.of((Object[])new Object[]{2L, null}), (Object)GenericRowData.of((Object[])new Object[]{2L, null})))});
        this.testEqualsAndHashCode(schema, idOnly, (RowData)rowDataNullOptionalFields, (RowData)copyRowDataNullOptionalFields, (RowData)otherRowDataNullOptionalFields);
        this.testEqualsAndHashCode(schema, mapOnly, (RowData)rowDataNullOptionalFields, (RowData)copyRowDataNullOptionalFields, (RowData)otherRowDataNullOptionalFields);
        this.testEqualsAndHashCode(schema, schema, (RowData)rowDataNullOptionalFields, (RowData)copyRowDataNullOptionalFields, (RowData)otherRowDataNullOptionalFields);
    }

    @Test
    public void testArrayOfPrimitiveProjection() {
        DataGenerators.ArrayOfPrimitive dataGenerator = new DataGenerators.ArrayOfPrimitive();
        Schema schema = dataGenerator.icebergSchema();
        Schema idOnly = schema.select(new String[]{"row_id"});
        Assertions.assertThat((int)idOnly.columns().size()).isGreaterThan(0);
        this.generateAndValidate(schema, idOnly);
        Schema arrayOnly = schema.select(new String[]{"array_of_int"});
        Assertions.assertThat((int)arrayOnly.columns().size()).isGreaterThan(0);
        this.generateAndValidate(schema, arrayOnly);
        this.generateAndValidate(schema, schema);
        GenericRowData rowData = dataGenerator.generateFlinkRowData();
        GenericRowData copyRowData = dataGenerator.generateFlinkRowData();
        GenericRowData otherRowData = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"other_row_id_value"), new GenericArrayData((Object[])new Integer[]{4, 5, 6})});
        this.testEqualsAndHashCode(schema, idOnly, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        this.testEqualsAndHashCode(schema, arrayOnly, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        this.testEqualsAndHashCode(schema, schema, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        GenericRowData rowDataNullOptionalFields = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericArrayData((Object[])new Integer[]{1, null, 3})});
        GenericRowData copyRowDataNullOptionalFields = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericArrayData((Object[])new Integer[]{1, null, 3})});
        GenericRowData otherRowDataNullOptionalFields = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"other_row_id_value"), new GenericArrayData((Object[])new Integer[]{4, null, 6})});
        this.testEqualsAndHashCode(schema, idOnly, (RowData)rowDataNullOptionalFields, (RowData)copyRowDataNullOptionalFields, (RowData)otherRowDataNullOptionalFields);
        this.testEqualsAndHashCode(schema, arrayOnly, (RowData)rowDataNullOptionalFields, (RowData)copyRowDataNullOptionalFields, (RowData)otherRowDataNullOptionalFields);
        this.testEqualsAndHashCode(schema, schema, (RowData)rowDataNullOptionalFields, (RowData)copyRowDataNullOptionalFields, (RowData)otherRowDataNullOptionalFields);
    }

    @Test
    public void testArrayOfStructProjection() {
        DataGenerators.ArrayOfStruct dataGenerator = new DataGenerators.ArrayOfStruct();
        Schema schema = dataGenerator.icebergSchema();
        Schema idOnly = schema.select(new String[]{"row_id"});
        Assertions.assertThat((int)idOnly.columns().size()).isGreaterThan(0);
        this.generateAndValidate(schema, idOnly);
        Schema arrayOnly = schema.select(new String[]{"array_of_struct"});
        Assertions.assertThat((int)arrayOnly.columns().size()).isGreaterThan(0);
        this.generateAndValidate(schema, arrayOnly);
        this.generateAndValidate(schema, schema);
        Schema partialList = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"array_of_struct", (Type)Types.ListType.ofOptional((int)101, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)202, (String)"name", (Type)Types.StringType.get())})))});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.generateAndValidate(schema, partialList)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot project a partial list element struct.");
        GenericRowData rowData = dataGenerator.generateFlinkRowData();
        GenericRowData copyRowData = dataGenerator.generateFlinkRowData();
        GenericRowData otherRowData = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericArrayData((Object[])new Integer[]{4, 5, 6})});
        this.testEqualsAndHashCode(schema, schema, (RowData)rowData, (RowData)copyRowData, (RowData)otherRowData);
        GenericRowData rowDataNullOptionalFields = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericArrayData((Object[])new Integer[]{1, null, 3})});
        GenericRowData copyRowDataNullOptionalFields = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericArrayData((Object[])new Integer[]{1, null, 3})});
        GenericRowData otherRowDataNullOptionalFields = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericArrayData((Object[])new Integer[]{4, null, 6})});
        this.testEqualsAndHashCode(schema, schema, (RowData)rowDataNullOptionalFields, (RowData)copyRowDataNullOptionalFields, (RowData)otherRowDataNullOptionalFields);
    }

    private void generateAndValidate(Schema schema, Schema projectSchema) {
        int numRecords = 100;
        List recordList = RandomGenericData.generate((Schema)schema, (int)numRecords, (long)102L);
        ArrayList rowDataList = Lists.newArrayList(RandomRowData.generate(schema, numRecords, 102L).iterator());
        Assertions.assertThat((List)rowDataList).hasSize(recordList.size());
        StructProjection structProjection = StructProjection.create((Schema)schema, (Schema)projectSchema);
        RowDataProjection rowDataProjection = RowDataProjection.create((Schema)schema, (Schema)projectSchema);
        for (int i = 0; i < numRecords; ++i) {
            StructProjection expected = structProjection.wrap((StructLike)recordList.get(i));
            RowData projected = rowDataProjection.wrap((RowData)rowDataList.get(i));
            TestHelpers.assertRowData(projectSchema, (StructLike)expected, projected);
            Assertions.assertThat((Object)projected).isEqualTo((Object)projected);
            Assertions.assertThat((Object)projected).hasSameHashCodeAs((Object)projected);
            Assertions.assertThatNoException().isThrownBy(projected::toString);
        }
    }

    private void testEqualsAndHashCode(Schema schema, Schema projectionSchema, RowData rowData, RowData copyRowData, RowData otherRowData) {
        this.testEqualsAndHashCode(schema, projectionSchema, rowData, copyRowData, otherRowData, false);
    }

    private void testEqualsAndHashCode(Schema schema, Schema projectionSchema, RowData rowData, RowData copyRowData, RowData otherRowData, boolean isOtherRowDataSameAsRowData) {
        RowDataProjection projection = RowDataProjection.create((Schema)schema, (Schema)projectionSchema);
        RowDataProjection copyProjection = RowDataProjection.create((Schema)schema, (Schema)projectionSchema);
        RowDataProjection otherProjection = RowDataProjection.create((Schema)schema, (Schema)projectionSchema);
        Assertions.assertThat((Object)projection.wrap(rowData)).isEqualTo((Object)copyProjection.wrap(copyRowData));
        Assertions.assertThat((Object)projection.wrap(rowData)).hasSameHashCodeAs((Object)copyProjection.wrap(copyRowData));
        if (isOtherRowDataSameAsRowData) {
            Assertions.assertThat((Object)projection.wrap(rowData)).isEqualTo((Object)otherProjection.wrap(otherRowData));
            Assertions.assertThat((Object)projection.wrap(rowData)).hasSameHashCodeAs((Object)otherProjection.wrap(otherRowData));
        } else {
            Assertions.assertThat((Object)projection.wrap(rowData)).isNotEqualTo((Object)otherProjection.wrap(otherRowData));
            Assertions.assertThat((Object)projection.wrap(rowData)).doesNotHaveSameHashCodeAs((Object)otherProjection.wrap(otherRowData));
        }
    }
}

