/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.data.FlinkAvroReader;
import org.apache.iceberg.flink.data.FlinkAvroWriter;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestRowProjection {
    @TempDir
    private Path temp;

    private RowData writeAndRead(String desc, Schema writeSchema, Schema readSchema, RowData row) throws IOException {
        File file = File.createTempFile("junit", desc + ".avro", this.temp.toFile());
        Assertions.assertThat((boolean)file.delete()).isTrue();
        try (FileAppender appender = Avro.write((OutputFile)Files.localOutput((File)file)).schema(writeSchema).createWriterFunc(ignore -> new FlinkAvroWriter(FlinkSchemaUtil.convert((Schema)writeSchema))).build();){
            appender.add((Object)row);
        }
        AvroIterable records = Avro.read((InputFile)Files.localInput((File)file)).project(readSchema).createReaderFunc(FlinkAvroReader::new).build();
        return (RowData)Iterables.getOnlyElement((Iterable)records);
    }

    @Test
    public void testFullProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        RowData projected = this.writeAndRead("full_projection", schema, schema, (RowData)row);
        Assertions.assertThat((long)projected.getLong(0)).isEqualTo(34L);
        Assertions.assertThat((Comparable)projected.getString(1)).asString().isEqualTo("test");
    }

    @Test
    public void testSpecialCharacterProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"user id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data%0", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        RowData full = this.writeAndRead("special_chars", schema, schema, (RowData)row);
        Assertions.assertThat((long)full.getLong(0)).isEqualTo(34L);
        Assertions.assertThat((Comparable)full.getString(1)).asString().isEqualTo("test");
        RowData projected = this.writeAndRead("special_characters", schema, schema.select(new String[]{"data%0"}), full);
        Assertions.assertThat((int)projected.getArity()).isEqualTo(1);
        Assertions.assertThat((Comparable)projected.getString(0)).asString().isEqualTo("test");
    }

    @Test
    public void testReorderedFullProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        Schema reordered = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("full_projection", schema, reordered, (RowData)row);
        Assertions.assertThat((Comparable)projected.getString(0)).asString().isEqualTo("test");
        Assertions.assertThat((long)projected.getLong(1)).isEqualTo(34L);
    }

    @Test
    public void testReorderedProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        Schema reordered = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"missing_1", (Type)Types.StringType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"missing_2", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("full_projection", schema, reordered, (RowData)row);
        Assertions.assertThat((boolean)projected.isNullAt(0)).isTrue();
        Assertions.assertThat((Comparable)projected.getString(1)).asString().isEqualTo("test");
        Assertions.assertThat((boolean)projected.isNullAt(2)).isTrue();
    }

    @Test
    public void testRenamedAddedField() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"b", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"d", (Type)Types.LongType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{100L, 200L, 300L});
        Schema renamedAdded = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"a", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"b", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"c", (Type)Types.LongType.get()), Types.NestedField.optional((int)4, (String)"d", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("rename_and_add_column_projection", schema, renamedAdded, (RowData)row);
        ((AbstractLongAssert)Assertions.assertThat((long)projected.getLong(0)).as("Should contain the correct value in column 1", new Object[0])).isEqualTo(100L);
        ((AbstractLongAssert)Assertions.assertThat((long)projected.getLong(1)).as("Should contain the correct value in column 2", new Object[0])).isEqualTo(200L);
        ((AbstractLongAssert)Assertions.assertThat((long)projected.getLong(2)).as("Should contain the correct value in column 1", new Object[0])).isEqualTo(300L);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)projected.isNullAt(3)).as("Should contain empty value on new column 4", new Object[0])).isTrue();
    }

    @Test
    public void testEmptyProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        RowData projected = this.writeAndRead("empty_projection", schema, schema.select(new String[0]), (RowData)row);
        Assertions.assertThat((Object)projected).isNotNull();
        Assertions.assertThat((int)projected.getArity()).isEqualTo(0);
    }

    @Test
    public void testBasicProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("basic_projection_id", writeSchema, idOnly, (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project data", new Object[0])).isEqualTo(1);
        Assertions.assertThat((long)projected.getLong(0)).isEqualTo(34L);
        Schema dataOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        projected = this.writeAndRead("basic_projection_data", writeSchema, dataOnly, (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        int cmp = Comparators.charSequences().compare("test", projected.getString(0).toString());
        Assertions.assertThat((Comparable)projected.getString(0)).asString().isEqualTo("test");
    }

    @Test
    public void testRename() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        Schema readSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"renamed", (Type)Types.StringType.get())});
        RowData projected = this.writeAndRead("project_and_rename", writeSchema, readSchema, (RowData)row);
        Assertions.assertThat((long)projected.getLong(0)).isEqualTo(34L);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)projected.getString(1)).as("Should contain the correct data/renamed value", new Object[0])).asString().isEqualTo("test");
    }

    @Test
    public void testNestedStructProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        GenericRowData location = GenericRowData.of((Object[])new Object[]{Float.valueOf(52.995144f), Float.valueOf(-1.539054f)});
        GenericRowData record = GenericRowData.of((Object[])new Object[]{34L, location});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("id_only", writeSchema, idOnly, (RowData)record);
        Assertions.assertThat((int)projected.getArity()).isEqualTo(1);
        ((AbstractLongAssert)Assertions.assertThat((long)projected.getLong(0)).as("Should contain the correct id value", new Object[0])).isEqualTo(34L);
        Schema latOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get())}))});
        projected = this.writeAndRead("latitude_only", writeSchema, latOnly, (RowData)record);
        RowData projectedLocation = projected.getRow(0, 1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)projected.isNullAt(0)).as("Should project location", new Object[0])).isFalse();
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedLocation.getArity()).as("Should not project longitude", new Object[0])).isEqualTo(1);
        ((AbstractFloatAssert)Assertions.assertThat((float)projectedLocation.getFloat(0)).as("Should project latitude", new Object[0])).isEqualTo(52.995144f, Assertions.withPrecision((Float)Float.valueOf(1.0E-6f)));
        Schema longOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        projected = this.writeAndRead("longitude_only", writeSchema, longOnly, (RowData)record);
        projectedLocation = projected.getRow(0, 1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)projected.isNullAt(0)).as("Should project location", new Object[0])).isFalse();
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedLocation.getArity()).as("Should not project latitutde", new Object[0])).isEqualTo(1);
        ((AbstractFloatAssert)Assertions.assertThat((float)projectedLocation.getFloat(0)).as("Should project longitude", new Object[0])).isEqualTo(-1.539054f, Assertions.withPrecision((Float)Float.valueOf(1.0E-6f)));
        Schema locationOnly = writeSchema.select(new String[]{"location"});
        projected = this.writeAndRead("location_only", writeSchema, locationOnly, (RowData)record);
        projectedLocation = projected.getRow(0, 1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)projected.isNullAt(0)).as("Should project location", new Object[0])).isFalse();
        ((AbstractFloatAssert)Assertions.assertThat((float)projectedLocation.getFloat(0)).as("Should project latitude", new Object[0])).isEqualTo(52.995144f, Assertions.withPrecision((Float)Float.valueOf(1.0E-6f)));
        ((AbstractFloatAssert)Assertions.assertThat((float)projectedLocation.getFloat(1)).as("Should project longitude", new Object[0])).isEqualTo(-1.539054f, Assertions.withPrecision((Float)Float.valueOf(1.0E-6f)));
    }

    @Test
    public void testMapProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"properties", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        GenericMapData properties = new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"a"), (Object)StringData.fromString((String)"A"), (Object)StringData.fromString((String)"b"), (Object)StringData.fromString((String)"B")));
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, properties});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("id_only", writeSchema, idOnly, (RowData)row);
        Assertions.assertThat((long)projected.getLong(0)).isEqualTo(34L);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project properties map", new Object[0])).isEqualTo(1);
        Schema keyOnly = writeSchema.select(new String[]{"properties.key"});
        projected = this.writeAndRead("key_only", writeSchema, keyOnly, (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        Assertions.assertThat((Object)projected.getMap(0)).isEqualTo((Object)properties);
        Schema valueOnly = writeSchema.select(new String[]{"properties.value"});
        projected = this.writeAndRead("value_only", writeSchema, valueOnly, (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        Assertions.assertThat((Object)projected.getMap(0)).isEqualTo((Object)properties);
        Schema mapOnly = writeSchema.select(new String[]{"properties"});
        projected = this.writeAndRead("map_only", writeSchema, mapOnly, (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        Assertions.assertThat((Object)projected.getMap(0)).isEqualTo((Object)properties);
    }

    private Map<String, ?> toStringMap(Map<?, ?> map) {
        HashMap stringMap = Maps.newHashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof CharSequence) {
                stringMap.put(entry.getKey().toString(), entry.getValue().toString());
                continue;
            }
            stringMap.put(entry.getKey().toString(), entry.getValue());
        }
        return stringMap;
    }

    @Test
    public void testMapOfStructsProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())})))});
        GenericRowData l1 = GenericRowData.of((Object[])new Object[]{Float.valueOf(53.99281f), Float.valueOf(-1.542616f)});
        GenericRowData l2 = GenericRowData.of((Object[])new Object[]{Float.valueOf(52.995144f), Float.valueOf(-1.539054f)});
        GenericMapData map = new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"L1"), (Object)l1, (Object)StringData.fromString((String)"L2"), (Object)l2));
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, map});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("id_only", writeSchema, idOnly, (RowData)row);
        Assertions.assertThat((long)projected.getLong(0)).isEqualTo(34L);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project locations map", new Object[0])).isEqualTo(1);
        projected = this.writeAndRead("all_locations", writeSchema, writeSchema.select(new String[]{"locations"}), (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        Assertions.assertThat((Object)projected.getMap(0)).isEqualTo((Object)row.getMap(1));
        projected = this.writeAndRead("lat_only", writeSchema, writeSchema.select(new String[]{"locations.lat"}), (RowData)row);
        GenericMapData locations = (GenericMapData)projected.getMap(0);
        Assertions.assertThat((Object)locations).isNotNull();
        GenericArrayData l1l2Array = new GenericArrayData(new Object[]{StringData.fromString((String)"L2"), StringData.fromString((String)"L1")});
        Assertions.assertThat((Object)locations.keyArray()).isEqualTo((Object)l1l2Array);
        RowData projectedL1 = (RowData)locations.get((Object)StringData.fromString((String)"L1"));
        Assertions.assertThat((Object)projectedL1).isNotNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)projectedL1.getFloat(0)).as("L1 should contain lat", new Object[0])).isEqualTo(53.99281f, Assertions.withPrecision((Float)Float.valueOf(1.0E-6f)));
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedL1.getArity()).as("L1 should not contain long", new Object[0])).isEqualTo(1);
        RowData projectedL2 = (RowData)locations.get((Object)StringData.fromString((String)"L2"));
        Assertions.assertThat((Object)projectedL2).isNotNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)projectedL2.getFloat(0)).as("L2 should contain lat", new Object[0])).isEqualTo(52.995144f, Assertions.withPrecision((Float)Float.valueOf(1.0E-6f)));
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedL2.getArity()).as("L2 should not contain long", new Object[0])).isEqualTo(1);
        projected = this.writeAndRead("long_only", writeSchema, writeSchema.select(new String[]{"locations.long"}), (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        locations = (GenericMapData)projected.getMap(0);
        Assertions.assertThat((Object)locations).isNotNull();
        Assertions.assertThat((Object)locations.keyArray()).isEqualTo((Object)l1l2Array);
        projectedL1 = (RowData)locations.get((Object)StringData.fromString((String)"L1"));
        Assertions.assertThat((Object)projectedL1).isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedL1.getArity()).as("L1 should not contain lat", new Object[0])).isEqualTo(1);
        ((AbstractFloatAssert)Assertions.assertThat((float)projectedL1.getFloat(0)).as("L1 should contain long", new Object[0])).isEqualTo(-1.542616f, Assertions.withPrecision((Float)Float.valueOf(1.0E-6f)));
        projectedL2 = (RowData)locations.get((Object)StringData.fromString((String)"L2"));
        Assertions.assertThat((Object)projectedL2).isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedL2.getArity()).as("L2 should not contain lat", new Object[0])).isEqualTo(1);
        ((AbstractFloatAssert)Assertions.assertThat((float)projectedL2.getFloat(0)).as("L2 should contain long", new Object[0])).isEqualTo(-1.539054f, Assertions.withPrecision((Float)Float.valueOf(1.0E-6f)));
        Schema latitiudeRenamed = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"latitude", (Type)Types.FloatType.get())})))});
        projected = this.writeAndRead("latitude_renamed", writeSchema, latitiudeRenamed, (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        locations = (GenericMapData)projected.getMap(0);
        Assertions.assertThat((Object)locations).isNotNull();
        Assertions.assertThat((Object)locations.keyArray()).isEqualTo((Object)l1l2Array);
        projectedL1 = (RowData)locations.get((Object)StringData.fromString((String)"L1"));
        Assertions.assertThat((Object)projectedL1).isNotNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)projectedL1.getFloat(0)).as("L1 should contain latitude", new Object[0])).isEqualTo(53.99281f, Assertions.withPrecision((Float)Float.valueOf(1.0E-6f)));
        projectedL2 = (RowData)locations.get((Object)StringData.fromString((String)"L2"));
        Assertions.assertThat((Object)projectedL2).isNotNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)projectedL2.getFloat(0)).as("L2 should contain latitude", new Object[0])).isEqualTo(52.995144f, Assertions.withPrecision((Float)Float.valueOf(1.0E-6f)));
    }

    @Test
    public void testListProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)10, (String)"values", (Type)Types.ListType.ofOptional((int)11, (Type)Types.LongType.get()))});
        GenericArrayData values = new GenericArrayData((Object[])new Long[]{56L, 57L, 58L});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, values});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("id_only", writeSchema, idOnly, (RowData)row);
        Assertions.assertThat((long)projected.getLong(0)).isEqualTo(34L);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project values list", new Object[0])).isEqualTo(1);
        Schema elementOnly = writeSchema.select(new String[]{"values.element"});
        projected = this.writeAndRead("element_only", writeSchema, elementOnly, (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        Assertions.assertThat((Object)projected.getArray(0)).isEqualTo((Object)values);
        Schema listOnly = writeSchema.select(new String[]{"values"});
        projected = this.writeAndRead("list_only", writeSchema, listOnly, (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        Assertions.assertThat((Object)projected.getArray(0)).isEqualTo((Object)values);
    }

    @Test
    public void testListOfStructsProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)18, (String)"y", (Type)Types.IntegerType.get())})))});
        GenericRowData p1 = GenericRowData.of((Object[])new Object[]{1, 2});
        GenericRowData p2 = GenericRowData.of((Object[])new Object[]{3, null});
        GenericArrayData arrayData = new GenericArrayData((Object[])new RowData[]{p1, p2});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, arrayData});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("id_only", writeSchema, idOnly, (RowData)row);
        Assertions.assertThat((long)projected.getLong(0)).isEqualTo(34L);
        Assertions.assertThat((int)projected.getArity()).isEqualTo(1);
        projected = this.writeAndRead("all_points", writeSchema, writeSchema.select(new String[]{"points"}), (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        Assertions.assertThat((Object)projected.getArray(0)).isEqualTo((Object)row.getArray(1));
        projected = this.writeAndRead("x_only", writeSchema, writeSchema.select(new String[]{"points.x"}), (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        Assertions.assertThat((boolean)projected.isNullAt(0)).isFalse();
        ArrayData points = projected.getArray(0);
        Assertions.assertThat((int)points.size()).isEqualTo(2);
        RowData projectedP1 = points.getRow(0, 2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedP1.getInt(0)).as("Should project x", new Object[0])).isEqualTo(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedP1.getArity()).as("Should not project y", new Object[0])).isEqualTo(1);
        RowData projectedP2 = points.getRow(1, 2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedP2.getArity()).as("Should not project y", new Object[0])).isEqualTo(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedP2.getInt(0)).as("Should project x", new Object[0])).isEqualTo(3);
        projected = this.writeAndRead("y_only", writeSchema, writeSchema.select(new String[]{"points.y"}), (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        Assertions.assertThat((boolean)projected.isNullAt(0)).isFalse();
        points = projected.getArray(0);
        Assertions.assertThat((int)points.size()).isEqualTo(2);
        projectedP1 = points.getRow(0, 2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedP1.getArity()).as("Should not project x", new Object[0])).isEqualTo(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedP1.getInt(0)).as("Should project y", new Object[0])).isEqualTo(2);
        projectedP2 = points.getRow(1, 2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedP2.getArity()).as("Should not project x", new Object[0])).isEqualTo(1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)projectedP2.isNullAt(0)).as("Should project null y", new Object[0])).isTrue();
        Schema yRenamed = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)18, (String)"z", (Type)Types.IntegerType.get())})))});
        projected = this.writeAndRead("y_renamed", writeSchema, yRenamed, (RowData)row);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projected.getArity()).as("Should not project id", new Object[0])).isEqualTo(1);
        Assertions.assertThat((boolean)projected.isNullAt(0)).isFalse();
        points = projected.getArray(0);
        Assertions.assertThat((int)points.size()).isEqualTo(2);
        projectedP1 = points.getRow(0, 2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedP1.getArity()).as("Should not project x and y", new Object[0])).isEqualTo(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedP1.getInt(0)).as("Should project z", new Object[0])).isEqualTo(2);
        projectedP2 = points.getRow(1, 2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)projectedP2.getArity()).as("Should not project x and y", new Object[0])).isEqualTo(1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)projectedP2.isNullAt(0)).as("Should project null z", new Object[0])).isTrue();
    }

    @Test
    public void testAddedFieldsWithRequiredChildren() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.LongType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{100L});
        Schema addedFields = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"a", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"b", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"c", (Type)Types.LongType.get())})), Types.NestedField.optional((int)4, (String)"d", (Type)Types.ListType.ofRequired((int)5, (Type)Types.LongType.get())), Types.NestedField.optional((int)6, (String)"e", (Type)Types.MapType.ofRequired((int)7, (int)8, (Type)Types.LongType.get(), (Type)Types.LongType.get()))});
        RowData projected = this.writeAndRead("add_fields_with_required_children_projection", schema, addedFields, (RowData)row);
        ((AbstractLongAssert)Assertions.assertThat((long)projected.getLong(0)).as("Should contain the correct value in column 1", new Object[0])).isEqualTo(100L);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)projected.isNullAt(1)).as("Should contain empty value in new column 2", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)projected.isNullAt(2)).as("Should contain empty value in new column 4", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)projected.isNullAt(3)).as("Should contain empty value in new column 6", new Object[0])).isTrue();
    }
}

