/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.sink.BucketPartitionKeySelector;
import org.apache.iceberg.flink.sink.TestBucketPartitionerUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TestBucketPartitionKeySelector {
    @ParameterizedTest
    @EnumSource(value=TestBucketPartitionerUtil.TableSchemaType.class, names={"ONE_BUCKET", "IDENTITY_AND_BUCKET"})
    public void testCorrectKeySelection(TestBucketPartitionerUtil.TableSchemaType tableSchemaType) {
        int numBuckets = 60;
        PartitionSpec partitionSpec = tableSchemaType.getPartitionSpec(numBuckets);
        BucketPartitionKeySelector keySelector = new BucketPartitionKeySelector(partitionSpec, SimpleDataUtil.SCHEMA, SimpleDataUtil.ROW_TYPE);
        TestBucketPartitionerUtil.generateRowsForBucketIdRange(2, numBuckets).forEach(rowData -> {
            int expectedBucketId = TestBucketPartitionerUtil.computeBucketId(numBuckets, rowData.getString(1).toString());
            Integer key = keySelector.getKey(rowData);
            Assertions.assertThat((Integer)key).isEqualTo(expectedBucketId);
        });
    }

    @Test
    public void testKeySelectorMultipleBucketsFail() {
        PartitionSpec partitionSpec = TestBucketPartitionerUtil.TableSchemaType.TWO_BUCKETS.getPartitionSpec(1);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> new BucketPartitionKeySelector(partitionSpec, SimpleDataUtil.SCHEMA, SimpleDataUtil.ROW_TYPE)).withMessage("Invalid number of buckets: %s (must be 1)", new Object[]{2});
    }
}

