/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.sink.CachingTableSupplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCachingTableSupplier {
    @Test
    public void testCheckArguments() {
        SerializableTable initialTable = (SerializableTable)Mockito.mock(SerializableTable.class);
        Table loadedTable = (Table)Mockito.mock(Table.class);
        TableLoader tableLoader = (TableLoader)Mockito.mock(TableLoader.class);
        Mockito.when((Object)tableLoader.loadTable()).thenReturn((Object)loadedTable);
        new CachingTableSupplier(initialTable, tableLoader, Duration.ofMillis(100L));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new CachingTableSupplier(initialTable, tableLoader, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("tableRefreshInterval cannot be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new CachingTableSupplier(null, tableLoader, Duration.ofMillis(100L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("initialTable cannot be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new CachingTableSupplier(initialTable, null, Duration.ofMillis(100L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("tableLoader cannot be null");
    }

    @Test
    public void testTableReload() {
        SerializableTable initialTable = (SerializableTable)Mockito.mock(SerializableTable.class);
        Table loadedTable = (Table)Mockito.mock(Table.class);
        TableLoader tableLoader = (TableLoader)Mockito.mock(TableLoader.class);
        Mockito.when((Object)tableLoader.loadTable()).thenReturn((Object)loadedTable);
        CachingTableSupplier cachingTableSupplier = new CachingTableSupplier(initialTable, tableLoader, Duration.ofMillis(100L));
        cachingTableSupplier.refreshTable();
        Assertions.assertThat((Object)cachingTableSupplier.get()).isEqualTo((Object)initialTable);
        Awaitility.await().atLeast(100L, TimeUnit.MILLISECONDS).untilAsserted(() -> {
            cachingTableSupplier.refreshTable();
            Assertions.assertThat((Object)cachingTableSupplier.get()).isEqualTo((Object)loadedTable);
        });
    }
}

