/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.common.DynFields;
import org.apache.iceberg.flink.FlinkWriteConf;
import org.apache.iceberg.flink.FlinkWriteOptions;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.sink.FlinkAppenderFactory;
import org.apache.iceberg.flink.sink.FlinkSink;
import org.apache.iceberg.flink.sink.IcebergStreamWriter;
import org.apache.iceberg.io.BaseTaskWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.SerializableSupplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestCompressionSettings {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private Table table;
    private final Map<String, String> initProperties;

    @Parameterized.Parameters(name="tableProperties = {0}")
    public static Object[] parameters() {
        return new Object[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.avro.compression-codec", (Object)"zstd", (Object)"write.avro.compression-level", (Object)"3", (Object)"write.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-level", (Object)"3", (Object)"write.orc.compression-codec", (Object)"zstd", (Object)"write.orc.compression-strategy", (Object)"compression")};
    }

    public TestCompressionSettings(Map<String, String> initProperties) {
        this.initProperties = initProperties;
    }

    @Before
    public void before() throws IOException {
        File folder = this.tempFolder.newFolder();
        this.table = SimpleDataUtil.createTable(folder.getAbsolutePath(), this.initProperties, false);
    }

    @Test
    public void testCompressionAvro() throws Exception {
        Map<String, String> resultProperties = TestCompressionSettings.appenderProperties(this.table, SimpleDataUtil.FLINK_SCHEMA, (Map<String, String>)ImmutableMap.of((Object)FlinkWriteOptions.WRITE_FORMAT.key(), (Object)"AVRO"));
        if (this.initProperties.get("write.avro.compression-codec") == null) {
            Assert.assertEquals((Object)"gzip", (Object)resultProperties.get("write.avro.compression-codec"));
            Assert.assertEquals((Object)TableProperties.AVRO_COMPRESSION_LEVEL_DEFAULT, (Object)resultProperties.get("write.avro.compression-level"));
        } else {
            Assert.assertEquals((Object)this.initProperties.get("write.avro.compression-codec"), (Object)resultProperties.get("write.avro.compression-codec"));
            Assert.assertEquals((Object)this.initProperties.get("write.avro.compression-level"), (Object)resultProperties.get("write.avro.compression-level"));
        }
        resultProperties = TestCompressionSettings.appenderProperties(this.table, SimpleDataUtil.FLINK_SCHEMA, (Map<String, String>)ImmutableMap.of((Object)FlinkWriteOptions.WRITE_FORMAT.key(), (Object)"AVRO", (Object)FlinkWriteOptions.COMPRESSION_CODEC.key(), (Object)"snappy", (Object)FlinkWriteOptions.COMPRESSION_LEVEL.key(), (Object)"6"));
        Assert.assertEquals((Object)"snappy", (Object)resultProperties.get("write.avro.compression-codec"));
        Assert.assertEquals((Object)"6", (Object)resultProperties.get("write.avro.compression-level"));
    }

    @Test
    public void testCompressionParquet() throws Exception {
        Map<String, String> resultProperties = TestCompressionSettings.appenderProperties(this.table, SimpleDataUtil.FLINK_SCHEMA, (Map<String, String>)ImmutableMap.of((Object)FlinkWriteOptions.WRITE_FORMAT.key(), (Object)"PARQUET"));
        if (this.initProperties.get("write.parquet.compression-codec") == null) {
            Assert.assertEquals((Object)"zstd", (Object)resultProperties.get("write.parquet.compression-codec"));
            Assert.assertEquals((Object)TableProperties.PARQUET_COMPRESSION_LEVEL_DEFAULT, (Object)resultProperties.get("zstd"));
        } else {
            Assert.assertEquals((Object)this.initProperties.get("write.parquet.compression-codec"), (Object)resultProperties.get("write.parquet.compression-codec"));
            Assert.assertEquals((Object)this.initProperties.get("write.parquet.compression-level"), (Object)resultProperties.get("write.parquet.compression-level"));
        }
        resultProperties = TestCompressionSettings.appenderProperties(this.table, SimpleDataUtil.FLINK_SCHEMA, (Map<String, String>)ImmutableMap.of((Object)FlinkWriteOptions.WRITE_FORMAT.key(), (Object)"PARQUET", (Object)FlinkWriteOptions.COMPRESSION_CODEC.key(), (Object)"snappy", (Object)FlinkWriteOptions.COMPRESSION_LEVEL.key(), (Object)"6"));
        Assert.assertEquals((Object)"snappy", (Object)resultProperties.get("write.parquet.compression-codec"));
        Assert.assertEquals((Object)"6", (Object)resultProperties.get("write.parquet.compression-level"));
    }

    @Test
    public void testCompressionOrc() throws Exception {
        Map<String, String> resultProperties = TestCompressionSettings.appenderProperties(this.table, SimpleDataUtil.FLINK_SCHEMA, (Map<String, String>)ImmutableMap.of((Object)FlinkWriteOptions.WRITE_FORMAT.key(), (Object)"ORC"));
        if (this.initProperties.get("write.orc.compression-codec") == null) {
            Assert.assertEquals((Object)"zlib", (Object)resultProperties.get("write.orc.compression-codec"));
            Assert.assertEquals((Object)"speed", (Object)resultProperties.get("write.orc.compression-strategy"));
        } else {
            Assert.assertEquals((Object)this.initProperties.get("write.orc.compression-codec"), (Object)resultProperties.get("write.orc.compression-codec"));
            Assert.assertEquals((Object)this.initProperties.get("write.orc.compression-strategy"), (Object)resultProperties.get("write.orc.compression-strategy"));
        }
        resultProperties = TestCompressionSettings.appenderProperties(this.table, SimpleDataUtil.FLINK_SCHEMA, (Map<String, String>)ImmutableMap.of((Object)FlinkWriteOptions.WRITE_FORMAT.key(), (Object)"ORC", (Object)FlinkWriteOptions.COMPRESSION_CODEC.key(), (Object)"snappy", (Object)FlinkWriteOptions.COMPRESSION_STRATEGY.key(), (Object)"speed"));
        Assert.assertEquals((Object)"snappy", (Object)resultProperties.get("write.orc.compression-codec"));
        Assert.assertEquals((Object)"speed", (Object)resultProperties.get("write.orc.compression-strategy"));
    }

    private static OneInputStreamOperatorTestHarness<RowData, WriteResult> createIcebergStreamWriter(Table icebergTable, TableSchema flinkSchema, Map<String, String> override) throws Exception {
        RowType flinkRowType = FlinkSink.toFlinkRowType((Schema)icebergTable.schema(), (TableSchema)flinkSchema);
        FlinkWriteConf flinkWriteConfig = new FlinkWriteConf(icebergTable, override, (ReadableConfig)new Configuration());
        IcebergStreamWriter streamWriter = FlinkSink.createStreamWriter((SerializableSupplier & Serializable)() -> icebergTable, (FlinkWriteConf)flinkWriteConfig, (RowType)flinkRowType, null);
        OneInputStreamOperatorTestHarness harness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)streamWriter, 1, 1, 0);
        harness.setup();
        harness.open();
        return harness;
    }

    private static Map<String, String> appenderProperties(Table table, TableSchema schema, Map<String, String> override) throws Exception {
        try (OneInputStreamOperatorTestHarness<RowData, WriteResult> testHarness = TestCompressionSettings.createIcebergStreamWriter(table, schema, override);){
            testHarness.processElement((Object)SimpleDataUtil.createRowData(1, "hello"), 1L);
            testHarness.prepareSnapshotPreBarrier(1L);
            DynFields.BoundField operatorField = DynFields.builder().hiddenImpl(testHarness.getOperatorFactory().getClass(), "operator").build((Object)testHarness.getOperatorFactory());
            DynFields.BoundField writerField = DynFields.builder().hiddenImpl(IcebergStreamWriter.class, "writer").build(operatorField.get());
            DynFields.BoundField appenderField = DynFields.builder().hiddenImpl(BaseTaskWriter.class, "appenderFactory").build(writerField.get());
            DynFields.BoundField propsField = DynFields.builder().hiddenImpl(FlinkAppenderFactory.class, "props").build(appenderField.get());
            Map map = (Map)propsField.get();
            return map;
        }
    }
}

