/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.Row;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.flink.HadoopCatalogExtension;
import org.apache.iceberg.flink.MiniClusterResource;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.sink.FlinkSink;
import org.apache.iceberg.flink.sink.TestFlinkIcebergSinkBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestFlinkIcebergSinkBranch
extends TestFlinkIcebergSinkBase {
    @RegisterExtension
    public static final HadoopCatalogExtension CATALOG_EXTENSION = new HadoopCatalogExtension("default", "t");
    @Parameter(index=0)
    private String formatVersion;
    @Parameter(index=1)
    private String branch;
    private TableLoader tableLoader;

    @Parameters(name="formatVersion = {0}, branch = {1}")
    public static Object[][] parameters() {
        return new Object[][]{{"1", "main"}, {"1", "testBranch"}, {"2", "main"}, {"2", "testBranch"}};
    }

    @BeforeEach
    public void before() throws IOException {
        this.table = CATALOG_EXTENSION.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, SimpleDataUtil.SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"write.format.default", (Object)FileFormat.AVRO.name(), (Object)"format-version", (Object)this.formatVersion));
        this.env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)MiniClusterResource.DISABLE_CLASSLOADER_CHECK_CONFIG).enableCheckpointing(100L);
        this.tableLoader = CATALOG_EXTENSION.tableLoader();
    }

    @TestTemplate
    public void testWriteRowWithTableSchema() throws Exception {
        this.testWriteRow(SimpleDataUtil.FLINK_SCHEMA, DistributionMode.NONE);
        this.verifyOtherBranchUnmodified();
    }

    private void testWriteRow(TableSchema tableSchema, DistributionMode distributionMode) throws Exception {
        List<Row> rows = this.createRows("");
        DataStreamSource dataStream = this.env.addSource(this.createBoundedSource(rows), ROW_TYPE_INFO);
        FlinkSink.forRow((DataStream)dataStream, (TableSchema)SimpleDataUtil.FLINK_SCHEMA).table(this.table).tableLoader(this.tableLoader).tableSchema(tableSchema).toBranch(this.branch).distributionMode(distributionMode).append();
        this.env.execute("Test Iceberg DataStream.");
        SimpleDataUtil.assertTableRows(this.table, this.convertToRowData(rows), this.branch);
        SimpleDataUtil.assertTableRows(this.table, (List<RowData>)ImmutableList.of(), this.branch.equals("main") ? "test-branch" : "main");
        this.verifyOtherBranchUnmodified();
    }

    private void verifyOtherBranchUnmodified() {
        String otherBranch;
        String string = otherBranch = this.branch.equals("main") ? "test-branch" : "main";
        if (otherBranch.equals("main")) {
            Assertions.assertThat((Object)this.table.currentSnapshot()).isNull();
        }
        Assertions.assertThat((Object)this.table.snapshot(otherBranch)).isNull();
    }
}

