/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.types.Row;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.HadoopCatalogExtension;
import org.apache.iceberg.flink.MiniClusterResource;
import org.apache.iceberg.flink.MiniFlinkClusterExtension;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.sink.FlinkSink;
import org.apache.iceberg.flink.sink.TestFlinkIcebergSinkV2Base;
import org.apache.iceberg.flink.source.BoundedTestSource;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;

@ExtendWith(value={ParameterizedTestExtension.class})
@Timeout(value=60L)
public class TestFlinkIcebergSinkV2
extends TestFlinkIcebergSinkV2Base {
    @RegisterExtension
    public static MiniClusterExtension miniClusterResource = MiniFlinkClusterExtension.createWithClassloaderCheckDisabled();
    @RegisterExtension
    private static final HadoopCatalogExtension CATALOG_EXTENSION = new HadoopCatalogExtension("default", "t");

    @BeforeEach
    public void setupTable() {
        this.table = CATALOG_EXTENSION.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, SimpleDataUtil.SCHEMA, this.partitioned ? PartitionSpec.builderFor((Schema)SimpleDataUtil.SCHEMA).identity("data").build() : PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"write.format.default", (Object)this.format.name(), (Object)"format-version", (Object)String.valueOf(2)));
        this.table.updateProperties().set("write.format.default", this.format.name()).set("write.distribution-mode", this.writeDistributionMode).commit();
        this.env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)MiniClusterResource.DISABLE_CLASSLOADER_CHECK_CONFIG).enableCheckpointing(100L).setParallelism(this.parallelism).setMaxParallelism(this.parallelism);
        this.tableLoader = CATALOG_EXTENSION.tableLoader();
    }

    @TestTemplate
    public void testCheckAndGetEqualityFieldIds() {
        this.table.updateSchema().allowIncompatibleChanges().addRequiredColumn("type", (Type)Types.StringType.get()).setIdentifierFields(new String[]{"type"}).commit();
        DataStreamSource dataStream = this.env.addSource(new BoundedTestSource(ImmutableList.of()), ROW_TYPE_INFO);
        FlinkSink.Builder builder = FlinkSink.forRow((DataStream)dataStream, (TableSchema)SimpleDataUtil.FLINK_SCHEMA).table(this.table);
        Assertions.assertThat((List)builder.checkAndGetEqualityFieldIds()).containsExactlyInAnyOrderElementsOf((Iterable)this.table.schema().identifierFieldIds());
        builder.equalityFieldColumns((List)Lists.newArrayList((Object[])new String[]{"id"}));
        Assertions.assertThat((List)builder.checkAndGetEqualityFieldIds()).containsExactlyInAnyOrder((Object[])new Integer[]{this.table.schema().findField("id").fieldId()});
        builder.equalityFieldColumns((List)Lists.newArrayList((Object[])new String[]{"type"}));
        Assertions.assertThat((List)builder.checkAndGetEqualityFieldIds()).containsExactlyInAnyOrder((Object[])new Integer[]{this.table.schema().findField("type").fieldId()});
    }

    @TestTemplate
    public void testChangeLogOnIdKey() throws Exception {
        this.testChangeLogOnIdKey("main");
    }

    @TestTemplate
    public void testUpsertOnlyDeletesOnDataKey() throws Exception {
        ImmutableList elementsPerCheckpoint = ImmutableList.of((Object)ImmutableList.of((Object)this.row("+I", 1, "aaa")), (Object)ImmutableList.of((Object)this.row("-D", 1, "aaa"), (Object)this.row("-D", 2, "bbb")));
        ImmutableList expectedRecords = ImmutableList.of((Object)ImmutableList.of((Object)this.record(1, "aaa")), (Object)ImmutableList.of());
        this.testChangeLogs((List<String>)ImmutableList.of((Object)"data"), (KeySelector<Row, Object>)(KeySelector & Serializable)row -> row.getField(1), true, (List<List<Row>>)elementsPerCheckpoint, (List<List<Record>>)expectedRecords, "main");
    }

    @TestTemplate
    public void testChangeLogOnDataKey() throws Exception {
        this.testChangeLogOnDataKey("main");
    }

    @TestTemplate
    public void testChangeLogOnIdDataKey() throws Exception {
        this.testChangeLogOnIdDataKey("main");
    }

    @TestTemplate
    public void testChangeLogOnSameKey() throws Exception {
        this.testChangeLogOnSameKey("main");
    }

    @TestTemplate
    public void testUpsertModeCheck() throws Exception {
        DataStreamSource dataStream = this.env.addSource(new BoundedTestSource(ImmutableList.of()), ROW_TYPE_INFO);
        FlinkSink.Builder builder = FlinkSink.forRow((DataStream)dataStream, (TableSchema)SimpleDataUtil.FLINK_SCHEMA).tableLoader(this.tableLoader).tableSchema(SimpleDataUtil.FLINK_SCHEMA).writeParallelism(this.parallelism).upsert(true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.equalityFieldColumns((List)ImmutableList.of((Object)"id", (Object)"data")).overwrite(true).append()).isInstanceOf(IllegalStateException.class)).hasMessage("OVERWRITE mode shouldn't be enable when configuring to use UPSERT data stream.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.equalityFieldColumns((List)ImmutableList.of()).overwrite(false).append()).isInstanceOf(IllegalStateException.class)).hasMessage("Equality field columns shouldn't be empty when configuring to use UPSERT data stream.");
    }

    @TestTemplate
    public void testUpsertOnIdKey() throws Exception {
        this.testUpsertOnIdKey("main");
    }

    @TestTemplate
    public void testUpsertOnDataKey() throws Exception {
        this.testUpsertOnDataKey("main");
    }

    @TestTemplate
    public void testUpsertOnIdDataKey() throws Exception {
        this.testUpsertOnIdDataKey("main");
    }

    @TestTemplate
    public void testDeleteStats() throws Exception {
        Assumptions.assumeThat((Comparable)this.format).isNotEqualTo((Object)FileFormat.AVRO);
        ImmutableList elementsPerCheckpoint = ImmutableList.of((Object)ImmutableList.of((Object)this.row("+I", 1, "aaa"), (Object)this.row("-D", 1, "aaa"), (Object)this.row("+I", 1, "aaa")));
        ImmutableList expectedRecords = ImmutableList.of((Object)ImmutableList.of((Object)this.record(1, "aaa")));
        this.testChangeLogs((List<String>)ImmutableList.of((Object)"id", (Object)"data"), (KeySelector<Row, Object>)(KeySelector & Serializable)row -> Row.of((Object[])new Object[]{row.getField(0), row.getField(1)}), false, (List<List<Row>>)elementsPerCheckpoint, (List<List<Record>>)expectedRecords, "main");
        DeleteFile deleteFile = (DeleteFile)this.table.currentSnapshot().addedDeleteFiles(this.table.io()).iterator().next();
        String fromStat = new String(((ByteBuffer)deleteFile.lowerBounds().get(MetadataColumns.DELETE_FILE_PATH.fieldId())).array());
        DataFile dataFile = (DataFile)this.table.currentSnapshot().addedDataFiles(this.table.io()).iterator().next();
        Assumptions.assumeThat((String)fromStat).isEqualTo(dataFile.path().toString());
    }
}

