/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.sink.DeltaManifests;
import org.apache.iceberg.flink.sink.DeltaManifestsSerializer;
import org.apache.iceberg.flink.sink.FlinkAppenderFactory;
import org.apache.iceberg.flink.sink.FlinkManifestUtil;
import org.apache.iceberg.flink.sink.ManifestOutputFileFactory;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFlinkManifest {
    private static final Configuration CONF = new Configuration();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private Table table;
    private FileAppenderFactory<RowData> appenderFactory;
    private final AtomicInteger fileCount = new AtomicInteger(0);

    @Before
    public void before() throws IOException {
        File folder = this.tempFolder.newFolder();
        String warehouse = folder.getAbsolutePath();
        String tablePath = warehouse.concat("/test");
        Assert.assertTrue((String)"Should create the table directory correctly.", (boolean)new File(tablePath).mkdir());
        this.table = SimpleDataUtil.createTable(tablePath, (Map<String, String>)ImmutableMap.of(), false);
        int[] equalityFieldIds = new int[]{this.table.schema().findField("id").fieldId(), this.table.schema().findField("data").fieldId()};
        this.appenderFactory = new FlinkAppenderFactory(this.table, this.table.schema(), FlinkSchemaUtil.convert((Schema)this.table.schema()), this.table.properties(), this.table.spec(), equalityFieldIds, this.table.schema(), null);
    }

    @Test
    public void testIO() throws IOException {
        String flinkJobId = TestFlinkManifest.newFlinkJobId();
        String operatorId = TestFlinkManifest.newOperatorUniqueId();
        for (long checkpointId = 1L; checkpointId <= 3L; ++checkpointId) {
            int i;
            ManifestOutputFileFactory factory = FlinkManifestUtil.createOutputFileFactory(() -> this.table, (Map)this.table.properties(), (String)flinkJobId, (String)operatorId, (int)1, (long)1L);
            long curCkpId = checkpointId;
            List<DataFile> dataFiles = this.generateDataFiles(10);
            List<DeleteFile> eqDeleteFiles = this.generateEqDeleteFiles(5);
            List<DeleteFile> posDeleteFiles = this.generatePosDeleteFiles(5);
            DeltaManifests deltaManifests = FlinkManifestUtil.writeCompletedFiles((WriteResult)WriteResult.builder().addDataFiles(dataFiles).addDeleteFiles(eqDeleteFiles).addDeleteFiles(posDeleteFiles).build(), () -> factory.create(curCkpId), (PartitionSpec)this.table.spec());
            WriteResult result = FlinkManifestUtil.readCompletedFiles((DeltaManifests)deltaManifests, (FileIO)this.table.io(), (Map)this.table.specs());
            Assert.assertEquals((String)"Size of data file list are not equal.", (long)10L, (long)result.deleteFiles().length);
            for (i = 0; i < dataFiles.size(); ++i) {
                TestHelpers.assertEquals((ContentFile)dataFiles.get(i), result.dataFiles()[i]);
            }
            Assert.assertEquals((String)"Size of delete file list are not equal.", (long)10L, (long)result.dataFiles().length);
            for (i = 0; i < 5; ++i) {
                TestHelpers.assertEquals((ContentFile)eqDeleteFiles.get(i), result.deleteFiles()[i]);
            }
            for (i = 0; i < 5; ++i) {
                TestHelpers.assertEquals((ContentFile)posDeleteFiles.get(i), result.deleteFiles()[5 + i]);
            }
        }
    }

    @Test
    public void testUserProvidedManifestLocation() throws IOException {
        long checkpointId = 1L;
        String flinkJobId = TestFlinkManifest.newFlinkJobId();
        String operatorId = TestFlinkManifest.newOperatorUniqueId();
        File userProvidedFolder = this.tempFolder.newFolder();
        ImmutableMap props = ImmutableMap.of((Object)"flink.manifests.location", (Object)(userProvidedFolder.getAbsolutePath() + "///"));
        ManifestOutputFileFactory factory = new ManifestOutputFileFactory(() -> this.table, (Map)props, flinkJobId, operatorId, 1, 1L);
        List<DataFile> dataFiles = this.generateDataFiles(5);
        DeltaManifests deltaManifests = FlinkManifestUtil.writeCompletedFiles((WriteResult)WriteResult.builder().addDataFiles(dataFiles).build(), () -> factory.create(checkpointId), (PartitionSpec)this.table.spec());
        Assert.assertNotNull((String)"Data manifest shouldn't be null", (Object)deltaManifests.dataManifest());
        Assert.assertNull((String)"Delete manifest should be null", (Object)deltaManifests.deleteManifest());
        Assert.assertEquals((String)"The newly created manifest file should be located under the user provided directory", (Object)userProvidedFolder.toPath(), (Object)Paths.get(deltaManifests.dataManifest().path(), new String[0]).getParent());
        WriteResult result = FlinkManifestUtil.readCompletedFiles((DeltaManifests)deltaManifests, (FileIO)this.table.io(), (Map)this.table.specs());
        Assert.assertEquals((long)0L, (long)result.deleteFiles().length);
        Assert.assertEquals((long)5L, (long)result.dataFiles().length);
        Assert.assertEquals((String)"Size of data file list are not equal.", (long)dataFiles.size(), (long)result.dataFiles().length);
        for (int i = 0; i < dataFiles.size(); ++i) {
            TestHelpers.assertEquals((ContentFile)dataFiles.get(i), result.dataFiles()[i]);
        }
    }

    @Test
    public void testVersionedSerializer() throws IOException {
        long checkpointId = 1L;
        String flinkJobId = TestFlinkManifest.newFlinkJobId();
        String operatorId = TestFlinkManifest.newOperatorUniqueId();
        ManifestOutputFileFactory factory = FlinkManifestUtil.createOutputFileFactory(() -> this.table, (Map)this.table.properties(), (String)flinkJobId, (String)operatorId, (int)1, (long)1L);
        List<DataFile> dataFiles = this.generateDataFiles(10);
        List<DeleteFile> eqDeleteFiles = this.generateEqDeleteFiles(10);
        List<DeleteFile> posDeleteFiles = this.generatePosDeleteFiles(10);
        DeltaManifests expected = FlinkManifestUtil.writeCompletedFiles((WriteResult)WriteResult.builder().addDataFiles(dataFiles).addDeleteFiles(eqDeleteFiles).addDeleteFiles(posDeleteFiles).build(), () -> factory.create(checkpointId), (PartitionSpec)this.table.spec());
        byte[] versionedSerializeData = SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)DeltaManifestsSerializer.INSTANCE, (Object)expected);
        DeltaManifests actual = (DeltaManifests)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)DeltaManifestsSerializer.INSTANCE, (byte[])versionedSerializeData);
        TestHelpers.assertEquals(expected.dataManifest(), actual.dataManifest());
        TestHelpers.assertEquals(expected.deleteManifest(), actual.deleteManifest());
        byte[] versionedSerializeData2 = SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)DeltaManifestsSerializer.INSTANCE, (Object)actual);
        Assert.assertArrayEquals((byte[])versionedSerializeData, (byte[])versionedSerializeData2);
    }

    @Test
    public void testCompatibility() throws IOException {
        long checkpointId = 1L;
        String flinkJobId = TestFlinkManifest.newFlinkJobId();
        String operatorId = TestFlinkManifest.newOperatorUniqueId();
        ManifestOutputFileFactory factory = FlinkManifestUtil.createOutputFileFactory(() -> this.table, (Map)this.table.properties(), (String)flinkJobId, (String)operatorId, (int)1, (long)1L);
        List<DataFile> dataFiles = this.generateDataFiles(10);
        ManifestFile manifest = FlinkManifestUtil.writeDataFiles((OutputFile)factory.create(checkpointId), (PartitionSpec)this.table.spec(), dataFiles);
        byte[] dataV1 = SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)new V1Serializer(), (Object)manifest);
        DeltaManifests delta = (DeltaManifests)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)DeltaManifestsSerializer.INSTANCE, (byte[])dataV1);
        Assert.assertNull((String)"Serialization v1 don't include delete files.", (Object)delta.deleteManifest());
        Assert.assertNotNull((String)"Serialization v1 should not have null data manifest.", (Object)delta.dataManifest());
        TestHelpers.assertEquals(manifest, delta.dataManifest());
        List actualFiles = FlinkManifestUtil.readDataFiles((ManifestFile)delta.dataManifest(), (FileIO)this.table.io(), (Map)this.table.specs());
        Assert.assertEquals((long)10L, (long)actualFiles.size());
        for (int i = 0; i < 10; ++i) {
            TestHelpers.assertEquals((ContentFile)dataFiles.get(i), (ContentFile)actualFiles.get(i));
        }
    }

    private DataFile writeDataFile(String filename, List<RowData> rows) throws IOException {
        return SimpleDataUtil.writeFile(this.table, this.table.schema(), this.table.spec(), CONF, this.table.location(), FileFormat.PARQUET.addExtension(filename), rows);
    }

    private DeleteFile writeEqDeleteFile(String filename, List<RowData> deletes) throws IOException {
        return SimpleDataUtil.writeEqDeleteFile(this.table, FileFormat.PARQUET, filename, this.appenderFactory, deletes);
    }

    private DeleteFile writePosDeleteFile(String filename, List<Pair<CharSequence, Long>> positions) throws IOException {
        return SimpleDataUtil.writePosDeleteFile(this.table, FileFormat.PARQUET, filename, this.appenderFactory, positions);
    }

    private List<DataFile> generateDataFiles(int fileNum) throws IOException {
        ArrayList rowDataList = Lists.newArrayList();
        ArrayList dataFiles = Lists.newArrayList();
        for (int i = 0; i < fileNum; ++i) {
            rowDataList.add(SimpleDataUtil.createRowData(i, "a" + i));
            dataFiles.add(this.writeDataFile("data-file-" + this.fileCount.incrementAndGet(), rowDataList));
        }
        return dataFiles;
    }

    private List<DeleteFile> generateEqDeleteFiles(int fileNum) throws IOException {
        ArrayList rowDataList = Lists.newArrayList();
        ArrayList deleteFiles = Lists.newArrayList();
        for (int i = 0; i < fileNum; ++i) {
            rowDataList.add(SimpleDataUtil.createDelete(i, "a" + i));
            deleteFiles.add(this.writeEqDeleteFile("eq-delete-file-" + this.fileCount.incrementAndGet(), rowDataList));
        }
        return deleteFiles;
    }

    private List<DeleteFile> generatePosDeleteFiles(int fileNum) throws IOException {
        ArrayList positions = Lists.newArrayList();
        ArrayList deleteFiles = Lists.newArrayList();
        for (int i = 0; i < fileNum; ++i) {
            positions.add(Pair.of((Object)"data-file-1", (Object)i));
            deleteFiles.add(this.writePosDeleteFile("pos-delete-file-" + this.fileCount.incrementAndGet(), positions));
        }
        return deleteFiles;
    }

    private static String newFlinkJobId() {
        return UUID.randomUUID().toString();
    }

    private static String newOperatorUniqueId() {
        return UUID.randomUUID().toString();
    }

    private static class V1Serializer
    implements SimpleVersionedSerializer<ManifestFile> {
        private V1Serializer() {
        }

        public int getVersion() {
            return 1;
        }

        public byte[] serialize(ManifestFile m) throws IOException {
            return ManifestFiles.encode((ManifestFile)m);
        }

        public ManifestFile deserialize(int version, byte[] serialized) throws IOException {
            return ManifestFiles.decode((byte[])serialized);
        }
    }
}

