/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.sink.FlinkFileWriterFactory;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.TestPartitioningWriters;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.StructLikeSet;

public class TestFlinkPartitioningWriters<T>
extends TestPartitioningWriters<RowData> {
    @Parameters(name="formatVersion = {0}, fileFormat = {1}")
    protected static List<Object> parameters() {
        return Arrays.asList(new Object[]{2, FileFormat.AVRO}, new Object[]{2, FileFormat.PARQUET}, new Object[]{2, FileFormat.ORC});
    }

    protected FileWriterFactory<RowData> newWriterFactory(Schema dataSchema, List<Integer> equalityFieldIds, Schema equalityDeleteRowSchema, Schema positionDeleteRowSchema) {
        return FlinkFileWriterFactory.builderFor((Table)this.table).dataSchema(this.table.schema()).dataFileFormat(this.format()).deleteFileFormat(this.format()).equalityFieldIds(ArrayUtil.toIntArray(equalityFieldIds)).equalityDeleteRowSchema(equalityDeleteRowSchema).positionDeleteRowSchema(positionDeleteRowSchema).build();
    }

    protected RowData toRow(Integer id, String data) {
        return SimpleDataUtil.createRowData(id, data);
    }

    protected StructLikeSet toSet(Iterable<RowData> rows) {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        RowType flinkType = FlinkSchemaUtil.convert((Schema)this.table.schema());
        for (RowData row : rows) {
            RowDataWrapper wrapper = new RowDataWrapper(flinkType, this.table.schema().asStruct());
            set.add((StructLike)wrapper.wrap(row));
        }
        return set;
    }
}

