/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.flink.sink.shuffle.AggregatedStatistics;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.MapDataStatistics;
import org.apache.iceberg.flink.sink.shuffle.MapDataStatisticsSerializer;
import org.apache.iceberg.flink.sink.shuffle.SortKeySerializer;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestAggregatedStatistics {
    private final Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"str", (Type)Types.StringType.get())});
    private final SortOrder sortOrder = ((SortOrder.Builder)SortOrder.builderFor((Schema)this.schema).asc("str")).build();
    private final SortKey sortKey = new SortKey(this.schema, this.sortOrder);
    private final MapDataStatisticsSerializer statisticsSerializer = MapDataStatisticsSerializer.fromSortKeySerializer((TypeSerializer)new SortKeySerializer(this.schema, this.sortOrder));

    @Test
    public void mergeDataStatisticTest() {
        SortKey keyA = this.sortKey.copy();
        keyA.set(0, (Object)"a");
        SortKey keyB = this.sortKey.copy();
        keyB.set(0, (Object)"b");
        AggregatedStatistics aggregatedStatistics = new AggregatedStatistics(1L, (TypeSerializer)this.statisticsSerializer);
        MapDataStatistics mapDataStatistics1 = new MapDataStatistics();
        mapDataStatistics1.add(keyA);
        mapDataStatistics1.add(keyA);
        mapDataStatistics1.add(keyB);
        aggregatedStatistics.mergeDataStatistic("testOperator", 1L, (DataStatistics)mapDataStatistics1);
        MapDataStatistics mapDataStatistics2 = new MapDataStatistics();
        mapDataStatistics2.add(keyA);
        aggregatedStatistics.mergeDataStatistic("testOperator", 1L, (DataStatistics)mapDataStatistics2);
        Assertions.assertThat((Long)((Long)((Map)aggregatedStatistics.dataStatistics().statistics()).get(keyA))).isEqualTo((Long)mapDataStatistics1.statistics().get(keyA) + (Long)mapDataStatistics2.statistics().get(keyA));
        Assertions.assertThat((Long)((Long)((Map)aggregatedStatistics.dataStatistics().statistics()).get(keyB))).isEqualTo((Long)mapDataStatistics1.statistics().get(keyB) + mapDataStatistics2.statistics().getOrDefault(keyB, 0L));
    }
}

