/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Map;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.sink.shuffle.MapDataStatistics;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMapDataStatistics {
    private final SortOrder sortOrder = ((SortOrder.Builder)SortOrder.builderFor((Schema)TestFixtures.SCHEMA).asc("data")).build();
    private final SortKey sortKey = new SortKey(TestFixtures.SCHEMA, this.sortOrder);
    private final RowType rowType = FlinkSchemaUtil.convert((Schema)TestFixtures.SCHEMA);
    private final RowDataWrapper rowWrapper = new RowDataWrapper(this.rowType, TestFixtures.SCHEMA.asStruct());

    @Test
    public void testAddsAndGet() {
        MapDataStatistics dataStatistics = new MapDataStatistics();
        GenericRowData reusedRow = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"a"), 1, StringData.fromString((String)"2023-06-20")});
        this.sortKey.wrap((StructLike)this.rowWrapper.wrap((RowData)reusedRow));
        dataStatistics.add(this.sortKey);
        reusedRow.setField(0, (Object)StringData.fromString((String)"b"));
        this.sortKey.wrap((StructLike)this.rowWrapper.wrap((RowData)reusedRow));
        dataStatistics.add(this.sortKey);
        reusedRow.setField(0, (Object)StringData.fromString((String)"c"));
        this.sortKey.wrap((StructLike)this.rowWrapper.wrap((RowData)reusedRow));
        dataStatistics.add(this.sortKey);
        reusedRow.setField(0, (Object)StringData.fromString((String)"b"));
        this.sortKey.wrap((StructLike)this.rowWrapper.wrap((RowData)reusedRow));
        dataStatistics.add(this.sortKey);
        reusedRow.setField(0, (Object)StringData.fromString((String)"a"));
        this.sortKey.wrap((StructLike)this.rowWrapper.wrap((RowData)reusedRow));
        dataStatistics.add(this.sortKey);
        reusedRow.setField(0, (Object)StringData.fromString((String)"b"));
        this.sortKey.wrap((StructLike)this.rowWrapper.wrap((RowData)reusedRow));
        dataStatistics.add(this.sortKey);
        Map actual = dataStatistics.statistics();
        this.rowWrapper.wrap((RowData)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"a"), 1, StringData.fromString((String)"2023-06-20")}));
        this.sortKey.wrap((StructLike)this.rowWrapper);
        SortKey keyA = this.sortKey.copy();
        this.rowWrapper.wrap((RowData)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"b"), 1, StringData.fromString((String)"2023-06-20")}));
        this.sortKey.wrap((StructLike)this.rowWrapper);
        SortKey keyB = this.sortKey.copy();
        this.rowWrapper.wrap((RowData)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"c"), 1, StringData.fromString((String)"2023-06-20")}));
        this.sortKey.wrap((StructLike)this.rowWrapper);
        SortKey keyC = this.sortKey.copy();
        ImmutableMap expected = ImmutableMap.of((Object)keyA, (Object)2L, (Object)keyB, (Object)3L, (Object)keyC, (Object)1L);
        Assertions.assertThat((Map)actual).isEqualTo((Object)expected);
    }
}

