/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.DeleteReadTests;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestFlinkReaderDeletesBase
extends DeleteReadTests {
    protected static String databaseName = "default";
    protected static HiveConf hiveConf = null;
    protected static HiveCatalog catalog = null;
    private static TestHiveMetastore metastore = null;

    @BeforeAll
    public static void startMetastore() {
        metastore = new TestHiveMetastore();
        metastore.start();
        hiveConf = metastore.hiveConf();
        catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of(), (Object)hiveConf);
    }

    @AfterAll
    public static void stopMetastore() throws Exception {
        metastore.stop();
        catalog = null;
    }

    protected Table createTable(String name, Schema schema, PartitionSpec spec) {
        HashMap props = Maps.newHashMap();
        props.put("write.format.default", this.format.name());
        Table table = catalog.createTable(TableIdentifier.of((String[])new String[]{databaseName, name}), schema, spec, (Map)props);
        TableOperations ops = ((BaseTable)table).operations();
        TableMetadata meta = ops.current();
        ops.commit(meta, meta.upgradeToFormatVersion(2));
        return table;
    }

    protected void dropTable(String name) {
        catalog.dropTable(TableIdentifier.of((String[])new String[]{databaseName, name}));
    }

    protected boolean expectPruned() {
        return false;
    }
}

