/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.source.FlinkSource;
import org.apache.iceberg.flink.source.TestFlinkScan;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public abstract class TestFlinkSource
extends TestFlinkScan {
    @Override
    protected List<Row> runWithProjection(String ... projected) throws Exception {
        TableSchema.Builder builder = TableSchema.builder();
        TableSchema schema = FlinkSchemaUtil.toSchema((RowType)FlinkSchemaUtil.convert((Schema)CATALOG_EXTENSION.catalog().loadTable(TestFixtures.TABLE_IDENTIFIER).schema()));
        for (String field : projected) {
            TableColumn column = (TableColumn)schema.getTableColumn(field).get();
            builder.field(column.getName(), column.getType());
        }
        return this.run(FlinkSource.forRowData().project(builder.build()), Maps.newHashMap(), "", projected);
    }

    @Override
    protected List<Row> runWithFilter(Expression filter, String sqlFilter, boolean caseSensitive) throws Exception {
        FlinkSource.Builder builder = FlinkSource.forRowData().filters(Collections.singletonList(filter));
        HashMap options = Maps.newHashMap();
        options.put("case-sensitive", Boolean.toString(caseSensitive));
        return this.run(builder, options, sqlFilter, "*");
    }

    @Override
    protected List<Row> runWithOptions(Map<String, String> options) throws Exception {
        FlinkSource.Builder builder = FlinkSource.forRowData();
        Optional.ofNullable(options.get("case-sensitive")).ifPresent(value -> builder.caseSensitive(Boolean.parseBoolean(value)));
        Optional.ofNullable(options.get("snapshot-id")).ifPresent(value -> builder.snapshotId(Long.valueOf(Long.parseLong(value))));
        Optional.ofNullable(options.get("tag")).ifPresent(value -> builder.tag(value));
        Optional.ofNullable(options.get("branch")).ifPresent(value -> builder.branch(value));
        Optional.ofNullable(options.get("start-tag")).ifPresent(value -> builder.startTag(value));
        Optional.ofNullable(options.get("end-tag")).ifPresent(value -> builder.endTag(value));
        Optional.ofNullable(options.get("start-snapshot-id")).ifPresent(value -> builder.startSnapshotId(Long.valueOf(Long.parseLong(value))));
        Optional.ofNullable(options.get("end-snapshot-id")).ifPresent(value -> builder.endSnapshotId(Long.valueOf(Long.parseLong(value))));
        Optional.ofNullable(options.get("as-of-timestamp")).ifPresent(value -> builder.asOfTimestamp(Long.valueOf(Long.parseLong(value))));
        return this.run(builder, options, "", "*");
    }

    @Override
    protected List<Row> run() throws Exception {
        return this.run(FlinkSource.forRowData(), Maps.newHashMap(), "", "*");
    }

    protected abstract List<Row> run(FlinkSource.Builder var1, Map<String, String> var2, String var3, String ... var4) throws Exception;
}

