/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.data.RowDataProjection;
import org.apache.iceberg.flink.sink.RowDataTaskWriterFactory;
import org.apache.iceberg.flink.source.FlinkInputFormat;
import org.apache.iceberg.flink.source.FlinkSource;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestProjectMetaColumn {
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();
    private final FileFormat format;

    @Parameterized.Parameters(name="fileFormat={0}")
    public static Iterable<Object[]> parameters() {
        return Lists.newArrayList((Object[])new Object[][]{{FileFormat.PARQUET}, {FileFormat.ORC}, {FileFormat.AVRO}});
    }

    public TestProjectMetaColumn(FileFormat format) {
        this.format = format;
    }

    private void testSkipToRemoveMetaColumn(int formatVersion) throws IOException {
        String location = this.folder.getRoot().getAbsolutePath();
        Table table = SimpleDataUtil.createTable(location, (Map<String, String>)ImmutableMap.of((Object)"format-version", (Object)String.valueOf(formatVersion)), false);
        ArrayList rows = Lists.newArrayList((Object[])new RowData[]{SimpleDataUtil.createInsert(1, "AAA"), SimpleDataUtil.createInsert(2, "BBB"), SimpleDataUtil.createInsert(3, "CCC")});
        this.writeAndCommit(table, (List<Integer>)ImmutableList.of(), false, rows);
        FlinkInputFormat input = FlinkSource.forRowData().tableLoader(TableLoader.fromHadoopTable((String)location)).buildFormat();
        ArrayList results = Lists.newArrayList();
        TestHelpers.readRowData(input, rowData -> {
            Assert.assertTrue((boolean)(rowData instanceof GenericRowData));
            results.add(TestHelpers.copyRowData(rowData, SimpleDataUtil.ROW_TYPE));
        });
        TestHelpers.assertRows(rows, results, SimpleDataUtil.ROW_TYPE);
    }

    @Test
    public void testV1SkipToRemoveMetaColumn() throws IOException {
        this.testSkipToRemoveMetaColumn(1);
    }

    @Test
    public void testV2SkipToRemoveMetaColumn() throws IOException {
        this.testSkipToRemoveMetaColumn(2);
    }

    @Test
    public void testV2RemoveMetaColumn() throws Exception {
        String location = this.folder.getRoot().getAbsolutePath();
        Table table = SimpleDataUtil.createTable(location, (Map<String, String>)ImmutableMap.of((Object)"format-version", (Object)"2"), false);
        ArrayList rows = Lists.newArrayList((Object[])new RowData[]{SimpleDataUtil.createInsert(1, "AAA"), SimpleDataUtil.createDelete(1, "AAA"), SimpleDataUtil.createInsert(2, "AAA"), SimpleDataUtil.createInsert(2, "BBB")});
        int eqFieldId = table.schema().findField("data").fieldId();
        this.writeAndCommit(table, (List<Integer>)ImmutableList.of((Object)eqFieldId), true, rows);
        FlinkInputFormat input = FlinkSource.forRowData().tableLoader(TableLoader.fromHadoopTable((String)location)).buildFormat();
        ArrayList results = Lists.newArrayList();
        TestHelpers.readRowData(input, rowData -> {
            Assert.assertTrue((boolean)(rowData instanceof RowDataProjection));
            results.add(TestHelpers.copyRowData(rowData, SimpleDataUtil.ROW_TYPE));
        });
        TestHelpers.assertRows((List<RowData>)ImmutableList.of((Object)SimpleDataUtil.createInsert(2, "AAA"), (Object)SimpleDataUtil.createInsert(2, "BBB")), results, SimpleDataUtil.ROW_TYPE);
    }

    private void writeAndCommit(Table table, List<Integer> eqFieldIds, boolean upsert, List<RowData> rows) throws IOException {
        TaskWriter<RowData> writer;
        try (TaskWriter<RowData> io = writer = this.createTaskWriter(table, eqFieldIds, upsert);){
            for (RowData row : rows) {
                io.write((Object)row);
            }
        }
        RowDelta delta = table.newRowDelta();
        WriteResult result = writer.complete();
        for (DataFile dataFile : result.dataFiles()) {
            delta.addRows(dataFile);
        }
        for (DataFile dataFile : result.deleteFiles()) {
            delta.addDeletes((DeleteFile)dataFile);
        }
        delta.commit();
    }

    private TaskWriter<RowData> createTaskWriter(Table table, List<Integer> equalityFieldIds, boolean upsert) {
        RowDataTaskWriterFactory taskWriterFactory = new RowDataTaskWriterFactory(SerializableTable.copyOf((Table)table), SimpleDataUtil.ROW_TYPE, 0x20000000L, this.format, table.properties(), equalityFieldIds, upsert);
        taskWriterFactory.initialize(1, 1);
        return taskWriterFactory.create();
    }
}

