/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.source.SourceUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestSourceUtil {
    @Test
    public void testInferedParallelism() throws IOException {
        Configuration configuration = new Configuration();
        int parallelism = SourceUtil.inferParallelism((ReadableConfig)configuration, (long)-1L, () -> 0);
        Assert.assertEquals((String)"Should produce the expected parallelism.", (long)1L, (long)parallelism);
        parallelism = SourceUtil.inferParallelism((ReadableConfig)configuration, (long)-1L, () -> 2);
        Assert.assertEquals((String)"Should produce the expected parallelism.", (long)2L, (long)parallelism);
        parallelism = SourceUtil.inferParallelism((ReadableConfig)configuration, (long)1L, () -> 2);
        Assert.assertEquals((String)"Should produce the expected parallelism.", (long)1L, (long)parallelism);
        configuration.setInteger(FlinkConfigOptions.TABLE_EXEC_ICEBERG_INFER_SOURCE_PARALLELISM_MAX, 1);
        parallelism = SourceUtil.inferParallelism((ReadableConfig)configuration, (long)-1L, () -> 2);
        Assert.assertEquals((String)"Should produce the expected parallelism.", (long)1L, (long)parallelism);
        parallelism = SourceUtil.inferParallelism((ReadableConfig)configuration, (long)3L, () -> 2);
        Assert.assertEquals((String)"Should produce the expected parallelism.", (long)1L, (long)parallelism);
        configuration.setBoolean(FlinkConfigOptions.TABLE_EXEC_ICEBERG_INFER_SOURCE_PARALLELISM, false);
        parallelism = SourceUtil.inferParallelism((ReadableConfig)configuration, (long)3L, () -> 2);
        Assert.assertEquals((String)"Should produce the expected parallelism.", (long)1L, (long)parallelism);
    }
}

