/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.enumerator;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderHelper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.flink.HadoopTableExtension;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.flink.source.StreamingStartingStrategy;
import org.apache.iceberg.flink.source.enumerator.ContinuousSplitPlannerImpl;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

public class TestContinuousSplitPlannerImplStartStrategy {
    private static final FileFormat FILE_FORMAT = FileFormat.PARQUET;
    @TempDir
    protected Path temporaryFolder;
    @RegisterExtension
    private static final HadoopTableExtension TABLE_RESOURCE = new HadoopTableExtension("default", "t", TestFixtures.SCHEMA);
    private GenericAppenderHelper dataAppender;
    private Snapshot snapshot1;
    private Snapshot snapshot2;
    private Snapshot snapshot3;

    @BeforeEach
    public void before() throws IOException {
        this.dataAppender = new GenericAppenderHelper(TABLE_RESOURCE.table(), FILE_FORMAT, this.temporaryFolder);
    }

    private void appendThreeSnapshots() throws IOException {
        List batch1 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)0L);
        this.dataAppender.appendToTable(batch1);
        this.snapshot1 = TABLE_RESOURCE.table().currentSnapshot();
        List batch2 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)1L);
        this.dataAppender.appendToTable(batch2);
        this.snapshot2 = TABLE_RESOURCE.table().currentSnapshot();
        List batch3 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)2L);
        this.dataAppender.appendToTable(batch3);
        this.snapshot3 = TABLE_RESOURCE.table().currentSnapshot();
    }

    @Test
    public void testTableScanThenIncrementalStrategy() throws IOException {
        ScanContext scanContext = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.TABLE_SCAN_THEN_INCREMENTAL).build();
        Assertions.assertThat((Optional)ContinuousSplitPlannerImpl.startSnapshot((Table)TABLE_RESOURCE.table(), (ScanContext)scanContext)).isNotPresent();
        this.appendThreeSnapshots();
        Snapshot startSnapshot = (Snapshot)ContinuousSplitPlannerImpl.startSnapshot((Table)TABLE_RESOURCE.table(), (ScanContext)scanContext).get();
        Assertions.assertThat((long)startSnapshot.snapshotId()).isEqualTo(this.snapshot3.snapshotId());
    }

    @Test
    public void testForLatestSnapshotStrategy() throws IOException {
        ScanContext scanContext = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_LATEST_SNAPSHOT).build();
        Assertions.assertThat((Optional)ContinuousSplitPlannerImpl.startSnapshot((Table)TABLE_RESOURCE.table(), (ScanContext)scanContext)).isNotPresent();
        this.appendThreeSnapshots();
        Snapshot startSnapshot = (Snapshot)ContinuousSplitPlannerImpl.startSnapshot((Table)TABLE_RESOURCE.table(), (ScanContext)scanContext).get();
        Assertions.assertThat((long)startSnapshot.snapshotId()).isEqualTo(this.snapshot3.snapshotId());
    }

    @Test
    public void testForEarliestSnapshotStrategy() throws IOException {
        ScanContext scanContext = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_EARLIEST_SNAPSHOT).build();
        Assertions.assertThat((Optional)ContinuousSplitPlannerImpl.startSnapshot((Table)TABLE_RESOURCE.table(), (ScanContext)scanContext)).isNotPresent();
        this.appendThreeSnapshots();
        Snapshot startSnapshot = (Snapshot)ContinuousSplitPlannerImpl.startSnapshot((Table)TABLE_RESOURCE.table(), (ScanContext)scanContext).get();
        Assertions.assertThat((long)startSnapshot.snapshotId()).isEqualTo(this.snapshot1.snapshotId());
    }

    @Test
    public void testForSpecificSnapshotIdStrategy() throws IOException {
        ScanContext scanContextInvalidSnapshotId = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_ID).startSnapshotId(Long.valueOf(1L)).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContinuousSplitPlannerImpl.startSnapshot((Table)TABLE_RESOURCE.table(), (ScanContext)scanContextInvalidSnapshotId)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Start snapshot id not found in history: 1");
        this.appendThreeSnapshots();
        ScanContext scanContext = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_ID).startSnapshotId(Long.valueOf(this.snapshot2.snapshotId())).build();
        Snapshot startSnapshot = (Snapshot)ContinuousSplitPlannerImpl.startSnapshot((Table)TABLE_RESOURCE.table(), (ScanContext)scanContext).get();
        Assertions.assertThat((long)startSnapshot.snapshotId()).isEqualTo(this.snapshot2.snapshotId());
    }

    @Test
    public void testForSpecificSnapshotTimestampStrategySnapshot2() throws IOException {
        ScanContext scanContextInvalidSnapshotTimestamp = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP).startSnapshotTimestamp(Long.valueOf(1L)).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContinuousSplitPlannerImpl.startSnapshot((Table)TABLE_RESOURCE.table(), (ScanContext)scanContextInvalidSnapshotTimestamp)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot find a snapshot after: ");
        this.appendThreeSnapshots();
        ScanContext scanContext = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP).startSnapshotTimestamp(Long.valueOf(this.snapshot2.timestampMillis())).build();
        Snapshot startSnapshot = (Snapshot)ContinuousSplitPlannerImpl.startSnapshot((Table)TABLE_RESOURCE.table(), (ScanContext)scanContext).get();
        Assertions.assertThat((long)startSnapshot.snapshotId()).isEqualTo(this.snapshot2.snapshotId());
    }

    @Test
    public void testForSpecificSnapshotTimestampStrategySnapshot2Minus1() throws IOException {
        this.appendThreeSnapshots();
        ScanContext config = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP).startSnapshotTimestamp(Long.valueOf(this.snapshot2.timestampMillis() - 1L)).build();
        Snapshot startSnapshot = (Snapshot)ContinuousSplitPlannerImpl.startSnapshot((Table)TABLE_RESOURCE.table(), (ScanContext)config).get();
        Assertions.assertThat((long)startSnapshot.snapshotId()).isEqualTo(this.snapshot2.snapshotId());
    }
}

