/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.enumerator;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.flink.source.SplitHelpers;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorPosition;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorState;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorStateSerializer;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.flink.source.split.IcebergSourceSplitState;
import org.apache.iceberg.flink.source.split.IcebergSourceSplitStatus;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestIcebergEnumeratorStateSerializer {
    @TempDir
    protected Path temporaryFolder;
    private final IcebergEnumeratorStateSerializer serializer = new IcebergEnumeratorStateSerializer(true);
    @Parameter(index=0)
    protected int version;

    @Parameters(name="version={0}")
    public static Object[][] parameters() {
        return new Object[][]{{1}, {2}};
    }

    @TestTemplate
    public void testEmptySnapshotIdAndPendingSplits() throws Exception {
        IcebergEnumeratorState enumeratorState = new IcebergEnumeratorState(Collections.emptyList());
        this.testSerializer(enumeratorState);
    }

    @TestTemplate
    public void testSomeSnapshotIdAndEmptyPendingSplits() throws Exception {
        IcebergEnumeratorPosition position = IcebergEnumeratorPosition.of((long)1L, (Long)System.currentTimeMillis());
        IcebergEnumeratorState enumeratorState = new IcebergEnumeratorState(position, Collections.emptyList());
        this.testSerializer(enumeratorState);
    }

    @TestTemplate
    public void testSomeSnapshotIdAndPendingSplits() throws Exception {
        IcebergEnumeratorPosition position = IcebergEnumeratorPosition.of((long)2L, (Long)System.currentTimeMillis());
        List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(this.temporaryFolder, 3, 1);
        ArrayList pendingSplits = Lists.newArrayList();
        pendingSplits.add(new IcebergSourceSplitState(splits.get(0), IcebergSourceSplitStatus.UNASSIGNED));
        pendingSplits.add(new IcebergSourceSplitState(splits.get(1), IcebergSourceSplitStatus.ASSIGNED));
        pendingSplits.add(new IcebergSourceSplitState(splits.get(2), IcebergSourceSplitStatus.COMPLETED));
        IcebergEnumeratorState enumeratorState = new IcebergEnumeratorState(position, (Collection)pendingSplits);
        this.testSerializer(enumeratorState);
    }

    @TestTemplate
    public void testEnumerationSplitCountHistory() throws Exception {
        if (this.version == 2) {
            IcebergEnumeratorPosition position = IcebergEnumeratorPosition.of((long)2L, (Long)System.currentTimeMillis());
            List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(this.temporaryFolder, 3, 1);
            ArrayList pendingSplits = Lists.newArrayList();
            pendingSplits.add(new IcebergSourceSplitState(splits.get(0), IcebergSourceSplitStatus.UNASSIGNED));
            pendingSplits.add(new IcebergSourceSplitState(splits.get(1), IcebergSourceSplitStatus.ASSIGNED));
            pendingSplits.add(new IcebergSourceSplitState(splits.get(2), IcebergSourceSplitStatus.COMPLETED));
            int[] enumerationSplitCountHistory = new int[]{1, 2, 3};
            IcebergEnumeratorState enumeratorState = new IcebergEnumeratorState(position, (Collection)pendingSplits, enumerationSplitCountHistory);
            this.testSerializer(enumeratorState);
        }
    }

    private void testSerializer(IcebergEnumeratorState enumeratorState) throws IOException {
        byte[] result = this.version == 1 ? this.serializer.serializeV1(enumeratorState) : this.serializer.serialize(enumeratorState);
        IcebergEnumeratorState deserialized = this.serializer.deserialize(this.version, result);
        this.assertEnumeratorStateEquals(enumeratorState, deserialized);
    }

    private void assertEnumeratorStateEquals(IcebergEnumeratorState expected, IcebergEnumeratorState actual) {
        Assertions.assertThat((Object)actual.lastEnumeratedPosition()).isEqualTo((Object)expected.lastEnumeratedPosition());
        Assertions.assertThat((Collection)actual.pendingSplits()).hasSameSizeAs((Iterable)expected.pendingSplits());
        Iterator expectedIterator = expected.pendingSplits().iterator();
        Iterator actualIterator = actual.pendingSplits().iterator();
        for (int i = 0; i < expected.pendingSplits().size(); ++i) {
            IcebergSourceSplitState expectedSplitState = (IcebergSourceSplitState)expectedIterator.next();
            IcebergSourceSplitState actualSplitState = (IcebergSourceSplitState)actualIterator.next();
            Assertions.assertThat((String)actualSplitState.split().splitId()).isEqualTo(expectedSplitState.split().splitId());
            Assertions.assertThat((int)actualSplitState.split().fileOffset()).isEqualTo(expectedSplitState.split().fileOffset());
            Assertions.assertThat((long)actualSplitState.split().recordOffset()).isEqualTo(expectedSplitState.split().recordOffset());
            Assertions.assertThat((Comparable)actualSplitState.status()).isEqualTo((Object)expectedSplitState.status());
        }
        Assertions.assertThat((int[])actual.enumerationSplitCountHistory()).containsExactly(expected.enumerationSplitCountHistory());
    }
}

