/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.split;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.flink.source.SplitHelpers;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.flink.source.split.IcebergSourceSplitSerializer;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestIcebergSourceSplitSerializer {
    @TempDir
    protected Path temporaryFolder;
    private final IcebergSourceSplitSerializer serializer = new IcebergSourceSplitSerializer(true);

    @Test
    public void testLatestVersion() throws Exception {
        this.serializeAndDeserialize(1, 1);
        this.serializeAndDeserialize(10, 2);
    }

    private void serializeAndDeserialize(int splitCount, int filesPerSplit) throws Exception {
        List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(this.temporaryFolder, splitCount, filesPerSplit);
        for (IcebergSourceSplit split : splits) {
            byte[] result = this.serializer.serialize(split);
            IcebergSourceSplit deserialized = this.serializer.deserialize(this.serializer.getVersion(), result);
            this.assertSplitEquals(split, deserialized);
            byte[] cachedResult = this.serializer.serialize(split);
            Assertions.assertThat((byte[])cachedResult).isSameAs((Object)result);
            IcebergSourceSplit deserialized2 = this.serializer.deserialize(this.serializer.getVersion(), cachedResult);
            this.assertSplitEquals(split, deserialized2);
            split.updatePosition(0, 100L);
            byte[] resultAfterUpdatePosition = this.serializer.serialize(split);
            Assertions.assertThat((byte[])resultAfterUpdatePosition).isNotSameAs((Object)cachedResult);
            IcebergSourceSplit deserialized3 = this.serializer.deserialize(this.serializer.getVersion(), resultAfterUpdatePosition);
            this.assertSplitEquals(split, deserialized3);
        }
    }

    @Test
    public void testV1() throws Exception {
        this.serializeAndDeserializeV1(1, 1);
        this.serializeAndDeserializeV1(10, 2);
    }

    private void serializeAndDeserializeV1(int splitCount, int filesPerSplit) throws Exception {
        List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(this.temporaryFolder, splitCount, filesPerSplit);
        for (IcebergSourceSplit split : splits) {
            byte[] result = split.serializeV1();
            IcebergSourceSplit deserialized = IcebergSourceSplit.deserializeV1((byte[])result);
            this.assertSplitEquals(split, deserialized);
        }
    }

    @Test
    public void testV2() throws Exception {
        this.serializeAndDeserializeV2(1, 1);
        this.serializeAndDeserializeV2(10, 2);
    }

    private void serializeAndDeserializeV2(int splitCount, int filesPerSplit) throws Exception {
        List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(this.temporaryFolder, splitCount, filesPerSplit);
        for (IcebergSourceSplit split : splits) {
            byte[] result = split.serializeV2();
            IcebergSourceSplit deserialized = IcebergSourceSplit.deserializeV2((byte[])result, (boolean)true);
            this.assertSplitEquals(split, deserialized);
        }
    }

    @Test
    public void testV3WithTooManyDeleteFiles() throws Exception {
        this.serializeAndDeserializeV3(1, 1, 5000);
    }

    private void serializeAndDeserializeV3(int splitCount, int filesPerSplit, int mockDeletesPerSplit) throws Exception {
        List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(this.temporaryFolder, splitCount, filesPerSplit);
        List<IcebergSourceSplit> splitsWithMockDeleteFiles = SplitHelpers.equipSplitsWithMockDeleteFiles(splits, this.temporaryFolder, mockDeletesPerSplit);
        for (IcebergSourceSplit split : splitsWithMockDeleteFiles) {
            byte[] result = split.serializeV3();
            IcebergSourceSplit deserialized = IcebergSourceSplit.deserializeV3((byte[])result, (boolean)true);
            this.assertSplitEquals(split, deserialized);
        }
    }

    @Test
    public void testDeserializeV1() throws Exception {
        List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(this.temporaryFolder, 1, 1);
        for (IcebergSourceSplit split : splits) {
            byte[] result = split.serializeV1();
            IcebergSourceSplit deserialized = this.serializer.deserialize(1, result);
            this.assertSplitEquals(split, deserialized);
        }
    }

    @Test
    public void testCheckpointedPosition() throws Exception {
        AtomicInteger index = new AtomicInteger();
        List splits = SplitHelpers.createSplitsFromTransientHadoopTable(this.temporaryFolder, 10, 2).stream().map(split -> {
            IcebergSourceSplit result = index.get() % 2 == 0 ? IcebergSourceSplit.fromCombinedScanTask((CombinedScanTask)split.task(), (int)1, (long)1L) : split;
            index.incrementAndGet();
            return result;
        }).collect(Collectors.toList());
        for (IcebergSourceSplit split2 : splits) {
            byte[] result = this.serializer.serialize(split2);
            IcebergSourceSplit deserialized = this.serializer.deserialize(this.serializer.getVersion(), result);
            this.assertSplitEquals(split2, deserialized);
            byte[] cachedResult = this.serializer.serialize(split2);
            Assertions.assertThat((byte[])cachedResult).isSameAs((Object)result);
            IcebergSourceSplit deserialized2 = this.serializer.deserialize(this.serializer.getVersion(), cachedResult);
            this.assertSplitEquals(split2, deserialized2);
        }
    }

    private void assertSplitEquals(IcebergSourceSplit expected, IcebergSourceSplit actual) {
        ArrayList expectedTasks = Lists.newArrayList(expected.task().tasks().iterator());
        ArrayList actualTasks = Lists.newArrayList(actual.task().tasks().iterator());
        Assertions.assertThat((List)actualTasks).hasSameSizeAs((Iterable)expectedTasks);
        for (int i = 0; i < expectedTasks.size(); ++i) {
            FileScanTask expectedTask = (FileScanTask)expectedTasks.get(i);
            FileScanTask actualTask = (FileScanTask)actualTasks.get(i);
            Assertions.assertThat((CharSequence)((DataFile)actualTask.file()).path()).isEqualTo((Object)((DataFile)expectedTask.file()).path());
            Assertions.assertThat((long)actualTask.sizeBytes()).isEqualTo(expectedTask.sizeBytes());
            Assertions.assertThat((int)actualTask.filesCount()).isEqualTo(expectedTask.filesCount());
            Assertions.assertThat((long)actualTask.start()).isEqualTo(expectedTask.start());
            Assertions.assertThat((long)actualTask.length()).isEqualTo(expectedTask.length());
        }
        Assertions.assertThat((int)actual.fileOffset()).isEqualTo(expected.fileOffset());
        Assertions.assertThat((long)actual.recordOffset()).isEqualTo(expected.recordOffset());
    }
}

