/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.util;

import org.apache.iceberg.flink.util.FlinkPackage;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TestFlinkPackage {
    @Test
    public void testVersion() {
        Assertions.assertThat((String)FlinkPackage.version()).isEqualTo("1.18.1");
    }

    @Test
    public void testDefaultVersion() {
        FlinkPackage.setVersion(null);
        try (MockedStatic mockedStatic = Mockito.mockStatic(FlinkPackage.class);){
            mockedStatic.when(FlinkPackage::versionFromJar).thenThrow(RuntimeException.class);
            mockedStatic.when(FlinkPackage::version).thenCallRealMethod();
            Assertions.assertThat((String)FlinkPackage.version()).isEqualTo("FLINK-UNKNOWN-VERSION");
        }
        FlinkPackage.setVersion(null);
        mockedStatic = Mockito.mockStatic(FlinkPackage.class);
        var2_2 = null;
        try {
            mockedStatic.when(FlinkPackage::versionFromJar).thenReturn(null);
            mockedStatic.when(FlinkPackage::version).thenCallRealMethod();
            FlinkPackage.setVersion(null);
            Assertions.assertThat((String)FlinkPackage.version()).isEqualTo("FLINK-UNKNOWN-VERSION");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (mockedStatic != null) {
                TestFlinkPackage.$closeResource(var2_2, (AutoCloseable)mockedStatic);
            }
        }
    }
}

