/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.time.Duration;
import java.util.Map;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.flink.FlinkConfParser;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.FlinkWriteOptions;

public class FlinkWriteConf {
    private final FlinkConfParser confParser;

    public FlinkWriteConf(Table table, Map<String, String> writeOptions, ReadableConfig readableConfig) {
        this.confParser = new FlinkConfParser(table, writeOptions, readableConfig);
    }

    public boolean overwriteMode() {
        return ((FlinkConfParser.BooleanConfParser)((FlinkConfParser.BooleanConfParser)this.confParser.booleanConf().option(FlinkWriteOptions.OVERWRITE_MODE.key())).flinkConfig(FlinkWriteOptions.OVERWRITE_MODE)).defaultValue((Boolean)FlinkWriteOptions.OVERWRITE_MODE.defaultValue()).parse();
    }

    public boolean upsertMode() {
        return ((FlinkConfParser.BooleanConfParser)((FlinkConfParser.BooleanConfParser)((FlinkConfParser.BooleanConfParser)this.confParser.booleanConf().option(FlinkWriteOptions.WRITE_UPSERT_ENABLED.key())).flinkConfig(FlinkWriteOptions.WRITE_UPSERT_ENABLED)).tableProperty("write.upsert.enabled")).defaultValue(false).parse();
    }

    public FileFormat dataFileFormat() {
        String valueAsString = ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkWriteOptions.WRITE_FORMAT.key())).flinkConfig(FlinkWriteOptions.WRITE_FORMAT)).tableProperty("write.format.default")).defaultValue("parquet").parse();
        return FileFormat.fromString((String)valueAsString);
    }

    public long targetDataFileSize() {
        return ((FlinkConfParser.LongConfParser)((FlinkConfParser.LongConfParser)((FlinkConfParser.LongConfParser)this.confParser.longConf().option(FlinkWriteOptions.TARGET_FILE_SIZE_BYTES.key())).flinkConfig(FlinkWriteOptions.TARGET_FILE_SIZE_BYTES)).tableProperty("write.target-file-size-bytes")).defaultValue(0x20000000L).parse();
    }

    public String parquetCompressionCodec() {
        return ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkWriteOptions.COMPRESSION_CODEC.key())).flinkConfig(FlinkWriteOptions.COMPRESSION_CODEC)).tableProperty("write.parquet.compression-codec")).defaultValue("gzip").parse();
    }

    public String parquetCompressionLevel() {
        return ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkWriteOptions.COMPRESSION_LEVEL.key())).flinkConfig(FlinkWriteOptions.COMPRESSION_LEVEL)).tableProperty("write.parquet.compression-level")).defaultValue(TableProperties.PARQUET_COMPRESSION_LEVEL_DEFAULT).parseOptional();
    }

    public String avroCompressionCodec() {
        return ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkWriteOptions.COMPRESSION_CODEC.key())).flinkConfig(FlinkWriteOptions.COMPRESSION_CODEC)).tableProperty("write.avro.compression-codec")).defaultValue("gzip").parse();
    }

    public String avroCompressionLevel() {
        return ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkWriteOptions.COMPRESSION_LEVEL.key())).flinkConfig(FlinkWriteOptions.COMPRESSION_LEVEL)).tableProperty("write.avro.compression-level")).defaultValue(TableProperties.AVRO_COMPRESSION_LEVEL_DEFAULT).parseOptional();
    }

    public String orcCompressionCodec() {
        return ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkWriteOptions.COMPRESSION_CODEC.key())).flinkConfig(FlinkWriteOptions.COMPRESSION_CODEC)).tableProperty("write.orc.compression-codec")).defaultValue("zlib").parse();
    }

    public String orcCompressionStrategy() {
        return ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkWriteOptions.COMPRESSION_STRATEGY.key())).flinkConfig(FlinkWriteOptions.COMPRESSION_STRATEGY)).tableProperty("write.orc.compression-strategy")).defaultValue("speed").parse();
    }

    public DistributionMode distributionMode() {
        String modeName = ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkWriteOptions.DISTRIBUTION_MODE.key())).flinkConfig(FlinkWriteOptions.DISTRIBUTION_MODE)).tableProperty("write.distribution-mode")).defaultValue("none").parse();
        return DistributionMode.fromName((String)modeName);
    }

    public int workerPoolSize() {
        return ((FlinkConfParser.IntConfParser)this.confParser.intConf().flinkConfig(FlinkConfigOptions.TABLE_EXEC_ICEBERG_WORKER_POOL_SIZE)).defaultValue((Integer)FlinkConfigOptions.TABLE_EXEC_ICEBERG_WORKER_POOL_SIZE.defaultValue()).parse();
    }

    public String branch() {
        return ((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkWriteOptions.BRANCH.key())).defaultValue((String)FlinkWriteOptions.BRANCH.defaultValue()).parse();
    }

    public Integer writeParallelism() {
        return ((FlinkConfParser.IntConfParser)this.confParser.intConf().option(FlinkWriteOptions.WRITE_PARALLELISM.key())).parseOptional();
    }

    @Experimental
    public Duration tableRefreshInterval() {
        return ((FlinkConfParser.DurationConfParser)((FlinkConfParser.DurationConfParser)this.confParser.durationConf().option(FlinkWriteOptions.TABLE_REFRESH_INTERVAL.key())).flinkConfig(FlinkWriteOptions.TABLE_REFRESH_INTERVAL)).parseOptional();
    }
}

