/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.NaNUtil;

public class FlinkFilters {
    private static final Pattern STARTS_WITH_PATTERN = Pattern.compile("([^%]+)%");
    private static final Map<FunctionDefinition, Expression.Operation> FILTERS = ImmutableMap.builder().put((Object)BuiltInFunctionDefinitions.EQUALS, (Object)Expression.Operation.EQ).put((Object)BuiltInFunctionDefinitions.NOT_EQUALS, (Object)Expression.Operation.NOT_EQ).put((Object)BuiltInFunctionDefinitions.GREATER_THAN, (Object)Expression.Operation.GT).put((Object)BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL, (Object)Expression.Operation.GT_EQ).put((Object)BuiltInFunctionDefinitions.LESS_THAN, (Object)Expression.Operation.LT).put((Object)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, (Object)Expression.Operation.LT_EQ).put((Object)BuiltInFunctionDefinitions.IS_NULL, (Object)Expression.Operation.IS_NULL).put((Object)BuiltInFunctionDefinitions.IS_NOT_NULL, (Object)Expression.Operation.NOT_NULL).put((Object)BuiltInFunctionDefinitions.AND, (Object)Expression.Operation.AND).put((Object)BuiltInFunctionDefinitions.OR, (Object)Expression.Operation.OR).put((Object)BuiltInFunctionDefinitions.NOT, (Object)Expression.Operation.NOT).put((Object)BuiltInFunctionDefinitions.LIKE, (Object)Expression.Operation.STARTS_WITH).buildOrThrow();

    private FlinkFilters() {
    }

    public static Optional<org.apache.iceberg.expressions.Expression> convert(Expression flinkExpression) {
        if (!(flinkExpression instanceof CallExpression)) {
            return Optional.empty();
        }
        CallExpression call = (CallExpression)flinkExpression;
        Expression.Operation op = FILTERS.get(call.getFunctionDefinition());
        if (op != null) {
            switch (op) {
                case IS_NULL: {
                    return FlinkFilters.onlyChildAs(call, FieldReferenceExpression.class).map(FieldReferenceExpression::getName).map(Expressions::isNull);
                }
                case NOT_NULL: {
                    return FlinkFilters.onlyChildAs(call, FieldReferenceExpression.class).map(FieldReferenceExpression::getName).map(Expressions::notNull);
                }
                case LT: {
                    return FlinkFilters.convertFieldAndLiteral(Expressions::lessThan, Expressions::greaterThan, call);
                }
                case LT_EQ: {
                    return FlinkFilters.convertFieldAndLiteral(Expressions::lessThanOrEqual, Expressions::greaterThanOrEqual, call);
                }
                case GT: {
                    return FlinkFilters.convertFieldAndLiteral(Expressions::greaterThan, Expressions::lessThan, call);
                }
                case GT_EQ: {
                    return FlinkFilters.convertFieldAndLiteral(Expressions::greaterThanOrEqual, Expressions::lessThanOrEqual, call);
                }
                case EQ: {
                    return FlinkFilters.convertFieldAndLiteral((ref, lit) -> {
                        if (NaNUtil.isNaN((Object)lit)) {
                            return Expressions.isNaN((String)ref);
                        }
                        return Expressions.equal((String)ref, (Object)lit);
                    }, call);
                }
                case NOT_EQ: {
                    return FlinkFilters.convertFieldAndLiteral((ref, lit) -> {
                        if (NaNUtil.isNaN((Object)lit)) {
                            return Expressions.notNaN((String)ref);
                        }
                        return Expressions.notEqual((String)ref, (Object)lit);
                    }, call);
                }
                case NOT: {
                    return FlinkFilters.onlyChildAs(call, CallExpression.class).flatMap(FlinkFilters::convert).map(Expressions::not);
                }
                case AND: {
                    return FlinkFilters.convertLogicExpression(Expressions::and, call);
                }
                case OR: {
                    return FlinkFilters.convertLogicExpression(Expressions::or, call);
                }
                case STARTS_WITH: {
                    return FlinkFilters.convertLike(call);
                }
            }
        }
        return Optional.empty();
    }

    private static <T extends ResolvedExpression> Optional<T> onlyChildAs(CallExpression call, Class<T> expectedChildClass) {
        List children = call.getResolvedChildren();
        if (children.size() != 1) {
            return Optional.empty();
        }
        ResolvedExpression child = (ResolvedExpression)children.get(0);
        if (!expectedChildClass.isInstance(child)) {
            return Optional.empty();
        }
        return Optional.of((ResolvedExpression)expectedChildClass.cast(child));
    }

    private static Optional<org.apache.iceberg.expressions.Expression> convertLike(CallExpression call) {
        List args = call.getResolvedChildren();
        if (args.size() != 2) {
            return Optional.empty();
        }
        Expression left = (Expression)args.get(0);
        Expression right = (Expression)args.get(1);
        if (left instanceof FieldReferenceExpression && right instanceof ValueLiteralExpression) {
            String name = ((FieldReferenceExpression)left).getName();
            return FlinkFilters.convertLiteral((ValueLiteralExpression)right).flatMap(lit -> {
                if (lit instanceof String) {
                    String pattern = (String)lit;
                    Matcher matcher = STARTS_WITH_PATTERN.matcher(pattern);
                    if (!pattern.contains("_") && matcher.matches()) {
                        return Optional.of(Expressions.startsWith((String)name, (String)matcher.group(1)));
                    }
                }
                return Optional.empty();
            });
        }
        return Optional.empty();
    }

    private static Optional<org.apache.iceberg.expressions.Expression> convertLogicExpression(BiFunction<org.apache.iceberg.expressions.Expression, org.apache.iceberg.expressions.Expression, org.apache.iceberg.expressions.Expression> function, CallExpression call) {
        List args = call.getResolvedChildren();
        if (args == null || args.size() != 2) {
            return Optional.empty();
        }
        Optional<org.apache.iceberg.expressions.Expression> left = FlinkFilters.convert((Expression)args.get(0));
        Optional<org.apache.iceberg.expressions.Expression> right = FlinkFilters.convert((Expression)args.get(1));
        if (left.isPresent() && right.isPresent()) {
            return Optional.of(function.apply(left.get(), right.get()));
        }
        return Optional.empty();
    }

    private static Optional<Object> convertLiteral(ValueLiteralExpression expression) {
        Optional value = expression.getValueAs(expression.getOutputDataType().getLogicalType().getDefaultConversion());
        return value.map(o -> {
            if (o instanceof LocalDateTime) {
                return DateTimeUtil.microsFromTimestamp((LocalDateTime)((LocalDateTime)o));
            }
            if (o instanceof Instant) {
                return DateTimeUtil.microsFromInstant((Instant)((Instant)o));
            }
            if (o instanceof LocalTime) {
                return DateTimeUtil.microsFromTime((LocalTime)((LocalTime)o));
            }
            if (o instanceof LocalDate) {
                return DateTimeUtil.daysFromDate((LocalDate)((LocalDate)o));
            }
            return o;
        });
    }

    private static Optional<org.apache.iceberg.expressions.Expression> convertFieldAndLiteral(BiFunction<String, Object, org.apache.iceberg.expressions.Expression> expr, CallExpression call) {
        return FlinkFilters.convertFieldAndLiteral(expr, expr, call);
    }

    private static Optional<org.apache.iceberg.expressions.Expression> convertFieldAndLiteral(BiFunction<String, Object, org.apache.iceberg.expressions.Expression> convertLR, BiFunction<String, Object, org.apache.iceberg.expressions.Expression> convertRL, CallExpression call) {
        List args = call.getResolvedChildren();
        if (args.size() != 2) {
            return Optional.empty();
        }
        Expression left = (Expression)args.get(0);
        Expression right = (Expression)args.get(1);
        if (left instanceof FieldReferenceExpression && right instanceof ValueLiteralExpression) {
            String name = ((FieldReferenceExpression)left).getName();
            Optional<Object> lit = FlinkFilters.convertLiteral((ValueLiteralExpression)right);
            if (lit.isPresent()) {
                return Optional.of(convertLR.apply(name, lit.get()));
            }
        } else if (left instanceof ValueLiteralExpression && right instanceof FieldReferenceExpression) {
            Optional<Object> lit = FlinkFilters.convertLiteral((ValueLiteralExpression)left);
            String name = ((FieldReferenceExpression)right).getName();
            if (lit.isPresent()) {
                return Optional.of(convertRL.apply(name, lit.get()));
            }
        }
        return Optional.empty();
    }
}

