/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.data.FlinkOrcReaders;
import org.apache.iceberg.orc.OrcRowReader;
import org.apache.iceberg.orc.OrcSchemaWithTypeVisitor;
import org.apache.iceberg.orc.OrcValueReader;
import org.apache.iceberg.orc.OrcValueReaders;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

public class FlinkOrcReader
implements OrcRowReader<RowData> {
    private final OrcValueReader<?> reader;

    public FlinkOrcReader(Schema iSchema, TypeDescription readSchema) {
        this(iSchema, readSchema, (Map<Integer, ?>)ImmutableMap.of());
    }

    public FlinkOrcReader(Schema iSchema, TypeDescription readSchema, Map<Integer, ?> idToConstant) {
        this.reader = (OrcValueReader)OrcSchemaWithTypeVisitor.visit((Schema)iSchema, (TypeDescription)readSchema, (OrcSchemaWithTypeVisitor)new ReadBuilder(idToConstant));
    }

    public RowData read(VectorizedRowBatch batch, int row) {
        return (RowData)this.reader.read((ColumnVector)new StructColumnVector(batch.size, batch.cols), row);
    }

    public void setBatchContext(long batchOffsetInFile) {
        this.reader.setBatchContext(batchOffsetInFile);
    }

    private static class ReadBuilder
    extends OrcSchemaWithTypeVisitor<OrcValueReader<?>> {
        private final Map<Integer, ?> idToConstant;

        private ReadBuilder(Map<Integer, ?> idToConstant) {
            this.idToConstant = idToConstant;
        }

        public OrcValueReader<RowData> record(Types.StructType iStruct, TypeDescription record, List<String> names, List<OrcValueReader<?>> fields) {
            return FlinkOrcReaders.struct(fields, iStruct, this.idToConstant);
        }

        public OrcValueReader<ArrayData> list(Types.ListType iList, TypeDescription array, OrcValueReader<?> elementReader) {
            return FlinkOrcReaders.array(elementReader);
        }

        public OrcValueReader<MapData> map(Types.MapType iMap, TypeDescription map, OrcValueReader<?> keyReader, OrcValueReader<?> valueReader) {
            return FlinkOrcReaders.map(keyReader, valueReader);
        }

        public OrcValueReader<?> primitive(Type.PrimitiveType iPrimitive, TypeDescription primitive) {
            switch (iPrimitive.typeId()) {
                case BOOLEAN: {
                    return OrcValueReaders.booleans();
                }
                case INTEGER: {
                    return OrcValueReaders.ints();
                }
                case LONG: {
                    return OrcValueReaders.longs();
                }
                case FLOAT: {
                    return OrcValueReaders.floats();
                }
                case DOUBLE: {
                    return OrcValueReaders.doubles();
                }
                case DATE: {
                    return FlinkOrcReaders.dates();
                }
                case TIME: {
                    return FlinkOrcReaders.times();
                }
                case TIMESTAMP: {
                    Types.TimestampType timestampType = (Types.TimestampType)iPrimitive;
                    if (timestampType.shouldAdjustToUTC()) {
                        return FlinkOrcReaders.timestampTzs();
                    }
                    return FlinkOrcReaders.timestamps();
                }
                case STRING: {
                    return FlinkOrcReaders.strings();
                }
                case UUID: 
                case FIXED: 
                case BINARY: {
                    return OrcValueReaders.bytes();
                }
                case DECIMAL: {
                    Types.DecimalType decimalType = (Types.DecimalType)iPrimitive;
                    return FlinkOrcReaders.decimals(decimalType.precision(), decimalType.scale());
                }
            }
            throw new IllegalArgumentException(String.format("Invalid iceberg type %s corresponding to ORC type %s", iPrimitive, primitive));
        }
    }
}

