/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.operator;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

@Internal
class TableChange {
    private int dataFileNum;
    private int deleteFileNum;
    private long dataFileSize;
    private long deleteFileSize;
    private int commitNum;

    TableChange(int dataFileNum, int deleteFileNum, long dataFileSize, long deleteFileSize, int commitNum) {
        this.dataFileNum = dataFileNum;
        this.deleteFileNum = deleteFileNum;
        this.dataFileSize = dataFileSize;
        this.deleteFileSize = deleteFileSize;
        this.commitNum = commitNum;
    }

    TableChange(Snapshot snapshot, FileIO io) {
        Iterable dataFiles = snapshot.addedDataFiles(io);
        Iterable deleteFiles = snapshot.addedDeleteFiles(io);
        dataFiles.forEach(dataFile -> {
            ++this.dataFileNum;
            this.dataFileSize += dataFile.fileSizeInBytes();
        });
        deleteFiles.forEach(deleteFile -> {
            ++this.deleteFileNum;
            this.deleteFileSize += deleteFile.fileSizeInBytes();
        });
        this.commitNum = 1;
    }

    static TableChange empty() {
        return new TableChange(0, 0, 0L, 0L, 0);
    }

    int dataFileNum() {
        return this.dataFileNum;
    }

    int deleteFileNum() {
        return this.deleteFileNum;
    }

    long dataFileSize() {
        return this.dataFileSize;
    }

    long deleteFileSize() {
        return this.deleteFileSize;
    }

    public int commitNum() {
        return this.commitNum;
    }

    public void merge(TableChange other) {
        this.dataFileNum += other.dataFileNum;
        this.deleteFileNum += other.deleteFileNum;
        this.dataFileSize += other.dataFileSize;
        this.deleteFileSize += other.deleteFileSize;
        this.commitNum += other.commitNum;
    }

    TableChange copy() {
        return new TableChange(this.dataFileNum, this.deleteFileNum, this.dataFileSize, this.deleteFileSize, this.commitNum);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dataFileNum", this.dataFileNum).add("deleteFileNum", this.deleteFileNum).add("dataFileSize", this.dataFileSize).add("deleteFileSize", this.deleteFileSize).add("commitNum", this.commitNum).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TableChange that = (TableChange)other;
        return this.dataFileNum == that.dataFileNum && this.deleteFileNum == that.deleteFileNum && this.dataFileSize == that.dataFileSize && this.deleteFileSize == that.deleteFileSize && this.commitNum == that.commitNum;
    }

    public int hashCode() {
        return Objects.hash(this.dataFileNum, this.deleteFileNum, this.dataFileSize, this.deleteFileSize, this.commitNum);
    }
}

