/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.iceberg.flink.sink.IcebergStreamWriterMetrics;
import org.apache.iceberg.flink.sink.TaskWriterFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

class IcebergStreamWriter<T>
extends AbstractStreamOperator<WriteResult>
implements OneInputStreamOperator<T, WriteResult>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final String fullTableName;
    private final TaskWriterFactory<T> taskWriterFactory;
    private transient TaskWriter<T> writer;
    private transient int subTaskId;
    private transient int attemptId;
    private transient IcebergStreamWriterMetrics writerMetrics;

    IcebergStreamWriter(String fullTableName, TaskWriterFactory<T> taskWriterFactory) {
        this.fullTableName = fullTableName;
        this.taskWriterFactory = taskWriterFactory;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    public void open() {
        this.subTaskId = this.getRuntimeContext().getIndexOfThisSubtask();
        this.attemptId = this.getRuntimeContext().getAttemptNumber();
        this.writerMetrics = new IcebergStreamWriterMetrics((MetricGroup)this.metrics, this.fullTableName);
        this.taskWriterFactory.initialize(this.subTaskId, this.attemptId);
        this.writer = this.taskWriterFactory.create();
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        this.flush();
        this.writer = this.taskWriterFactory.create();
    }

    public void processElement(StreamRecord<T> element) throws Exception {
        this.writer.write(element.getValue());
    }

    public void close() throws Exception {
        super.close();
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public void endInput() throws IOException {
        this.flush();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("table_name", (Object)this.fullTableName).add("subtask_id", this.subTaskId).add("attempt_id", this.attemptId).toString();
    }

    private void flush() throws IOException {
        if (this.writer == null) {
            return;
        }
        long startNano = System.nanoTime();
        WriteResult result = this.writer.complete();
        this.writerMetrics.updateFlushResult(result);
        this.output.collect((Object)new StreamRecord((Object)result));
        this.writerMetrics.flushDuration(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNano));
        this.writer = null;
    }
}

