/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class AggregatedStatistics
implements Serializable {
    private final long checkpointId;
    private final StatisticsType type;
    private final Map<SortKey, Long> keyFrequency;
    private final SortKey[] rangeBounds;

    AggregatedStatistics(long checkpointId, StatisticsType type, Map<SortKey, Long> keyFrequency, SortKey[] rangeBounds) {
        Preconditions.checkArgument((keyFrequency != null && rangeBounds == null || keyFrequency == null && rangeBounds != null ? 1 : 0) != 0, (Object)"Invalid key frequency or range bounds: both are non-null or null");
        this.checkpointId = checkpointId;
        this.type = type;
        this.keyFrequency = keyFrequency;
        this.rangeBounds = rangeBounds;
    }

    static AggregatedStatistics fromKeyFrequency(long checkpointId, Map<SortKey, Long> stats) {
        return new AggregatedStatistics(checkpointId, StatisticsType.Map, stats, null);
    }

    static AggregatedStatistics fromRangeBounds(long checkpointId, SortKey[] stats) {
        return new AggregatedStatistics(checkpointId, StatisticsType.Sketch, null, stats);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("checkpointId", this.checkpointId).add("type", (Object)this.type).add("keyFrequency", this.keyFrequency).add("rangeBounds", (Object)this.rangeBounds).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregatedStatistics)) {
            return false;
        }
        AggregatedStatistics other = (AggregatedStatistics)o;
        return Objects.equal((Object)this.checkpointId, (Object)other.checkpointId()) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type())) && Objects.equal(this.keyFrequency, other.keyFrequency()) && Arrays.equals(this.rangeBounds, other.rangeBounds());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.checkpointId, this.type, this.keyFrequency, this.rangeBounds});
    }

    StatisticsType type() {
        return this.type;
    }

    Map<SortKey, Long> keyFrequency() {
        return this.keyFrequency;
    }

    SortKey[] rangeBounds() {
        return this.rangeBounds;
    }

    long checkpointId() {
        return this.checkpointId;
    }
}

