/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.flink.sink.shuffle.AggregatedStatistics;
import org.apache.iceberg.flink.sink.shuffle.SortKeySerializer;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;

public class AggregatedStatisticsSerializer
extends TypeSerializer<AggregatedStatistics> {
    private final TypeSerializer<SortKey> sortKeySerializer;
    private final EnumSerializer<StatisticsType> statisticsTypeSerializer;
    private final MapSerializer<SortKey, Long> keyFrequencySerializer;
    private final ListSerializer<SortKey> rangeBoundsSerializer;

    AggregatedStatisticsSerializer(TypeSerializer<SortKey> sortKeySerializer) {
        this.sortKeySerializer = sortKeySerializer;
        this.statisticsTypeSerializer = new EnumSerializer(StatisticsType.class);
        this.keyFrequencySerializer = new MapSerializer(sortKeySerializer, (TypeSerializer)LongSerializer.INSTANCE);
        this.rangeBoundsSerializer = new ListSerializer(sortKeySerializer);
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<AggregatedStatistics> duplicate() {
        return new AggregatedStatisticsSerializer(this.sortKeySerializer);
    }

    public AggregatedStatistics createInstance() {
        return new AggregatedStatistics(0L, StatisticsType.Map, Collections.emptyMap(), null);
    }

    public AggregatedStatistics copy(AggregatedStatistics from) {
        return new AggregatedStatistics(from.checkpointId(), from.type(), from.keyFrequency(), from.rangeBounds());
    }

    public AggregatedStatistics copy(AggregatedStatistics from, AggregatedStatistics reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(AggregatedStatistics record, DataOutputView target) throws IOException {
        target.writeLong(record.checkpointId());
        this.statisticsTypeSerializer.serialize((Enum)record.type(), target);
        if (record.type() == StatisticsType.Map) {
            this.keyFrequencySerializer.serialize(record.keyFrequency(), target);
        } else {
            this.rangeBoundsSerializer.serialize(Arrays.asList(record.rangeBounds()), target);
        }
    }

    public AggregatedStatistics deserialize(DataInputView source) throws IOException {
        long checkpointId = source.readLong();
        StatisticsType type = (StatisticsType)this.statisticsTypeSerializer.deserialize(source);
        Map keyFrequency = null;
        SortKey[] rangeBounds = null;
        if (type == StatisticsType.Map) {
            keyFrequency = this.keyFrequencySerializer.deserialize(source);
        } else {
            List sortKeys = this.rangeBoundsSerializer.deserialize(source);
            rangeBounds = new SortKey[sortKeys.size()];
            rangeBounds = sortKeys.toArray(rangeBounds);
        }
        return new AggregatedStatistics(checkpointId, type, keyFrequency, rangeBounds);
    }

    public AggregatedStatistics deserialize(AggregatedStatistics reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AggregatedStatisticsSerializer)) {
            return false;
        }
        AggregatedStatisticsSerializer other = (AggregatedStatisticsSerializer)((Object)obj);
        return Objects.equals(this.sortKeySerializer, other.sortKeySerializer);
    }

    public int hashCode() {
        return this.sortKeySerializer.hashCode();
    }

    public TypeSerializerSnapshot<AggregatedStatistics> snapshotConfiguration() {
        return new AggregatedStatisticsSerializerSnapshot(this);
    }

    public static class AggregatedStatisticsSerializerSnapshot
    extends CompositeTypeSerializerSnapshot<AggregatedStatistics, AggregatedStatisticsSerializer> {
        private static final int CURRENT_VERSION = 1;

        public AggregatedStatisticsSerializerSnapshot() {
        }

        public AggregatedStatisticsSerializerSnapshot(AggregatedStatisticsSerializer serializer) {
            super((TypeSerializer)serializer);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected TypeSerializer<?>[] getNestedSerializers(AggregatedStatisticsSerializer outerSerializer) {
            return new TypeSerializer[]{outerSerializer.sortKeySerializer};
        }

        protected AggregatedStatisticsSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            SortKeySerializer sortKeySerializer = (SortKeySerializer)nestedSerializers[0];
            return new AggregatedStatisticsSerializer(sortKeySerializer);
        }
    }
}

