/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Arrays;
import org.apache.datasketches.sampling.ReservoirItemsSketch;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;

class SketchDataStatistics
implements DataStatistics {
    private final ReservoirItemsSketch<SortKey> sketch;

    SketchDataStatistics(int reservoirSize) {
        this.sketch = ReservoirItemsSketch.newInstance((int)reservoirSize);
    }

    SketchDataStatistics(ReservoirItemsSketch<SortKey> sketchStats) {
        this.sketch = sketchStats;
    }

    @Override
    public StatisticsType type() {
        return StatisticsType.Sketch;
    }

    @Override
    public boolean isEmpty() {
        return this.sketch.getNumSamples() == 0;
    }

    @Override
    public void add(SortKey sortKey) {
        SortKey copiedKey = sortKey.copy();
        this.sketch.update((Object)copiedKey);
    }

    @Override
    public Object result() {
        return this.sketch;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sketch", this.sketch).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SketchDataStatistics)) {
            return false;
        }
        ReservoirItemsSketch<SortKey> otherSketch = ((SketchDataStatistics)o).sketch;
        return Objects.equal((Object)this.sketch.getK(), (Object)otherSketch.getK()) && Objects.equal((Object)this.sketch.getN(), (Object)otherSketch.getN()) && Arrays.deepEquals(this.sketch.getSamples(), otherSketch.getSamples());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sketch.getK(), this.sketch.getN(), this.sketch.getSamples()});
    }
}

