/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.ProviderContext;
import org.apache.flink.table.connector.sink.DataStreamSinkProvider;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsOverwrite;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.sink.FlinkSink;
import org.apache.iceberg.flink.sink.IcebergSink;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public class IcebergTableSink
implements DynamicTableSink,
SupportsPartitioning,
SupportsOverwrite {
    private final TableLoader tableLoader;
    @Deprecated
    private final TableSchema tableSchema;
    private final ResolvedSchema resolvedSchema;
    private final ReadableConfig readableConfig;
    private final Map<String, String> writeProps;
    private boolean overwrite = false;

    private IcebergTableSink(IcebergTableSink toCopy) {
        this.tableLoader = toCopy.tableLoader;
        this.tableSchema = toCopy.tableSchema;
        this.resolvedSchema = toCopy.resolvedSchema;
        this.overwrite = toCopy.overwrite;
        this.readableConfig = toCopy.readableConfig;
        this.writeProps = toCopy.writeProps;
    }

    @Deprecated
    public IcebergTableSink(TableLoader tableLoader, TableSchema tableSchema, ReadableConfig readableConfig, Map<String, String> writeProps) {
        this.tableLoader = tableLoader;
        this.tableSchema = tableSchema;
        this.resolvedSchema = null;
        this.readableConfig = readableConfig;
        this.writeProps = writeProps;
    }

    public IcebergTableSink(TableLoader tableLoader, ResolvedSchema resolvedSchema, ReadableConfig readableConfig, Map<String, String> writeProps) {
        this.tableLoader = tableLoader;
        this.tableSchema = null;
        this.resolvedSchema = resolvedSchema;
        this.readableConfig = readableConfig;
        this.writeProps = writeProps;
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        Preconditions.checkState((!this.overwrite || context.isBounded() ? 1 : 0) != 0, (Object)"Unbounded data stream doesn't support overwrite operation.");
        if (this.resolvedSchema != null) {
            final List equalityColumns = this.resolvedSchema.getPrimaryKey().map(UniqueConstraint::getColumns).orElseGet(ImmutableList::of);
            return new DataStreamSinkProvider(){

                public DataStreamSink<?> consumeDataStream(ProviderContext providerContext, DataStream<RowData> dataStream) {
                    if (Boolean.TRUE.equals(IcebergTableSink.this.readableConfig.get(FlinkConfigOptions.TABLE_EXEC_ICEBERG_USE_V2_SINK))) {
                        return ((IcebergSink.Builder)((IcebergSink.Builder)IcebergSink.forRowData(dataStream).tableLoader(IcebergTableSink.this.tableLoader).resolvedSchema(IcebergTableSink.this.resolvedSchema).equalityFieldColumns(equalityColumns)).overwrite(IcebergTableSink.this.overwrite).setAll((Map)IcebergTableSink.this.writeProps)).flinkConf(IcebergTableSink.this.readableConfig).append();
                    }
                    return ((FlinkSink.Builder)((FlinkSink.Builder)FlinkSink.forRowData(dataStream).tableLoader(IcebergTableSink.this.tableLoader).resolvedSchema(IcebergTableSink.this.resolvedSchema).equalityFieldColumns(equalityColumns)).overwrite(IcebergTableSink.this.overwrite).setAll((Map)IcebergTableSink.this.writeProps)).flinkConf(IcebergTableSink.this.readableConfig).append();
                }
            };
        }
        final List equalityColumns = this.tableSchema.getPrimaryKey().map(org.apache.flink.table.api.constraints.UniqueConstraint::getColumns).orElseGet(ImmutableList::of);
        return new DataStreamSinkProvider(){

            public DataStreamSink<?> consumeDataStream(ProviderContext providerContext, DataStream<RowData> dataStream) {
                if (((Boolean)IcebergTableSink.this.readableConfig.get(FlinkConfigOptions.TABLE_EXEC_ICEBERG_USE_V2_SINK)).booleanValue()) {
                    return ((IcebergSink.Builder)((IcebergSink.Builder)IcebergSink.forRowData(dataStream).tableLoader(IcebergTableSink.this.tableLoader).tableSchema(IcebergTableSink.this.tableSchema).equalityFieldColumns(equalityColumns)).overwrite(IcebergTableSink.this.overwrite).setAll((Map)IcebergTableSink.this.writeProps)).flinkConf(IcebergTableSink.this.readableConfig).append();
                }
                return ((FlinkSink.Builder)((FlinkSink.Builder)FlinkSink.forRowData(dataStream).tableLoader(IcebergTableSink.this.tableLoader).tableSchema(IcebergTableSink.this.tableSchema).equalityFieldColumns(equalityColumns)).overwrite(IcebergTableSink.this.overwrite).setAll((Map)IcebergTableSink.this.writeProps)).flinkConf(IcebergTableSink.this.readableConfig).append();
            }
        };
    }

    public void applyStaticPartition(Map<String, String> partition) {
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        for (RowKind kind : requestedMode.getContainedKinds()) {
            builder.addContainedKind(kind);
        }
        return builder.build();
    }

    public DynamicTableSink copy() {
        return new IcebergTableSink(this);
    }

    public String asSummaryString() {
        return "Iceberg table sink";
    }

    public void applyOverwrite(boolean newOverwrite) {
        this.overwrite = newOverwrite;
    }
}

