/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.data.RowDataUtil;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public class FlinkParquetReaders {
    private FlinkParquetReaders() {
    }

    public static ParquetValueReader<RowData> buildReader(Schema expectedSchema, MessageType fileSchema) {
        return FlinkParquetReaders.buildReader(expectedSchema, fileSchema, ImmutableMap.of());
    }

    public static ParquetValueReader<RowData> buildReader(Schema expectedSchema, MessageType fileSchema, Map<Integer, ?> idToConstant) {
        return (ParquetValueReader)TypeWithSchemaVisitor.visit((Type)expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileSchema, (TypeWithSchemaVisitor)new ReadBuilder(fileSchema, idToConstant));
    }

    private static class ReadBuilder
    extends TypeWithSchemaVisitor<ParquetValueReader<?>> {
        private final MessageType type;
        private final Map<Integer, ?> idToConstant;

        ReadBuilder(MessageType type, Map<Integer, ?> idToConstant) {
            this.type = type;
            this.idToConstant = idToConstant;
        }

        public ParquetValueReader<RowData> message(Types.StructType expected, MessageType message, List<ParquetValueReader<?>> fieldReaders) {
            return this.struct(expected, message.asGroupType(), fieldReaders);
        }

        public ParquetValueReader<RowData> struct(Types.StructType expected, GroupType struct, List<ParquetValueReader<?>> fieldReaders) {
            HashMap readersById = Maps.newHashMap();
            HashMap typesById = Maps.newHashMap();
            HashMap maxDefinitionLevelsById = Maps.newHashMap();
            List fields = struct.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                org.apache.parquet.schema.Type fieldType = (org.apache.parquet.schema.Type)fields.get(i);
                if (fieldReaders.get(i) == null) continue;
                int fieldD = this.type.getMaxDefinitionLevel(this.path(fieldType.getName())) - 1;
                if (fieldType.getId() == null) continue;
                int id = fieldType.getId().intValue();
                readersById.put(id, ParquetValueReaders.option((org.apache.parquet.schema.Type)fieldType, (int)fieldD, fieldReaders.get(i)));
                typesById.put(id, fieldType);
                if (!this.idToConstant.containsKey(id)) continue;
                maxDefinitionLevelsById.put(id, fieldD);
            }
            List expectedFields = expected != null ? expected.fields() : ImmutableList.of();
            ArrayList reorderedFields = Lists.newArrayListWithExpectedSize((int)expectedFields.size());
            int defaultMaxDefinitionLevel = this.type.getMaxDefinitionLevel(this.currentPath());
            Iterator iterator = expectedFields.iterator();
            while (iterator.hasNext()) {
                Types.NestedField field = (Types.NestedField)iterator.next();
                int id = field.fieldId();
                ParquetValueReader reader = (ParquetValueReader)readersById.get(id);
                if (this.idToConstant.containsKey(id)) {
                    int fieldMaxDefinitionLevel = maxDefinitionLevelsById.getOrDefault(id, defaultMaxDefinitionLevel);
                    reorderedFields.add(ParquetValueReaders.constant(this.idToConstant.get(id), (int)fieldMaxDefinitionLevel));
                    continue;
                }
                if (id == MetadataColumns.ROW_POSITION.fieldId()) {
                    reorderedFields.add(ParquetValueReaders.position());
                    continue;
                }
                if (id == MetadataColumns.IS_DELETED.fieldId()) {
                    reorderedFields.add(ParquetValueReaders.constant((Object)false));
                    continue;
                }
                if (reader != null) {
                    reorderedFields.add(reader);
                    continue;
                }
                if (field.initialDefault() != null) {
                    reorderedFields.add(ParquetValueReaders.constant((Object)RowDataUtil.convertConstant(field.type(), field.initialDefault()), (int)maxDefinitionLevelsById.getOrDefault(id, defaultMaxDefinitionLevel)));
                    continue;
                }
                if (field.isOptional()) {
                    reorderedFields.add(ParquetValueReaders.nulls());
                    continue;
                }
                throw new IllegalArgumentException(String.format("Missing required field: %s", field.name()));
            }
            return new RowDataReader(reorderedFields);
        }

        public ParquetValueReader<?> list(Types.ListType expectedList, GroupType array, ParquetValueReader<?> elementReader) {
            if (expectedList == null) {
                return null;
            }
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath) - 1;
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath) - 1;
            org.apache.parquet.schema.Type elementType = ParquetSchemaUtil.determineListElementType((GroupType)array);
            int elementD = this.type.getMaxDefinitionLevel(this.path(elementType.getName())) - 1;
            return new ArrayReader(repeatedD, repeatedR, ParquetValueReaders.option((org.apache.parquet.schema.Type)elementType, (int)elementD, elementReader));
        }

        public ParquetValueReader<?> map(Types.MapType expectedMap, GroupType map, ParquetValueReader<?> keyReader, ParquetValueReader<?> valueReader) {
            if (expectedMap == null) {
                return null;
            }
            GroupType repeatedKeyValue = ((org.apache.parquet.schema.Type)map.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath) - 1;
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath) - 1;
            org.apache.parquet.schema.Type keyType = repeatedKeyValue.getType(0);
            int keyD = this.type.getMaxDefinitionLevel(this.path(keyType.getName())) - 1;
            org.apache.parquet.schema.Type valueType = repeatedKeyValue.getType(1);
            int valueD = this.type.getMaxDefinitionLevel(this.path(valueType.getName())) - 1;
            return new MapReader(repeatedD, repeatedR, ParquetValueReaders.option((org.apache.parquet.schema.Type)keyType, (int)keyD, keyReader), ParquetValueReaders.option((org.apache.parquet.schema.Type)valueType, (int)valueD, valueReader));
        }

        public ParquetValueReader<?> primitive(Type.PrimitiveType expected, PrimitiveType primitive) {
            if (expected == null) {
                return null;
            }
            ColumnDescriptor desc = this.type.getColumnDescription(this.currentPath());
            LogicalTypeAnnotation logicalTypeAnnotation = primitive.getLogicalTypeAnnotation();
            if (logicalTypeAnnotation != null) {
                return (ParquetValueReader)logicalTypeAnnotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotationParquetValueReaderVisitor(primitive, desc, expected)).orElseThrow(() -> new UnsupportedOperationException("Unsupported logical type: " + String.valueOf(primitive.getLogicalTypeAnnotation())));
            }
            switch (primitive.getPrimitiveTypeName()) {
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    return new ParquetValueReaders.ByteArrayReader(desc);
                }
                case INT32: {
                    if (expected.typeId() == Type.TypeID.LONG) {
                        return new ParquetValueReaders.IntAsLongReader(desc);
                    }
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
                case FLOAT: {
                    if (expected.typeId() == Type.TypeID.DOUBLE) {
                        return new ParquetValueReaders.FloatAsDoubleReader(desc);
                    }
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
                case INT64: 
                case BOOLEAN: 
                case DOUBLE: {
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(primitive));
        }

        private static class LogicalTypeAnnotationParquetValueReaderVisitor
        implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<ParquetValueReader<?>> {
            private final PrimitiveType primitive;
            private final ColumnDescriptor desc;
            private final Type.PrimitiveType expected;

            LogicalTypeAnnotationParquetValueReaderVisitor(PrimitiveType primitive, ColumnDescriptor desc, Type.PrimitiveType expected) {
                this.primitive = primitive;
                this.desc = desc;
                this.expected = expected;
            }

            public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                return Optional.of(new StringReader(this.desc));
            }

            public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
                return Optional.of(new StringReader(this.desc));
            }

            public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
                return Optional.of(new StringReader(this.desc));
            }

            public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                switch (this.primitive.getPrimitiveTypeName()) {
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        return Optional.of(new BinaryDecimalReader(this.desc, decimalLogicalType.getPrecision(), decimalLogicalType.getScale()));
                    }
                    case INT64: {
                        return Optional.of(new LongDecimalReader(this.desc, decimalLogicalType.getPrecision(), decimalLogicalType.getScale()));
                    }
                    case INT32: {
                        return Optional.of(new IntegerDecimalReader(this.desc, decimalLogicalType.getPrecision(), decimalLogicalType.getScale()));
                    }
                }
                return super.visit(decimalLogicalType);
            }

            public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
                return Optional.of(new ParquetValueReaders.UnboxedReader(this.desc));
            }

            public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                if (timeLogicalType.getUnit() == LogicalTypeAnnotation.TimeUnit.MILLIS) {
                    return Optional.of(new MillisTimeReader(this.desc));
                }
                if (timeLogicalType.getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS) {
                    return Optional.of(new LossyMicrosToMillisTimeReader(this.desc));
                }
                return super.visit(timeLogicalType);
            }

            public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
                if (timestampLogicalType.getUnit() == LogicalTypeAnnotation.TimeUnit.MILLIS) {
                    return Optional.of(new MillisToTimestampReader(this.desc));
                }
                if (timestampLogicalType.getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS) {
                    return Optional.of(new MicrosToTimestampReader(this.desc));
                }
                if (timestampLogicalType.getUnit() == LogicalTypeAnnotation.TimeUnit.NANOS) {
                    return Optional.of(new NanosToTimestampReader(this.desc));
                }
                return super.visit(timestampLogicalType);
            }

            public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
                int width = intLogicalType.getBitWidth();
                if (width <= 32) {
                    if (this.expected.typeId() == Types.LongType.get().typeId()) {
                        return Optional.of(new ParquetValueReaders.IntAsLongReader(this.desc));
                    }
                    return Optional.of(new ParquetValueReaders.UnboxedReader(this.desc));
                }
                if (width <= 64) {
                    return Optional.of(new ParquetValueReaders.UnboxedReader(this.desc));
                }
                return super.visit(intLogicalType);
            }

            public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
                return Optional.of(new ParquetValueReaders.ByteArrayReader(this.desc));
            }
        }
    }

    private static class ReusableArrayData
    implements ArrayData {
        private static final Object[] EMPTY = new Object[0];
        private Object[] values = EMPTY;
        private int numElements = 0;

        private ReusableArrayData() {
        }

        private void grow() {
            if (this.values.length == 0) {
                this.values = new Object[20];
            } else {
                Object[] old = this.values;
                this.values = new Object[old.length << 1];
                System.arraycopy(old, 0, this.values, 0, old.length);
            }
        }

        private int capacity() {
            return this.values.length;
        }

        public void setNumElements(int numElements) {
            this.numElements = numElements;
        }

        public int size() {
            return this.numElements;
        }

        public boolean isNullAt(int ordinal) {
            return null == this.values[ordinal];
        }

        public boolean getBoolean(int ordinal) {
            return (Boolean)this.values[ordinal];
        }

        public byte getByte(int ordinal) {
            return (Byte)this.values[ordinal];
        }

        public short getShort(int ordinal) {
            return (Short)this.values[ordinal];
        }

        public int getInt(int ordinal) {
            return (Integer)this.values[ordinal];
        }

        public long getLong(int ordinal) {
            return (Long)this.values[ordinal];
        }

        public float getFloat(int ordinal) {
            return ((Float)this.values[ordinal]).floatValue();
        }

        public double getDouble(int ordinal) {
            return (Double)this.values[ordinal];
        }

        public StringData getString(int pos) {
            return (StringData)this.values[pos];
        }

        public DecimalData getDecimal(int pos, int precision, int scale) {
            return (DecimalData)this.values[pos];
        }

        public TimestampData getTimestamp(int pos, int precision) {
            return (TimestampData)this.values[pos];
        }

        public <T> RawValueData<T> getRawValue(int pos) {
            return (RawValueData)this.values[pos];
        }

        public byte[] getBinary(int ordinal) {
            return (byte[])this.values[ordinal];
        }

        public ArrayData getArray(int ordinal) {
            return (ArrayData)this.values[ordinal];
        }

        public MapData getMap(int ordinal) {
            return (MapData)this.values[ordinal];
        }

        public RowData getRow(int pos, int numFields) {
            return (RowData)this.values[pos];
        }

        public boolean[] toBooleanArray() {
            return ArrayUtil.toPrimitive((Boolean[])((Boolean[])this.values));
        }

        public byte[] toByteArray() {
            return ArrayUtil.toPrimitive((Byte[])((Byte[])this.values));
        }

        public short[] toShortArray() {
            return ArrayUtil.toPrimitive((Short[])((Short[])this.values));
        }

        public int[] toIntArray() {
            return ArrayUtil.toPrimitive((Integer[])((Integer[])this.values));
        }

        public long[] toLongArray() {
            return ArrayUtil.toPrimitive((Long[])((Long[])this.values));
        }

        public float[] toFloatArray() {
            return ArrayUtil.toPrimitive((Float[])((Float[])this.values));
        }

        public double[] toDoubleArray() {
            return ArrayUtil.toPrimitive((Double[])((Double[])this.values));
        }
    }

    private static class ReusableMapData
    implements MapData {
        private final ReusableArrayData keys = new ReusableArrayData();
        private final ReusableArrayData values = new ReusableArrayData();
        private int numElements;

        private ReusableMapData() {
        }

        private void grow() {
            this.keys.grow();
            this.values.grow();
        }

        private int capacity() {
            return this.keys.capacity();
        }

        public void setNumElements(int numElements) {
            this.numElements = numElements;
            this.keys.setNumElements(numElements);
            this.values.setNumElements(numElements);
        }

        public int size() {
            return this.numElements;
        }

        public ReusableArrayData keyArray() {
            return this.keys;
        }

        public ReusableArrayData valueArray() {
            return this.values;
        }
    }

    private static class RowDataReader
    extends ParquetValueReaders.StructReader<RowData, GenericRowData> {
        private final int numFields;

        RowDataReader(List<ParquetValueReader<?>> readers) {
            super(readers);
            this.numFields = readers.size();
        }

        protected GenericRowData newStructData(RowData reuse) {
            if (reuse instanceof GenericRowData) {
                return (GenericRowData)reuse;
            }
            return new GenericRowData(this.numFields);
        }

        protected Object getField(GenericRowData intermediate, int pos) {
            return intermediate.getField(pos);
        }

        protected RowData buildStruct(GenericRowData struct) {
            return struct;
        }

        protected void set(GenericRowData row, int pos, Object value) {
            row.setField(pos, value);
        }

        protected void setNull(GenericRowData row, int pos) {
            row.setField(pos, null);
        }

        protected void setBoolean(GenericRowData row, int pos, boolean value) {
            row.setField(pos, (Object)value);
        }

        protected void setInteger(GenericRowData row, int pos, int value) {
            row.setField(pos, (Object)value);
        }

        protected void setLong(GenericRowData row, int pos, long value) {
            row.setField(pos, (Object)value);
        }

        protected void setFloat(GenericRowData row, int pos, float value) {
            row.setField(pos, (Object)Float.valueOf(value));
        }

        protected void setDouble(GenericRowData row, int pos, double value) {
            row.setField(pos, (Object)value);
        }
    }

    private static class MapReader<K, V>
    extends ParquetValueReaders.RepeatedKeyValueReader<MapData, ReusableMapData, K, V> {
        private int readPos = 0;
        private int writePos = 0;
        private final ParquetValueReaders.ReusableEntry<K, V> entry = new ParquetValueReaders.ReusableEntry();
        private final ParquetValueReaders.ReusableEntry<K, V> nullEntry = new ParquetValueReaders.ReusableEntry();

        MapReader(int definitionLevel, int repetitionLevel, ParquetValueReader<K> keyReader, ParquetValueReader<V> valueReader) {
            super(definitionLevel, repetitionLevel, keyReader, valueReader);
        }

        protected ReusableMapData newMapData(MapData reuse) {
            this.readPos = 0;
            this.writePos = 0;
            if (reuse instanceof ReusableMapData) {
                return (ReusableMapData)reuse;
            }
            return new ReusableMapData();
        }

        protected Map.Entry<K, V> getPair(ReusableMapData map) {
            ParquetValueReaders.ReusableEntry<K, V> kv = this.nullEntry;
            if (this.readPos < map.capacity()) {
                this.entry.set(map.keys.values[this.readPos], map.values.values[this.readPos]);
                kv = this.entry;
            }
            ++this.readPos;
            return kv;
        }

        protected void addPair(ReusableMapData map, K key, V value) {
            if (this.writePos >= map.capacity()) {
                map.grow();
            }
            map.keys.values[this.writePos] = key;
            map.values.values[this.writePos] = value;
            ++this.writePos;
        }

        protected MapData buildMap(ReusableMapData map) {
            map.setNumElements(this.writePos);
            return map;
        }
    }

    private static class ArrayReader<E>
    extends ParquetValueReaders.RepeatedReader<ArrayData, ReusableArrayData, E> {
        private int readPos = 0;
        private int writePos = 0;

        ArrayReader(int definitionLevel, int repetitionLevel, ParquetValueReader<E> reader) {
            super(definitionLevel, repetitionLevel, reader);
        }

        protected ReusableArrayData newListData(ArrayData reuse) {
            this.readPos = 0;
            this.writePos = 0;
            if (reuse instanceof ReusableArrayData) {
                return (ReusableArrayData)reuse;
            }
            return new ReusableArrayData();
        }

        protected E getElement(ReusableArrayData list) {
            Object value = null;
            if (this.readPos < list.capacity()) {
                value = list.values[this.readPos];
            }
            ++this.readPos;
            return (E)value;
        }

        protected void addElement(ReusableArrayData reused, E element) {
            if (this.writePos >= reused.capacity()) {
                reused.grow();
            }
            reused.values[this.writePos] = element;
            ++this.writePos;
        }

        protected ArrayData buildList(ReusableArrayData list) {
            return new GenericArrayData(Arrays.copyOf(list.values, this.writePos));
        }
    }

    private static class MillisTimeReader
    extends ParquetValueReaders.PrimitiveReader<Integer> {
        MillisTimeReader(ColumnDescriptor desc) {
            super(desc);
        }

        public Integer read(Integer reuse) {
            return (int)this.column.nextLong();
        }
    }

    private static class LossyMicrosToMillisTimeReader
    extends ParquetValueReaders.PrimitiveReader<Integer> {
        LossyMicrosToMillisTimeReader(ColumnDescriptor desc) {
            super(desc);
        }

        public Integer read(Integer reuse) {
            return (int)Math.floorDiv(this.column.nextLong(), 1000L);
        }
    }

    private static class StringReader
    extends ParquetValueReaders.PrimitiveReader<StringData> {
        StringReader(ColumnDescriptor desc) {
            super(desc);
        }

        public StringData read(StringData ignored) {
            Binary binary = this.column.nextBinary();
            ByteBuffer buffer = binary.toByteBuffer();
            if (buffer.hasArray()) {
                return StringData.fromBytes((byte[])buffer.array(), (int)(buffer.arrayOffset() + buffer.position()), (int)buffer.remaining());
            }
            return StringData.fromBytes((byte[])binary.getBytes());
        }
    }

    private static class MillisToTimestampReader
    extends ParquetValueReaders.UnboxedReader<TimestampData> {
        MillisToTimestampReader(ColumnDescriptor desc) {
            super(desc);
        }

        public TimestampData read(TimestampData ignored) {
            long millis = this.readLong();
            return TimestampData.fromEpochMillis((long)millis);
        }
    }

    private static class MicrosToTimestampReader
    extends ParquetValueReaders.UnboxedReader<TimestampData> {
        MicrosToTimestampReader(ColumnDescriptor desc) {
            super(desc);
        }

        public TimestampData read(TimestampData ignored) {
            long micros = this.readLong();
            return TimestampData.fromEpochMillis((long)Math.floorDiv(micros, 1000L), (int)(Math.floorMod(micros, 1000) * 1000));
        }
    }

    private static class NanosToTimestampReader
    extends ParquetValueReaders.UnboxedReader<TimestampData> {
        NanosToTimestampReader(ColumnDescriptor desc) {
            super(desc);
        }

        public TimestampData read(TimestampData ignored) {
            long value = this.readLong();
            return TimestampData.fromEpochMillis((long)Math.floorDiv(value, 1000000L), (int)Math.floorMod(value, 1000000));
        }
    }

    private static class LongDecimalReader
    extends ParquetValueReaders.PrimitiveReader<DecimalData> {
        private final int precision;
        private final int scale;

        LongDecimalReader(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        public DecimalData read(DecimalData ignored) {
            return DecimalData.fromUnscaledLong((long)this.column.nextLong(), (int)this.precision, (int)this.scale);
        }
    }

    private static class IntegerDecimalReader
    extends ParquetValueReaders.PrimitiveReader<DecimalData> {
        private final int precision;
        private final int scale;

        IntegerDecimalReader(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        public DecimalData read(DecimalData ignored) {
            return DecimalData.fromUnscaledLong((long)this.column.nextInteger(), (int)this.precision, (int)this.scale);
        }
    }

    private static class BinaryDecimalReader
    extends ParquetValueReaders.PrimitiveReader<DecimalData> {
        private final int precision;
        private final int scale;

        BinaryDecimalReader(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        public DecimalData read(DecimalData ignored) {
            Binary binary = this.column.nextBinary();
            BigDecimal bigDecimal = new BigDecimal(new BigInteger(binary.getBytes()), this.scale);
            return DecimalData.fromBigDecimal((BigDecimal)bigDecimal, (int)this.precision, (int)this.scale);
        }
    }
}

