/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetWithFlinkSchemaVisitor<T> {
    private final Deque<String> fieldNames = Lists.newLinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T visit(LogicalType sType, Type type, ParquetWithFlinkSchemaVisitor<T> visitor) {
        Preconditions.checkArgument((sType != null ? 1 : 0) != 0, (Object)"Invalid DataType: null");
        if (type instanceof MessageType) {
            Preconditions.checkArgument((boolean)(sType instanceof RowType), (String)"Invalid struct: %s is not a struct", (Object)sType);
            RowType struct = (RowType)sType;
            return visitor.message(struct, (MessageType)type, ParquetWithFlinkSchemaVisitor.visitFields(struct, type.asGroupType(), visitor));
        }
        if (type.isPrimitive()) {
            return visitor.primitive(sType, type.asPrimitiveType());
        }
        GroupType group = type.asGroupType();
        LogicalTypeAnnotation annotation = group.getLogicalTypeAnnotation();
        if (annotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
            Preconditions.checkArgument((!group.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Invalid list: top-level group is repeated: %s", (Object)group);
            Preconditions.checkArgument((group.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Invalid list: does not contain single repeated field: %s", (Object)group);
            GroupType repeatedElement = ((Type)group.getFields().get(0)).asGroupType();
            Preconditions.checkArgument((boolean)repeatedElement.isRepetition(Type.Repetition.REPEATED), (Object)"Invalid list: inner group is not repeated");
            Preconditions.checkArgument((repeatedElement.getFieldCount() <= 1 ? 1 : 0) != 0, (String)"Invalid list: repeated group is not a single field: %s", (Object)group);
            Preconditions.checkArgument((boolean)(sType instanceof ArrayType), (String)"Invalid list: %s is not an array", (Object)sType);
            ArrayType array = (ArrayType)sType;
            RowType.RowField element = new RowType.RowField("element", array.getElementType(), "element of " + array.asSummaryString());
            visitor.fieldNames.push(repeatedElement.getName());
            try {
                T elementResult = null;
                if (repeatedElement.getFieldCount() > 0) {
                    elementResult = ParquetWithFlinkSchemaVisitor.visitField(element, repeatedElement.getType(0), visitor);
                }
                T t = visitor.list(array, group, elementResult);
                return t;
            }
            finally {
                visitor.fieldNames.pop();
            }
        }
        if (annotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation) {
            Preconditions.checkArgument((!group.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Invalid map: top-level group is repeated: %s", (Object)group);
            Preconditions.checkArgument((group.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Invalid map: does not contain single repeated field: %s", (Object)group);
            GroupType repeatedKeyValue = group.getType(0).asGroupType();
            Preconditions.checkArgument((boolean)repeatedKeyValue.isRepetition(Type.Repetition.REPEATED), (Object)"Invalid map: inner group is not repeated");
            Preconditions.checkArgument((repeatedKeyValue.getFieldCount() <= 2 ? 1 : 0) != 0, (Object)"Invalid map: repeated group does not have 2 fields");
            Preconditions.checkArgument((boolean)(sType instanceof MapType), (String)"Invalid map: %s is not a map", (Object)sType);
            MapType map = (MapType)sType;
            RowType.RowField keyField = new RowType.RowField("key", map.getKeyType(), "key of " + map.asSummaryString());
            RowType.RowField valueField = new RowType.RowField("value", map.getValueType(), "value of " + map.asSummaryString());
            visitor.fieldNames.push(repeatedKeyValue.getName());
            try {
                T keyResult = null;
                T valueResult = null;
                switch (repeatedKeyValue.getFieldCount()) {
                    case 2: {
                        keyResult = ParquetWithFlinkSchemaVisitor.visitField(keyField, repeatedKeyValue.getType(0), visitor);
                        valueResult = ParquetWithFlinkSchemaVisitor.visitField(valueField, repeatedKeyValue.getType(1), visitor);
                        break;
                    }
                    case 1: {
                        Type keyOrValue = repeatedKeyValue.getType(0);
                        if (keyOrValue.getName().equalsIgnoreCase("key")) {
                            keyResult = ParquetWithFlinkSchemaVisitor.visitField(keyField, keyOrValue, visitor);
                            break;
                        }
                        valueResult = ParquetWithFlinkSchemaVisitor.visitField(valueField, keyOrValue, visitor);
                        break;
                    }
                }
                T t = visitor.map(map, group, keyResult, valueResult);
                return t;
            }
            finally {
                visitor.fieldNames.pop();
            }
        }
        Preconditions.checkArgument((boolean)(sType instanceof RowType), (String)"Invalid struct: %s is not a struct", (Object)sType);
        RowType struct = (RowType)sType;
        return visitor.struct(struct, group, ParquetWithFlinkSchemaVisitor.visitFields(struct, group, visitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T visitField(RowType.RowField sField, Type field, ParquetWithFlinkSchemaVisitor<T> visitor) {
        visitor.fieldNames.push(field.getName());
        try {
            T t = ParquetWithFlinkSchemaVisitor.visit(sField.getType(), field, visitor);
            return t;
        }
        finally {
            visitor.fieldNames.pop();
        }
    }

    private static <T> List<T> visitFields(RowType struct, GroupType group, ParquetWithFlinkSchemaVisitor<T> visitor) {
        List sFields = struct.getFields();
        ArrayList results = Lists.newArrayListWithExpectedSize((int)group.getFieldCount());
        int pos = 0;
        for (RowType.RowField sField : sFields) {
            if (sField.getType().getTypeRoot() == LogicalTypeRoot.NULL) continue;
            Type field = (Type)group.getFields().get(pos);
            Preconditions.checkArgument((boolean)field.getName().equals(AvroSchemaUtil.makeCompatibleName((String)sField.getName())), (String)"Structs do not match: field %s != %s", (Object)field.getName(), (Object)sField.getName());
            results.add(ParquetWithFlinkSchemaVisitor.visitField(sField, field, visitor));
            ++pos;
        }
        return results;
    }

    public T message(RowType sStruct, MessageType message, List<T> fields) {
        return null;
    }

    public T struct(RowType sStruct, GroupType struct, List<T> fields) {
        return null;
    }

    public T list(ArrayType sArray, GroupType array, T element) {
        return null;
    }

    public T map(MapType sMap, GroupType map, T key, T value) {
        return null;
    }

    public T primitive(LogicalType sPrimitive, PrimitiveType primitive) {
        return null;
    }

    protected String[] currentPath() {
        return Lists.newArrayList(this.fieldNames.descendingIterator()).toArray(new String[0]);
    }

    protected String[] path(String name) {
        ArrayList list = Lists.newArrayList(this.fieldNames.descendingIterator());
        list.add(name);
        return list.toArray(new String[0]);
    }
}

