/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.RowKind;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;

@Internal
public class StructRowData
implements RowData {
    private final Types.StructType type;
    private RowKind kind;
    private StructLike struct;

    public StructRowData(Types.StructType type) {
        this(type, RowKind.INSERT);
    }

    public StructRowData(Types.StructType type, RowKind kind) {
        this(type, null, kind);
    }

    private StructRowData(Types.StructType type, StructLike struct) {
        this(type, struct, RowKind.INSERT);
    }

    private StructRowData(Types.StructType type, StructLike struct, RowKind kind) {
        this.type = type;
        this.struct = struct;
        this.kind = kind;
    }

    public StructRowData setStruct(StructLike newStruct) {
        this.struct = newStruct;
        return this;
    }

    public int getArity() {
        return this.struct.size();
    }

    public RowKind getRowKind() {
        return this.kind;
    }

    public void setRowKind(RowKind newKind) {
        Preconditions.checkNotNull((Object)newKind, (Object)"kind can not be null");
        this.kind = newKind;
    }

    public boolean isNullAt(int pos) {
        return this.struct.get(pos, Object.class) == null;
    }

    public boolean getBoolean(int pos) {
        return (Boolean)this.struct.get(pos, Boolean.class);
    }

    public byte getByte(int pos) {
        return (byte)((Integer)this.struct.get(pos, Integer.class)).intValue();
    }

    public short getShort(int pos) {
        return (short)((Integer)this.struct.get(pos, Integer.class)).intValue();
    }

    public int getInt(int pos) {
        Object integer = this.struct.get(pos, Object.class);
        if (integer instanceof Integer) {
            return (Integer)integer;
        }
        if (integer instanceof LocalDate) {
            return (int)((LocalDate)integer).toEpochDay();
        }
        if (integer instanceof LocalTime) {
            return (int)(((LocalTime)integer).toNanoOfDay() / 1000000L);
        }
        throw new IllegalStateException("Unknown type for int field. Type name: " + integer.getClass().getName());
    }

    public long getLong(int pos) {
        Object longVal = this.struct.get(pos, Object.class);
        if (longVal instanceof Long) {
            return (Long)longVal;
        }
        if (longVal instanceof OffsetDateTime) {
            return Duration.between(Instant.EPOCH, (OffsetDateTime)longVal).toNanos() / 1000L;
        }
        if (longVal instanceof LocalDate) {
            return ((LocalDate)longVal).toEpochDay();
        }
        if (longVal instanceof LocalTime) {
            return ((LocalTime)longVal).toNanoOfDay();
        }
        if (longVal instanceof LocalDateTime) {
            return Duration.between(Instant.EPOCH, ((LocalDateTime)longVal).atOffset(ZoneOffset.UTC)).toNanos() / 1000L;
        }
        throw new IllegalStateException("Unknown type for long field. Type name: " + longVal.getClass().getName());
    }

    public float getFloat(int pos) {
        return ((Float)this.struct.get(pos, Float.class)).floatValue();
    }

    public double getDouble(int pos) {
        return (Double)this.struct.get(pos, Double.class);
    }

    public StringData getString(int pos) {
        return this.isNullAt(pos) ? null : this.getStringDataInternal(pos);
    }

    private StringData getStringDataInternal(int pos) {
        CharSequence seq = (CharSequence)this.struct.get(pos, CharSequence.class);
        return StringData.fromString((String)seq.toString());
    }

    public DecimalData getDecimal(int pos, int precision, int scale) {
        return this.isNullAt(pos) ? null : DecimalData.fromBigDecimal((BigDecimal)this.getDecimalInternal(pos), (int)precision, (int)scale);
    }

    private BigDecimal getDecimalInternal(int pos) {
        return (BigDecimal)this.struct.get(pos, BigDecimal.class);
    }

    public TimestampData getTimestamp(int pos, int precision) {
        long timeLong = this.getLong(pos);
        return TimestampData.fromEpochMillis((long)(timeLong / 1000L), (int)((int)(timeLong % 1000L) * 1000));
    }

    public <T> RawValueData<T> getRawValue(int pos) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] getBinary(int pos) {
        return this.isNullAt(pos) ? null : this.getBinaryInternal(pos);
    }

    private byte[] getBinaryInternal(int pos) {
        Object bytes = this.struct.get(pos, Object.class);
        if (bytes instanceof ByteBuffer) {
            return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)bytes));
        }
        if (bytes instanceof byte[]) {
            return (byte[])bytes;
        }
        if (bytes instanceof UUID) {
            UUID uuid = (UUID)bytes;
            ByteBuffer bb = ByteBuffer.allocate(16);
            bb.putLong(uuid.getMostSignificantBits());
            bb.putLong(uuid.getLeastSignificantBits());
            return bb.array();
        }
        throw new IllegalStateException("Unknown type for binary field. Type name: " + bytes.getClass().getName());
    }

    public ArrayData getArray(int pos) {
        return this.isNullAt(pos) ? null : (ArrayData)this.convertValue((Type)((Types.NestedField)this.type.fields().get(pos)).type().asListType(), this.struct.get(pos, List.class));
    }

    public MapData getMap(int pos) {
        return this.isNullAt(pos) ? null : (MapData)this.convertValue((Type)((Types.NestedField)this.type.fields().get(pos)).type().asMapType(), this.struct.get(pos, Map.class));
    }

    public RowData getRow(int pos, int numFields) {
        return this.isNullAt(pos) ? null : this.getStructRowData(pos);
    }

    private StructRowData getStructRowData(int pos) {
        return new StructRowData(((Types.NestedField)this.type.fields().get(pos)).type().asStructType(), (StructLike)this.struct.get(pos, StructLike.class));
    }

    private Object convertValue(Type elementType, Object value) {
        switch (elementType.typeId()) {
            case BOOLEAN: 
            case INTEGER: 
            case DATE: 
            case TIME: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return value;
            }
            case TIMESTAMP: {
                long millisecond = (Long)value / 1000L;
                int nanoOfMillisecond = (int)((Long)value % 1000L) * 1000;
                return TimestampData.fromEpochMillis((long)millisecond, (int)nanoOfMillisecond);
            }
            case STRING: {
                return StringData.fromString((String)value.toString());
            }
            case FIXED: 
            case BINARY: {
                return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)value));
            }
            case STRUCT: {
                return new StructRowData(elementType.asStructType(), (StructLike)value);
            }
            case LIST: {
                List list = (List)value;
                Object[] array = new Object[list.size()];
                int index = 0;
                for (Object element : list) {
                    array[index] = element == null ? null : this.convertValue(elementType.asListType().elementType(), element);
                    ++index;
                }
                return new GenericArrayData(array);
            }
            case MAP: {
                Types.MapType mapType = elementType.asMapType();
                Set entries = ((Map)value).entrySet();
                HashMap result = Maps.newHashMap();
                for (Map.Entry entry : entries) {
                    Object keyValue = this.convertValue(mapType.keyType(), entry.getKey());
                    Object valueValue = this.convertValue(mapType.valueType(), entry.getValue());
                    result.put(keyValue, valueValue);
                }
                return new GenericMapData((Map)result);
            }
        }
        throw new UnsupportedOperationException("Unsupported element type: " + String.valueOf(elementType));
    }
}

