/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.api;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkConfParser;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class LockConfig {
    public static final String PREFIX = "flink-maintenance.lock.";
    public static final ConfigOption<String> LOCK_TYPE_OPTION = ConfigOptions.key((String)"flink-maintenance.lock.type").stringType().defaultValue((Object)"").withDescription("The type of lock to use, e.g., jdbc or zookeeper.");
    public static final ConfigOption<String> LOCK_ID_OPTION = ConfigOptions.key((String)"flink-maintenance.lock.lock-id").stringType().defaultValue((Object)"").withDescription("The unique identifier for the lock.");
    private final FlinkConfParser confParser;
    private final Map<String, String> writeProperties;
    private final Map<String, String> setProperties;

    public LockConfig(Table table, Map<String, String> writeOptions, ReadableConfig readableConfig) {
        this.writeProperties = writeOptions;
        this.setProperties = readableConfig.toMap();
        this.confParser = new FlinkConfParser(table, writeOptions, readableConfig);
    }

    public String lockType() {
        return ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(LOCK_TYPE_OPTION.key())).flinkConfig(LOCK_TYPE_OPTION)).defaultValue((String)LOCK_TYPE_OPTION.defaultValue()).parse();
    }

    public String lockId(String defaultValue) {
        String lockId = ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(LOCK_ID_OPTION.key())).flinkConfig(LOCK_ID_OPTION)).defaultValue((String)LOCK_ID_OPTION.defaultValue()).parse();
        if (StringUtils.isBlank((CharSequence)lockId)) {
            return defaultValue;
        }
        return lockId;
    }

    public String jdbcUri() {
        return ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(JdbcLockConfig.JDBC_URI_OPTION.key())).flinkConfig(JdbcLockConfig.JDBC_URI_OPTION)).defaultValue((String)JdbcLockConfig.JDBC_URI_OPTION.defaultValue()).parse();
    }

    public String jdbcInitTable() {
        return ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(JdbcLockConfig.JDBC_INIT_LOCK_TABLE_OPTION.key())).flinkConfig(JdbcLockConfig.JDBC_INIT_LOCK_TABLE_OPTION)).defaultValue((String)JdbcLockConfig.JDBC_INIT_LOCK_TABLE_OPTION.defaultValue()).parse();
    }

    public String zkUri() {
        return ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(ZkLockConfig.ZK_URI_OPTION.key())).flinkConfig(ZkLockConfig.ZK_URI_OPTION)).defaultValue((String)ZkLockConfig.ZK_URI_OPTION.defaultValue()).parse();
    }

    public int zkSessionTimeoutMs() {
        return ((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)this.confParser.intConf().option(ZkLockConfig.ZK_SESSION_TIMEOUT_MS_OPTION.key())).flinkConfig(ZkLockConfig.ZK_SESSION_TIMEOUT_MS_OPTION)).defaultValue((Integer)ZkLockConfig.ZK_SESSION_TIMEOUT_MS_OPTION.defaultValue()).parse();
    }

    public int zkConnectionTimeoutMs() {
        return ((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)this.confParser.intConf().option(ZkLockConfig.ZK_CONNECTION_TIMEOUT_MS_OPTION.key())).flinkConfig(ZkLockConfig.ZK_CONNECTION_TIMEOUT_MS_OPTION)).defaultValue((Integer)ZkLockConfig.ZK_CONNECTION_TIMEOUT_MS_OPTION.defaultValue()).parse();
    }

    public int zkBaseSleepMs() {
        return ((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)this.confParser.intConf().option(ZkLockConfig.ZK_BASE_SLEEP_MS_OPTION.key())).flinkConfig(ZkLockConfig.ZK_BASE_SLEEP_MS_OPTION)).defaultValue((Integer)ZkLockConfig.ZK_BASE_SLEEP_MS_OPTION.defaultValue()).parse();
    }

    public int zkMaxRetries() {
        return ((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)this.confParser.intConf().option(ZkLockConfig.ZK_MAX_RETRIES_OPTION.key())).flinkConfig(ZkLockConfig.ZK_MAX_RETRIES_OPTION)).defaultValue((Integer)ZkLockConfig.ZK_MAX_RETRIES_OPTION.defaultValue()).parse();
    }

    public Map<String, String> properties() {
        HashMap mergeConfig = Maps.newHashMap();
        mergeConfig.putAll(this.setProperties);
        mergeConfig.putAll(this.writeProperties);
        return mergeConfig.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(PREFIX)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(PREFIX.length()), Map.Entry::getValue, (existing, replacement) -> existing, Maps::newHashMap));
    }

    public static class JdbcLockConfig {
        public static final String JDBC = "jdbc";
        public static final ConfigOption<String> JDBC_URI_OPTION = ConfigOptions.key((String)"flink-maintenance.lock.jdbc.uri").stringType().defaultValue((Object)"").withDescription("The URI of the JDBC connection for acquiring the lock.");
        public static final ConfigOption<String> JDBC_INIT_LOCK_TABLE_OPTION = ConfigOptions.key((String)"flink-maintenance.lock.jdbc.init-lock-table").stringType().defaultValue((Object)Boolean.FALSE.toString()).withDescription("Whether to initialize the lock table in the JDBC database.");
    }

    public static class ZkLockConfig {
        public static final String ZK = "zookeeper";
        public static final ConfigOption<String> ZK_URI_OPTION = ConfigOptions.key((String)"flink-maintenance.lock.zookeeper.uri").stringType().defaultValue((Object)"").withDescription("The URI of the Zookeeper service for acquiring the lock.");
        public static final ConfigOption<Integer> ZK_SESSION_TIMEOUT_MS_OPTION = ConfigOptions.key((String)"flink-maintenance.lock.zookeeper.session-timeout-ms").intType().defaultValue((Object)60000).withDescription("The session timeout (in milliseconds) for the Zookeeper client.");
        public static final ConfigOption<Integer> ZK_CONNECTION_TIMEOUT_MS_OPTION = ConfigOptions.key((String)"flink-maintenance.lock.zookeeper.connection-timeout-ms").intType().defaultValue((Object)15000).withDescription("The connection timeout (in milliseconds) for the Zookeeper client.");
        public static final ConfigOption<Integer> ZK_BASE_SLEEP_MS_OPTION = ConfigOptions.key((String)"flink-maintenance.lock.zookeeper.base-sleep-ms").intType().defaultValue((Object)3000).withDescription("The base sleep time (in milliseconds) between retries for the Zookeeper client.");
        public static final ConfigOption<Integer> ZK_MAX_RETRIES_OPTION = ConfigOptions.key((String)"flink-maintenance.lock.zookeeper.max-retries").intType().defaultValue((Object)3).withDescription("The maximum number of retries for the Zookeeper client.");
    }
}

