/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.api;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkConfParser;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class RewriteDataFilesConfig {
    public static final String PREFIX = "flink-maintenance.rewrite.";
    public static final String MAX_BYTES = "flink-maintenance.rewrite.max-bytes";
    public static final ConfigOption<Long> MAX_BYTES_OPTION = ConfigOptions.key((String)"flink-maintenance.rewrite.max-bytes").longType().defaultValue((Object)Long.MAX_VALUE).withDescription("The maximum number of bytes allowed for a rewrite operation. If the total size of data files exceeds this limit, the rewrites within one scheduled compaction will be limited in size to restrict the resources used by the compaction.");
    public static final ConfigOption<Integer> PARTIAL_PROGRESS_MAX_COMMITS_OPTION = ConfigOptions.key((String)"flink-maintenance.rewrite.partial-progress.max-commits").intType().defaultValue((Object)10).withDescription("The maximum number of commits allowed when partial progress is enabled. This configuration controls how many file groups are committed per run when partial progress is enabled.");
    public static final ConfigOption<Boolean> PARTIAL_PROGRESS_ENABLED_OPTION = ConfigOptions.key((String)"flink-maintenance.rewrite.partial-progress.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to enable partial progress commits. When enabled, the rewrite operation will commit by file group, allowing progress even if some file groups fail to commit.");
    public static final String SCHEDULE_ON_COMMIT_COUNT = "flink-maintenance.rewrite.schedule.commit-count";
    public static final ConfigOption<Integer> SCHEDULE_ON_COMMIT_COUNT_OPTION = ConfigOptions.key((String)"flink-maintenance.rewrite.schedule.commit-count").intType().defaultValue((Object)10).withDescription("The number of commits after which to trigger a new rewrite operation. This setting controls the frequency of rewrite operations.");
    public static final String SCHEDULE_ON_DATA_FILE_COUNT = "flink-maintenance.rewrite.schedule.data-file-count";
    public static final ConfigOption<Integer> SCHEDULE_ON_DATA_FILE_COUNT_OPTION = ConfigOptions.key((String)"flink-maintenance.rewrite.schedule.data-file-count").intType().defaultValue((Object)1000).withDescription("The number of data files that should trigger a new rewrite operation.");
    public static final String SCHEDULE_ON_DATA_FILE_SIZE = "flink-maintenance.rewrite.schedule.data-file-size";
    public static final ConfigOption<Long> SCHEDULE_ON_DATA_FILE_SIZE_OPTION = ConfigOptions.key((String)"flink-maintenance.rewrite.schedule.data-file-size").longType().defaultValue((Object)0x1900000000L).withDescription("The total size of data files that should trigger a new rewrite operation.");
    public static final String SCHEDULE_ON_INTERVAL_SECOND = "flink-maintenance.rewrite.schedule.interval-second";
    public static final ConfigOption<Long> SCHEDULE_ON_INTERVAL_SECOND_OPTION = ConfigOptions.key((String)"flink-maintenance.rewrite.schedule.interval-second").longType().defaultValue((Object)600L).withDescription("The time interval (in seconds) between two consecutive rewrite operations. This ensures periodic scheduling of rewrite tasks.");
    private final FlinkConfParser confParser;
    private final Map<String, String> writeProperties;

    public RewriteDataFilesConfig(Table table, Map<String, String> writeOptions, ReadableConfig readableConfig) {
        this.writeProperties = writeOptions;
        this.confParser = new FlinkConfParser(table, writeOptions, readableConfig);
    }

    public int scheduleOnCommitCount() {
        return ((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)this.confParser.intConf().option(SCHEDULE_ON_COMMIT_COUNT)).flinkConfig(SCHEDULE_ON_COMMIT_COUNT_OPTION)).defaultValue((Integer)SCHEDULE_ON_COMMIT_COUNT_OPTION.defaultValue()).parse();
    }

    public int scheduleOnDataFileCount() {
        return ((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)this.confParser.intConf().option(SCHEDULE_ON_DATA_FILE_COUNT)).flinkConfig(SCHEDULE_ON_DATA_FILE_COUNT_OPTION)).defaultValue((Integer)SCHEDULE_ON_DATA_FILE_COUNT_OPTION.defaultValue()).parse();
    }

    public long scheduleOnDataFileSize() {
        return ((FlinkConfParser.LongConfParser)((FlinkConfParser.LongConfParser)this.confParser.longConf().option(SCHEDULE_ON_DATA_FILE_SIZE)).flinkConfig(SCHEDULE_ON_DATA_FILE_SIZE_OPTION)).defaultValue((Long)SCHEDULE_ON_DATA_FILE_SIZE_OPTION.defaultValue()).parse();
    }

    public long scheduleOnIntervalSecond() {
        return ((FlinkConfParser.LongConfParser)((FlinkConfParser.LongConfParser)this.confParser.longConf().option(SCHEDULE_ON_INTERVAL_SECOND)).flinkConfig(SCHEDULE_ON_INTERVAL_SECOND_OPTION)).defaultValue((Long)SCHEDULE_ON_INTERVAL_SECOND_OPTION.defaultValue()).parse();
    }

    public boolean partialProgressEnable() {
        return ((FlinkConfParser.BooleanConfParser)((FlinkConfParser.BooleanConfParser)this.confParser.booleanConf().option(PARTIAL_PROGRESS_ENABLED_OPTION.key())).flinkConfig(PARTIAL_PROGRESS_ENABLED_OPTION)).defaultValue((Boolean)PARTIAL_PROGRESS_ENABLED_OPTION.defaultValue()).parse();
    }

    public int partialProgressMaxCommits() {
        return ((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)this.confParser.intConf().option(PARTIAL_PROGRESS_MAX_COMMITS_OPTION.key())).flinkConfig(PARTIAL_PROGRESS_MAX_COMMITS_OPTION)).defaultValue((Integer)PARTIAL_PROGRESS_MAX_COMMITS_OPTION.defaultValue()).parse();
    }

    public long maxRewriteBytes() {
        return ((FlinkConfParser.LongConfParser)((FlinkConfParser.LongConfParser)this.confParser.longConf().option(MAX_BYTES)).flinkConfig(MAX_BYTES_OPTION)).defaultValue((Long)MAX_BYTES_OPTION.defaultValue()).parse();
    }

    public Map<String, String> properties() {
        return this.writeProperties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(PREFIX)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(PREFIX.length()), Map.Entry::getValue, (existing, replacement) -> existing, Maps::newHashMap));
    }
}

